/* get.c -- 
 * Created: Fri May  5 20:03:35 1995 by r.faith@ieee.org
 * Revised: Sun May  7 19:35:56 1995 by r.faith@ieee.org
 * Copyright 1995 Rickard E. Faith (r.faith@ieee.org)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: get.c,v 1.2 1995/08/12 21:33:16 faith Exp $
 * 
 */

#include "pmlib.h"
#include <sys/utsname.h>

#define PM_MAX_NAME 100

const char *pm_get_user_name( void )
{
   static char   buf[PM_MAX_NAME];
   struct passwd *pw;

   if (!(pw = getpwuid( getuid() )))
      pm_fatal( PMERR_NOUSER, "\n" );
   if (strlen( pw->pw_name ) >= PM_MAX_NAME)
      pm_fatal( PMERR_TOOLONG, "%s\n", pw->pw_name );
   strcpy( buf, pw->pw_name );
   return buf;
}

const char *pm_get_group_name( void )
{
   static char   buf[PM_MAX_NAME];
   struct group  *gr;

   if (!(gr = getgrgid( getgid() )))
      pm_fatal( PMERR_NOGROUP, "\n" );
   if (strlen( gr->gr_name ) >= PM_MAX_NAME)
      pm_fatal( PMERR_TOOLONG, "%s\n", gr->gr_name );
   strcpy( buf, gr->gr_name );
   return buf;
}

const char *pm_get_host_name( void )
{
    static char   buf[PM_MAX_NAME];
    struct utsname uts;

    if (uname(&uts))
	pm_fatal( PMERR_NOHOST, "\n" );
    if (strlen( uts.nodename ) >= PM_MAX_NAME)
	pm_fatal( PMERR_TOOLONG, "%s\n", uts.nodename );
    strcpy ( buf, uts.nodename );
    return buf;
}

const char *pm_get_email_name( void )
{
    static char   buf[PM_MAX_NAME * 2];

    sprintf ( buf, "%s@%s", pm_get_user_name(), pm_get_host_name() );
    return buf;
}
