/* argify.c -- Argify a line
 * Created: Mon May  8 14:41:37 1995 by r.faith@ieee.org
 * Revised: Thu Sep 14 22:21:47 1995 by r.faith@ieee.org
 * Copyright 1995 Rickard E. Faith (r.faith@ieee.org)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: argify.c,v 1.4 1995/09/15 05:26:20 faith Exp $
 * 
 */

#include "pmlib.h"

/* A List structure is assumed to be an argc/argv pair, so we can use that
   to argify a list.  Double or single quotes can be used to mark a single
   parameter that contains spaces, as in the shell.  Backslash, however,
   has no special meaning. */

List pm_argify( const char *line )
{
   List list = pm_list_create();
   char *tmp = alloca( strlen( line ) + 1 );
   char *pt;
   char *head;
   enum { noQuote, singleQuote, doubleQuote } quote = noQuote;

   strcpy( tmp, line );
   for (head = pt = tmp; *pt;) {
      switch (quote) {
      case noQuote:
	 if (*pt == ' ' || *pt == '\t') {
	    *pt = '\0';
	    pm_list_add( list, head );
	    ++pt;
	    while (*pt == ' ' || *pt == '\t') ++pt;
	    head = pt;
	 } else {
	    if (*pt == '\'') {
	       ++head;
	       quote = singleQuote;
	    } else if (*pt == '"') {
	       ++head;
	       quote = doubleQuote;
	    }
	    ++pt;
	 }
	 break;
      case singleQuote:
	 if (*pt == '\'') {
	    *pt = '\0';
	    pm_list_add( list, head );
	    ++pt;
	    while (*pt == ' ' || *pt == '\t') ++pt;
	    head = pt;
	    quote = noQuote;
	 } else ++pt;
	 break;
      case doubleQuote:
	 if (*pt == '"') {
	    *pt = '\0';
	    pm_list_add( list, head );
	    ++pt;
	    while (*pt == ' ' || *pt == '\t') ++pt;
	    head = pt;
	    quote = noQuote;
	 } else ++pt;
	 break;
      }
   }
   if (*head) {
       pm_list_add( list, head );
   }
   
   return list;
}
