/* pmdb_write_file.c, Copyright (c) 1995, Doug Hoffman
 * 
 * Program: pmdb_write_file.c
 * Author : Doug Hoffman, hoffman@cybernetics.com
 * Purpose: c function to write file records to the pm database.
 * Created: Wed May  3 16:14:35 1995 by hoffman
 * Revised: Wed Nov  8 12:52:58 1995 by r.faith@ieee.org
 * 
 * Disclaimer:
 * 
 *   Copyright (c) 1995, Doug Hoffman
 *   This program comes with ABSOLUTELY NO WARRANTY.
 * 
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 * 
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Abstract:
 * 
 * Description:
 * 
 * Modification History:
 * 
 * $Log: write_file.c,v $
 * Revision 1.6  1995/11/08 17:57:09  faith
 * Use PMDB_DISP_* consistently
 *
 * Revision 1.5  1995/11/06  18:35:26  hoffman
 * pm package cache routines added.
 *
 * Revision 1.4  1995/10/28  01:20:58  faith
 * Performance analysis and improvements
 *
 * Revision 1.3  1995/05/14  07:38:47  faith
 * Finished adding const to all appropriate places.
 * Debugged free's of already freed space.
 * Debugged memory leaks.
 * Applied patches from Doug.
 *
 * Revision 1.2  1995/05/13  20:57:16  faith
 * Added const.  Added fields to records.  Added options to pmdb.
 *
 * Revision 1.1  1995/05/13  18:06:59  hoffman
 * Initial revision
 *
 * 
 */

#include "pmdb.h"

int	 PmdbDeleteCount;

/* =============== pmdb_write_file
 *
 *  Function to write an entry for a single file to the pmdb
 *  database system.  The flag indicates that an entry for this file
 *  is GUARANTEED to exist in the package record with the CORRECT
 *  disposition!
 *
 */

int pmdb_write_file( PMDBFileRec *record, int flag )
{
   datum	data;
   datum	key;
   datum	pkey;
   
   PMDBFileRec	old;   
   
   int		i;
   
   /* ----- Make sure the database is open */

   if (PMDBFile[PMDB_FILES].gdbmFile == NULL) return -1;

   /* ----- get key string */

   if ((record->field[PMDB_FR_KEY] == NULL) ||
       (0 == (i = strlen( record->field[PMDB_FR_KEY])))) return -2;

   key.dsize = i;
   key.dptr  = (char *)record->field[PMDB_FR_KEY];

   /* ----- Make sure the package record exists
    *
    *  A file record must have a previously registered package record.
    *  The record is read and the file added to the packages file/disp
    *  list.
    */


   if ((record->field[PMDB_FR_PACKAGE] == NULL) ||
       (0 == (i = strlen( record->field[PMDB_FR_PACKAGE])))) return -2;

   pkey.dsize = i;
   pkey.dptr  = (char *)record->field[PMDB_FR_PACKAGE];

   if (!flag) {
      update_pcache( record, PMDB_DISP_INSTALLED );
   }

   /* ----- Now see if the record already exists.
    *
    *  If the file record is already present then it might belong to some
    *  other package. If so the file must be marked as overwritten in the
    *  other package record and the old file record deleted.
    */
   
   data = gdbm_fetch( PMDBFile[PMDB_FILES].gdbmFile, key);
   if (NULL != data.dptr) {
      unpack_file_record( record->field[PMDB_FR_KEY], &data, &old);      
      free( data.dptr);
      
      if (0 != strcmp( record->field[PMDB_FR_PACKAGE],
		       old.field[PMDB_FR_PACKAGE])) { 
	 update_pcache( &old, PMDB_DISP_OVERWRITTEN);
      }
      pmdb_free_file_rec( &old);
   }
   
   
   /* ----- setup the data array */

   pack_file_record( record, &data);

   /* ----- put (write) the data
    *
    *  this requires two operations, well three. First is to write to the
    *  primary data file. Second, the index file is read using field 1,
    *  packageName, as a key.  The filename is then added to the record and
    *  it is writen to the index file.
    */

   if (0 != (gdbm_store( PMDBFile[PMDB_FILES].gdbmFile,
			 key, data, GDBM_REPLACE))) {
      return gdbm_errno;
   }

   free( data.dptr);

   /* ----- see if we should compress the database.
    *
    *  Because rewrites cause ballooning database file sizes we need
    *  to occasionally call pmdb_reorganize to reclaim deleted record
    *  space. This kludge would not be necessary if gdbm worked properly.
    */

   if (PmdbDeleteCount > PMDB_DELETE_COUNT) {
      pmdb_reorganize();
      PmdbDeleteCount = 0;      
   }
   
   return 0;
} /* end pmdb_write_file */

