/* pmdb_write_ancil.c, Copyright (c) 1995, Doug Hoffman
 * 
 * Program: pmdb_write_ancil.c
 * Author : Doug Hoffman, hoffman@cybernetics.com
 * Purpose: c function to write file records to the pm database.
 * Created: Thu May 11 18:56:09 1995 by hoffman
 * Revised: Wed Oct 25 23:19:37 1995 by r.faith@ieee.org
 * 
 * Disclaimer:
 * 
 *   Copyright (c) 1995, Doug Hoffman
 *   This program comes with ABSOLUTELY NO WARRANTY.
 * 
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 * 
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Abstract:
 * 
 * Description:
 * 
 * Modification History:
 * 
 * $Log: write_ancil.c,v $
 * Revision 1.4  1995/10/28 01:20:57  faith
 * Performance analysis and improvements
 *
 * Revision 1.3  1995/05/14  07:38:47  faith
 * Finished adding const to all appropriate places.
 * Debugged free's of already freed space.
 * Debugged memory leaks.
 * Applied patches from Doug.
 *
 * Revision 1.2  1995/05/13  20:57:16  faith
 * Added const.  Added fields to records.  Added options to pmdb.
 *
 * Revision 1.1  1995/05/13  18:06:59  hoffman
 * Initial revision
 *
 * 
 */

#include "pmdb.h"

/* =============== pmdb_write_ancil
 *
 *  Function to close the datafiles for the pmdb
 *  database system. 
 *
 */

int pmdb_write_ancil( PMDBAncilRec *record )
{
   datum	data;
   datum	key;

   int		i;
   
   /* ----- Make sure the database is open */

   if (PMDBFile[PMDB_ANCILLARY].gdbmFile == NULL) return -1;

   /* ----- get key string */

   if ((record->key == NULL) ||
       (0 == (i = strlen( record->key)))) return -2;

   key.dsize = i;
   key.dptr  = (char *)record->key;

   /* ----- make sure there is a corresponding packages record
    */

   if (!(gdbm_exists( PMDBFile[PMDB_PACKAGES].gdbmFile, key)))
      return -4;
   
   /* ----- setup the data array
    *
    */

   pack_ancil_record( record, &data);

   /* ----- put (write) the data
    *
    */

   if (0 != (gdbm_store( PMDBFile[PMDB_ANCILLARY].gdbmFile,
			 key, data, GDBM_REPLACE))) {
      return gdbm_errno;
   }

   free( data.dptr);
   
   return 0;
} /* end pmdb_write_ancil */

