/* pmdb_init.c, Copyright (c) 1995, Doug Hoffman
 * 
 * Program: pmdb_init.c
 * Author : Doug Hoffman, hoffman@cybernetics.com
 * Purpose: c function to initialize pm database.
 * Created: Wed May  3 16:14:35 1995 by hoffman
 * Revised: Sat May 13 15:03:39 1995 by r.faith@ieee.org
 * 
 * Disclaimer:
 * 
 *   Copyright (c) 1995, Doug Hoffman
 *   This program comes with ABSOLUTELY NO WARRANTY.
 * 
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 * 
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Abstract:
 * 
 * Description:
 * 
 * Modification History:
 * 
 * $Log: pmdb_init.c,v $
 * Revision 1.1  1995/08/12 21:30:53  faith
 * .
 *
 * Revision 1.3  1995/05/13  20:57:16  faith
 * Added const.  Added fields to records.  Added options to pmdb.
 *
 * Revision 1.2  1995/05/13  18:06:59  hoffman
 * PM database library for RedHat Software.
 *
 * Revision 1.1  1995/05/04  17:21:17  hoffman
 * Initial revision
 *
 * 
 */

#include "pmdb.h"

/* =============== pmdb_init
 *
 *  Function to initialize (eg. create) the datafiles for the pmdb
 *  database system. This function should only be called if the call to
 *  pmdb_open fails.
 *
 */

int pmdb_init( const char *path )
{
   GDBM_FILE	pmdbFiles;
   GDBM_FILE	pmdbPackages;
   GDBM_FILE	pmdbAncillary;
   
   datum	key;
   datum	data;  
   datum 	data2;

   char		*filesName = (char *) PMDB_FILES_NAME;
   char		*packagesName = (char *) PMDB_PACKAGES_NAME;
   char		*ancillaryName = (char *) PMDB_ANCILLARY_NAME;
   char		*defaultPath = (char *) PMDB_DEFAULT_PATH;
   char		*fname;

   int		i;

   /* ----- silly test data */
   
   data.dptr  = (char *) "alpha test data";
   data.dsize = strlen( data.dptr);
	 
   key.dptr  = (char *) "PDBM_TEST_KEY";
   key.dsize = strlen( key.dptr);
	 
   /* ---------- setup for main db file creation
    *
    *  The main data file is a hash type file. After creation a bogus
    *  data record is written to the file and then deleted, just to be
    *  sure that everything is working.
    */

   if ((path == NULL) ||
       (0 == (i = strlen( path)))) {
      i = strlen( defaultPath) + strlen( filesName) + 1;
      fname = (char *) alloca( i);
      fname = strcpy( fname, defaultPath);
      fname = strcat( fname, filesName);
   }
   else {
      i += strlen( filesName) + 1;
      fname = (char *) alloca( i);
      fname = strcpy( fname, path);
      fname = strcat( fname, filesName);
   }

   if (NULL == (pmdbFiles = gdbm_open( fname,
				       PMDB_BLOCK_SIZE,
				       GDBM_NEWDB,
				       0664,
				       PMDB_FATAL_FUNC))) {
      fprintf( stderr,"pmdb_init: creating %s: %s\n",
	       fname, strerror(errno));
      return errno;
   }

   /* ----- test the new file */
   
   if (0 != (gdbm_store( pmdbFiles, key, data, 0))) {
      fprintf( stderr,"pmdb_init: writing %s: %s\n",
	       fname, strerror(errno));
      return errno;
   }
   data2 = gdbm_fetch( pmdbFiles, key);
   if (NULL == data2.dptr) {
      fprintf( stderr,"pmdb_init: reading %s: %s\n",
	       fname, strerror(errno));
      return errno;
   } else free( data2.dptr );
   
   if (0 != (gdbm_delete( pmdbFiles, key))) {
      fprintf( stderr,"pmdb_init: deleting from %s: %s\n",
	       fname, strerror(errno));
      return errno;
   }

   /* ----- write out and verify the database format version record
    *
    *  The database may change format from version to version so an
    *  identifying version stamp is writen to the main data file
    *  (files.data) so that version differences can be detected in the
    *  future.
    */
   
   data.dptr  = (char *) PMDB_VERSION_STAMP;
   data.dsize = strlen( data.dptr) + 1;
	 
   key.dptr  = (char *) PMDB_VERSION_KEY;
   key.dsize = strlen( key.dptr);
	
   if (0 != (gdbm_store( pmdbFiles, key, data, 0))) {
      fprintf( stderr,"pmdb_init: writing version stamp: %s\n",
	       strerror(errno));
      return errno;
   }
   data2 = gdbm_fetch( pmdbFiles, key);
   if (NULL == data2.dptr) {
      fprintf( stderr,"pmdb_init: reading version stamp: %s\n",
	       strerror(errno));
      return errno;
   } else free( data2.dptr );
       
   /* ----------- setup for packages db file creation
    *
    *  The packages file contains (or will contain) an inverted index on
    *  data field one of the main data record, the package name. It, too,
    *  is a hash file.
    */

   if ((path == NULL) ||
       (0 == (i = strlen( path)))) {
      i = strlen( defaultPath) + strlen( packagesName) + 1;
      fname = (char *) alloca( i);
      fname = strcpy( fname, defaultPath);
      fname =  strcat( fname, packagesName);
   }
   else {
      i += strlen( packagesName) + 1;
      fname = (char *) alloca( i);
      fname = strcpy( fname, path);
      fname = strcat( fname, packagesName);
   }
   
   if (NULL == (pmdbPackages = gdbm_open( fname,
					  PMDB_BLOCK_SIZE, 
					  GDBM_NEWDB,
					  0664,
					  PMDB_FATAL_FUNC))) {
      fprintf( stderr,"pmdb_init: creating %s: %s\n",
	       fname, strerror(errno));
      return errno;
   }

   /* ----- test the new file */
     
   data.dptr  = (char *) "alpha test data";
   data.dsize = strlen( data.dptr);
	 
   key.dptr  = (char *) "PDBM_TEST_KEY";
   key.dsize = strlen( key.dptr);

   if (0 != (gdbm_store( pmdbPackages, key, data, 0))) {
      fprintf( stderr,"pmdb_init: writing %s: %s\n",
	       fname, strerror(errno));
      return errno;
   }
   data2 = gdbm_fetch( pmdbPackages, key);
   if (NULL == data2.dptr) {
      fprintf( stderr,"pmdb_init: reading %s: %s\n",
	       fname, strerror(errno));
      return errno;
   } else free( data2.dptr );
   
   if (0 != (gdbm_delete( pmdbPackages, key))) {
      fprintf( stderr,"pmdb_init: deleting from %s: %s\n",
	       fname, strerror(errno));
      return errno;
   }
   
   /* ----------- setup for ancillary db file creation
    *
    *  The ancillary file contains (or will contain) package information that
    *  is infrequently accessed and/or not keyed on.
    */

   if ((path == NULL) ||
       (0 == (i = strlen( path)))) {
      i = strlen( defaultPath) + strlen( ancillaryName) + 1;
      fname = (char *) alloca( i);
      fname = strcpy( fname, defaultPath);
      fname =  strcat( fname, ancillaryName);
   }
   else {
      i += strlen( ancillaryName) + 1;
      fname = (char *) alloca( i);
      fname = strcpy( fname, path);
      fname = strcat( fname, ancillaryName);
   }
   
   if (NULL == (pmdbAncillary = gdbm_open( fname,
					   PMDB_BLOCK_SIZE, 
					   GDBM_NEWDB,
					   0664,
					   PMDB_FATAL_FUNC))) {
      fprintf( stderr,"pmdb_init: creating %s: %s\n",
	       fname, strerror(errno));
      return errno;
   }

   /* ----- test the new file */
     
   data.dptr  = (char *) "alpha test data";
   data.dsize = strlen( data.dptr);
	 
   key.dptr  = (char *) "PDBM_TEST_KEY";
   key.dsize = strlen( key.dptr);

   if (0 != (gdbm_store( pmdbAncillary, key, data, 0))) {
      fprintf( stderr,"pmdb_init: writing %s: %s\n",
	       fname, strerror(errno));
      return errno;
   }
   data2 = gdbm_fetch( pmdbAncillary, key);
   if (NULL == data2.dptr) {
      fprintf( stderr,"pmdb_init: reading %s: %s\n",
	       fname, strerror(errno));
      return errno;
   } else free( data2.dptr );
   
   if (0 != (gdbm_delete( pmdbAncillary, key))) {
      fprintf( stderr,"pmdb_init: deleting from %s: %s\n",
	       fname, strerror(errno));
      return errno;
   }
   
   /* --------- Close the files and return */
   
   gdbm_close( pmdbFiles);
   gdbm_close( pmdbPackages);
   gdbm_close( pmdbAncillary);
   
   return 0;
} /* end pmdb_init */

