/* pmdb.h, Copyright (c) 1995, RedHat Software.
 * 
 * Program: pmdb.h
 * Author : Doug Hoffman, hoffman@cybernetics.net
 * Purpose: header file for the pmdb library programs.
 * Created: Tue May  2 16:07:13 1995 by hoffman
 * Revised: Wed Nov  8 12:49:19 1995 by r.faith@ieee.org
 * 
 * Disclaimer:
 * 
 *   Copyright (c) 1995, Doug Hoffman
 *   This program comes with ABSOLUTELY NO WARRANTY.
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 * 
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Abstract:
 * 
 * Description:
 * 
 * Modification History:
 * 
 * $Log: pmdb.h,v $
 * Revision 1.8  1995/11/08 17:57:07  faith
 * Use PMDB_DISP_* consistently
 *
 * Revision 1.7  1995/11/06  18:35:25  hoffman
 * pm package cache routines added.
 *
 * Revision 1.6  1995/10/28  01:20:45  faith
 * Performance analysis and improvements
 *
 * Revision 1.5  1995/09/15  01:38:58  faith
 * Added %preun and %postun scripts
 *
 * Revision 1.4  1995/05/14  07:38:47  faith
 * Finished adding const to all appropriate places.
 * Debugged free's of already freed space.
 * Debugged memory leaks.
 * Applied patches from Doug.
 *
 * Revision 1.3  1995/05/13  20:57:16  faith
 * Added const.  Added fields to records.  Added options to pmdb.
 *
 * Revision 1.2  1995/05/13  18:06:59  hoffman
 * PM database library for RedHat Software.
 *
 *
 *
 * 
 */

#ifndef _PMDB_H_
#define _PMDB_H_

#include "pmconfig.h"
#include <gdbm.h>

#ifndef EXTERN
#ifdef PMDB_MAIN
#define EXTERN   /* */
#else
#define EXTERN   extern
#endif
#endif

/* ----- defines for path and file names */

#define PMDB_DEFAULT_PATH	"/var/lib/pm"
#define PMDB_FILES_NAME		"/files.data"
#define PMDB_PACKAGES_NAME     	"/packages.data"
#define PMDB_ANCILLARY_NAME	"/ancillary.data"
#define PMDB_PACKAGE_CACHE_SIZE 10

#define PMDB_VERSION_KEY	"...pmdb_version_stamp..."
#define PMDB_VERSION_STAMP	"1.0"
#define PMDB_BLOCK_SIZE		4096
#define PMDB_FATAL_FUNC		0
#define PMDB_DELETE_COUNT	4000000	/* 4MB of deletes triggers reorg */

/* --- for the files file routines. */

#define PMDB_FR_ENTRIES        14
#define PMDB_FR_KEY             0
#define PMDB_FR_TYPE            1
#define PMDB_FR_KIND            2
#define PMDB_FR_PACKAGE         3
#define PMDB_FR_SIZE            4
#define PMDB_FR_MODE            5
#define PMDB_FR_MTIME           6
#define PMDB_FR_MAJOR           7
#define PMDB_FR_MINOR           8
#define PMDB_FR_OWNER           9
#define PMDB_FR_GROUP          10
#define PMDB_FR_CHECKSUM       11
#define PMDB_FR_LINK           12
#define PMDB_FR_TIMEINSTALLED  13

/* --- for the package file routines. */

#define PMDB_PR_ENTRIES         8
#define PMDB_PR_KEY             0
#define PMDB_PR_NAME            1
#define PMDB_PR_VERSION         2
#define PMDB_PR_RELEASE         3
#define PMDB_PR_SUBNAME         4
#define PMDB_PR_GROUP           5
#define PMDB_PR_DISTRIBUTION    6
#define PMDB_PR_TIMEINSTALLED   7

/* --- for the disposition. */

#define PMDB_DISP_INSTALLED     'I'
#define PMDB_DISP_NOTINSTALLED  'N'
#define PMDB_DISP_OVERWRITTEN   'O'
#define PMDB_DISP_DELETED       'D'

/* ---------- Typedefs */

typedef enum {
   PackageName
} PMDBIndex;

typedef struct {
   const char *field[PMDB_FR_ENTRIES];
} PMDBFileRec;

typedef struct {
   int	count;
   int  entries;
   char **file;
   char **disp;
   const char *field[PMDB_PR_ENTRIES];
} PMDBPackageRec;

typedef struct {
   const char *key;
   int	count;
   int  entries;
   char **type;
   char **field;
} PMDBAncilRec;

/* ---------- Global variable(s)
 *
 *  The global structure PMDBFile contains pointers to the
 *  db file structures opened by pmdb_open() and used by all other
 *  pmdb functions. It is not inteneded to be user visible and does not
 *  appear in the header file for this reason.
 */

#if 0
EXTERN struct PMDBFile {
   GDBM_FILE	files;
   char		*filesName;
   GDBM_FILE	packages;
   char		*packagesName;
   GDBM_FILE	ancillary;
   char		*ancillaryName;
} PMDBFile;
#else
#define PMDB_FILE_COUNT 3
#define PMDB_FILES      0
#define PMDB_PACKAGES   1
#define PMDB_ANCILLARY  2

EXTERN struct PMDBFile {
   GDBM_FILE gdbmFile;
   char      *name;
} PMDBFile[PMDB_FILE_COUNT];
#endif
 

/* -----  local function prototypes
 *
 */

int pmdb_init( const char *pathName );	/* initialize pmdb datafiles */
				/* open the pmdb database */
int pmdb_open( const char *pathName, const int flags );
int pmdb_close( void );			/* open the pmdb database */
int pmdb_reorganize( void );		/* reorganize the database */
char *pmdb_read_version( void);  	/* get the database version */

				/* get a record from pmdb */
int pmdb_read_file( const char *key, PMDBFileRec *rec);
int pmdb_write_file( PMDBFileRec *rec, int flag); /* write a record to pmdb */
int pmdb_delete_file( const char *key );          /* delete a file record   */
int pmdb_read_first_file( PMDBFileRec *rec);	  /* read the first record  */
int pmdb_read_next_file( PMDBFileRec *rec);	  /* read the next record   */
int pmdb_free_file_rec( PMDBFileRec *rec);        /* free a PMDBFileRec     */

int pmdb_read_package( const char *key, PMDBPackageRec *rec);
int pmdb_write_package( PMDBPackageRec *rec);
int pmdb_delete_package( const char *key);
int pmdb_read_first_package( PMDBPackageRec *rec); /* read first record  */
int pmdb_read_next_package( PMDBPackageRec *rec);  /* read  next record  */
int pmdb_free_package_rec( PMDBPackageRec *rec);   /* free PMDBPackageRec */

int pmdb_read_ancil( const char *key, PMDBAncilRec *rec);
int pmdb_write_ancil( PMDBAncilRec *rec);
int pmdb_delete_ancil( const char *key);
int pmdb_free_ancil_rec( PMDBAncilRec *rec); 	/* free PMDBAncilRec */

int match_file( const char *file, const char *path);	/* from pmdb_utils */
void unpack_file_record( const char *key, datum *data, PMDBFileRec *record);
void pack_file_record( PMDBFileRec *record, datum *data);
void unpack_package_record( const char *key,
			    datum *data, PMDBPackageRec *record);
void pack_package_record( PMDBPackageRec *record, datum *data);
void unpack_ancil_record( const char *key, datum *data, PMDBAncilRec *record);
void pack_ancil_record( PMDBAncilRec *record, datum *data);
void add_file_to_package( const char *fileName, PMDBPackageRec *package);
int  mark_file_in_package( const char *fileName,
			   PMDBPackageRec *package, char mark);

int find_pcache_entry( char *name);		 /* cache stuff */
int flush_pcache( void );
int init_pcache( void );
int update_pcache( PMDBFileRec *record, char fileFlag);
				/* dmalloc must be last */
#ifdef DMALLOC_FUNC_CHECK
# include "dmalloc.h"
#endif

#endif  /* _pmdb_ */
