/* pmdb_free_ancil_rec.c, Copyright (c) 1995, RedHat Software.
 * 
 * Program: pmdb_free_ancil_rec.c
 * Author : Doug Hoffman, hoffman@cybernetics.com
 * Purpose: c function to free a PMDBRecord.
 * Created: Wed May  3 16:14:35 1995 by hoffman
 * Revised: Wed Oct 25 14:56:51 1995 by r.faith@ieee.org
 * 
 * Disclaimer:
 * 
 *   Copyright (c) 1995, Doug Hoffman
 *   This program comes with ABSOLUTELY NO WARRANTY.
 * 
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 * 
 *   This program is distributed in the hope that it will be useful, but
 *   WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Abstract:
 * 
 * Description:
 * 
 * Modification History:
 * 
 * $Log: free_anci_rec.c,v $
 * Revision 1.4  1995/10/28 01:20:42  faith
 * Performance analysis and improvements
 *
 * Revision 1.3  1995/05/14  07:38:47  faith
 * Finished adding const to all appropriate places.
 * Debugged free's of already freed space.
 * Debugged memory leaks.
 * Applied patches from Doug.
 *
 * Revision 1.2  1995/05/13  20:57:16  faith
 * Added const.  Added fields to records.  Added options to pmdb.
 *
 * Revision 1.1  1995/05/13  18:06:59  hoffman
 * Initial revision
 *
 * 
 */

#include "pmdb.h"

/* =============== pmdb_free_ancil_rec
 *
 *  Function to free the contents of a PMDBFileRec.
 *
 */

int pmdb_free_ancil_rec( PMDBAncilRec *record )
{
   int		i;
   
   /* ----- Make sure the record is there */

   if (record == NULL) return -3;


   /* ----- free the strings pointed to by the data record
    *
    */

   if (NULL != record->key) free( (char *)record->key);
   
   for (i=0; i<record->count; i++) {
      if (NULL != record->type[i]) free( (char *)record->type[i]);
      if (NULL != record->field[i]) free( (char *)record->field[i]);
   }
   if (NULL != record->type)  free( record->type );
   if (NULL != record->field) free( record->field );
   record->count = 0;
   record->entries = 0;
   
   return 0;
} /* end pmdb_free_ancil_rec */

