#!/bin/sh -x
# test.sh -- 
# Created: Sun May 14 20:47:22 1995 by r.faith@ieee.org
# Revised: Sun May 14 21:11:17 1995 by r.faith@ieee.org
# Copyright 1995 Rickard E. Faith (r.faith@ieee.org)
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any
# later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 675 Mass Ave, Cambridge, MA 02139, USA.
#
# $Id: test.sh,v 1.1 1995/08/12 21:30:26 faith Exp $
# 
#

rm -rf /tmp/cfg*
rm -rf /tmp/pm-test
echo .PmConfig:
cat .PmConfig

../src/pm --build all pmtest-1.0 --nodb
../src/pm --build all pmtest-1.1 --nodb
../src/pm --build all pmtest-1.2 --nodb

echo Note, there is nothing in the database:
../src/pm --all --long

echo Install pmtest-1.0
../src/pm --install pmtest-1.0
../src/pm --all --long

echo Try to install pmtest-1.1
../src/pm --install pmtest-1.1
../src/pm --all --long

echo Force installation of pmtest-1.1
../src/pm --install pmtest-1.1 --force
../src/pm --all --long

echo Delete pmtest-1.0 -- note no files are deleted
../src/pm --delete pmtest-1.0
../src/pm --all --long

echo Change /tmp/cfg
echo foo >> /tmp/cfg

echo Force installation of pmtest-1.0
../src/pm --install pmtest-1.0 --force
../src/pm --all --long

echo Confirm checksum mismatch
../src/pm --whence /tmp/cfg

echo Install pmtest-1.2, with a new config file
../src/pm --install pmtest-1.2 --force
../src/pm --all --long

echo Delete pmtest-1.0 -- note no files are deleted
../src/pm --delete pmtest-1.0
../src/pm --all --long

echo Demonstrate verbosity
../src/pm --all --long -v

echo Delete and clean up
../src/pm --delete pmtest-1.1
../src/pm --delete pmtest-1.2
../src/pm --all --long

echo Demonstrate environment variables
export COMPILER='gcc 2.x.x'
export LIBRARIES='libc 4.x'
../src/pm --build all pmtest-1.0
../src/pm --all --long -v

