.TH PLAY/RECORD 1 LOCAL
.SH NAME
play - plays .WAV-Files

record - records .WAV-Files
.SH SYNOPSIS
.B play 
[-S] [-s speed] [-t limit] [-b bits] [-q] [-h] [filename]

.B record 
[-S] [-s speed] [-t limit] [-b bits] [-q] [-h] [filename]
.SH DESCRIPTION
\fIPlay\fP plays sound files in the .WAV-format of MS-Windows 3.1 through your
sound card. Without any
switches all needed parameters like speed (sample_frequency), mode (stereo / mono), 
bits per sample (8, 12, 16) will be taken from the header of the given
file. You can overwrite these parameters by using the switches. 

\fIRecord\fP samples data coming from your external devices like microphones, 
recorders, CD-players, radios; whatever connected to your sound card. The 
data will be saved in the .WAV-format. If you don't use any switches, 
default values will be taken. 

\fIDefaults for recording:\fP

.RS
.B speed
- 22050 Hz

.B time 
- 10 seconds

.B bits
- 8 Bits

.B mode
- mono
.RE

If no files are given, the input of the player will be taken from \fIstdin\fP, the
output of the recorder will be written to \fIstdout\fP. All messages (which can be 
suppressed with the
.B -q
switch) will be written to \fIstderr\fP.
.SH OPTIONS
.B -S
- sets stereo-mode

.B -s speed
- sets the sample frequency in Hz

.B -t limit
- sets the time limit in seconds

.B -b bits
- sets the sample size to 8, 12 or 16 bits. The Soundblaster card
supports only 8 bit!

.B -q
- quiet mode, no terminal output

.B -h
- gives a help text
.SH FILES
.B /usr/local/bin/play 
- player

.B /usr/local/bin/record
- record
.SH DIAGNOSTICS
If any error occurs, a message will be printed out and the program will 
be exited (with one exception - see below) returning an error code of -1.

The player checks the header of the files. The error-message "wrong speed/freq."
is only a warning and doesn't influence the playing.  
.SH BUGS
I don't know any :-)
.SH EXAMPLES
cat sample.wav | play 
.B plays sample.wav

play sample.wav	
.B plays this sample too

record -S -t 10 -s 10000 test.wav
.B records data in stereo with a speed of 10000 Hz for 10 seconds

.SH SEE ALSO
xplay(1)

.SH AUTHOR
Andre Fuechsel (C) FF-Soft '93

.B e-mail: 
af1@irz.inf.tu-dresden.de
