/******************************************************************************/
/* WAV-File player/recorder - Version 0.2 			              */
/* using code of recplay.c from Audio Utilities for Linux 2.0 (c) Liam Corner */
/* (C) FF-Soft '93 						              */
/* Andre Fuechsel; email: af1@irz.inf.tu-dresden.de / 			      */
/******************************************************************************/

#include <stdio.h>
#include <getopt.h>

#include "play.h"

/* error handler for commandline version on WAVplay/record */

void err(int severity, char *text) 
/* severity: 0 = warning -> no exit
             1 = error -> exit
   text: error text */
{
   fprintf(stderr, "%s\n", text);
   if (severity) exit(-1);
}

main(int argc, char *argv[])
{
	char c;
	int mode;
	char string[80];

	header_data data = {0,0,0,0,0,0,0,0};

	if (strstr(argv[0], "play")) 
		mode = PLAY;
	else if (strstr(argv[0], "record")) 
		mode = RECORD;
	else {
		sprintf(string, "%s: command should either be named play or record\n", argv[0]);
		err(1, string);
	}

	while((c = getopt(argc, argv, "qs:St:b:h")) != EOF)
		switch (c) {
			case 'q': data.quiet_mode=1; break;
			case 's': data.speed = atoi(optarg); data.force_speed = 1; break;
			case 'S': data.stereo = data.force_stereo = 1; break;
			case 't': data.time_limit = atof(optarg); break;
			case 'b': data.sample_size = atoi(optarg); data.force_sample_size = 1; break;
			case 'h': 
			   fprintf(stderr, 
	"Usage: %s [-h] [-q] [-s speed] [-S] [-t limit] [-b bits] filename...\n\n", argv[0]);
			   fprintf(stderr, "Switches:\n  -h .. displays this help text\n");
			   fprintf(stderr, "  -q .. quiet mode; don't display");
			   fprintf(stderr, " any information about the sample\n");
			   fprintf(stderr, "  -s .. force speed\n  -S .. force stereo\n");
			   fprintf(stderr, "  -t .. time limit\n");
			   fprintf(stderr, "  -b .. force bit_p_spl (8, 12, 16)\n\n");
			   fprintf(stderr, "Normally speed, stereo/mono and bit_p_spl");
			   fprintf(stderr, " will be read from the given file. Using the\n");
			   fprintf(stderr, "switches shown above you can set your own.\n");
			   exit(-1);
			default: fprintf(stderr, 
	"Usage: %s [-h] [-q] [-s speed] [-S] [-t limit] [-b bits] filename...\n\n", argv[0]);
				 exit(-1);
		}

	if (mode == RECORD) {					/* possibly set default values */
		if (!data.time_limit) data.time_limit = 10.0;	/* DEFAULT: 10 secs */
		if (!data.force_stereo) data.stereo = 0;	/* DEFAULT: mono */
		if (!data.force_speed) data.speed = 22050;	/* DEFAULT: 22050 Hz */
		if (!data.force_sample_size) data.sample_size=8;/* DEFAULT: 8 bit samples */
	}

	data.lower_border = 0;
	data.upper_border = 0;		/* to be set in recplay! */

	if (optind > argc-1) 
		recplay(NULL,mode,data,NULL);
	else 
		while (optind <= argc - 1) 
			recplay(argv[optind++],mode,data,NULL);

	exit(0);
}
