# ifndef lint
static char *rcs_id =
	"@(#) $Header: /n/poincare/usr2/src/mpage/RCS/mp_page.c,v 2.4 89/05/25 08:58:28 mark Exp $";
# endif

/*
 * mpage:	a program to reduce pages of print so that several pages
 * 	  	of output appear on one printed page.
 *
 * Written by:
 *   ...!uunet!\                       Mark Hahn, Sr Systems Engineer
 *              >pyrdc!mark            Pyramid Technology Corporation
 * ...!pyramid!/                       Vienna, Va    (703)848-2050
 *
 *
 * Copyright (c) 1988 Mark P. Hahn, Herndon, Virginia
 *  
 *     Permission is granted to anyone to make or distribute verbatim
 *     copies of this document as received, in any medium, provided
 *     that this copyright notice notice is preserved, and that the
 *     distributor grants the recipient permission for further
 *     redistribution as permitted by this notice.
 *
 */

/* $Log:	mp_page.c,v $
 * Revision 2.4  89/05/25  08:58:28  mark
 * checked in with -k by slevy at 90.01.15.13.26.42.
 * 
 * Revision 2.4  89/05/25  08:58:28  mark
 * rearranged the rcs header keywords for better readability.
 * 
 * Revision 2.3  89/05/22  14:41:01  mark
 * Fixed the type-o in the rcs identification string
 * 
 * Revision 2.2  89/05/22  14:38:04  mark
 * Added rcs identification usable with the "what" program
 * 
 * Revision 2.1  89/05/22  14:31:27  mark
 * New Major Revision
 * 
 * Revision 1.1  89/05/22  14:25:52  mark
 * Initial revision
 *  */

#include "mp_head.h"



void
set_page()
{
	if (opt_a4) {
		ps_width = 596;
		ps_height = 842;
	} else {
		ps_width = 612;
		ps_height = 792;
	}
} /* set_page */



/*
 * Bases are the base for each page. e.g the corner points for outlines.
 */
   /*  __________________________
    * | ________________________ |
    * ||                        ||
    * ||                        ||
    * ||                 ybase4 ||
    * ||                        Y|
    * ||                        ||
    * ||                        ||
    * ||                 ybase3 ||
    * ||                        Y|
    * ||                        ||
    * ||                        ||
    * ||                 ybase2 ||
    * ||                        Y|
    * ||                        ||
    * ||                        ||
    * ||xbase1   xbase2  ybase1 ||
    * |X___________X____________Y|
    * |__________________________|
    */

int
xbase1()
{
	Debug(DB_POINTS, "%%xbase1: %d\n", sheetmargin_left);
	return sheetmargin_left;
} /* xbase1 */



int
xbase2()
{
	Debug(DB_POINTS, "%%xbase2: %d\n",
                (ps_width - sheetmargin_left - sheetmargin_right) / 2 +
                sheetmargin_left);
        return  (ps_width - sheetmargin_left - sheetmargin_right) / 2 +
                sheetmargin_left;
} /* xbase2 */



int
ybase1()
{
	Debug(DB_POINTS, "%%ybase1: %d\n",
               sheetmargin_bottom);
	return sheetmargin_bottom;
} /* ybase1 */



int
ybase2()
{
	Debug(DB_POINTS, "%%ybase2: %d\n",
	        (ps_height - sheetmargin_bottom - sheetmargin_top) / 4
	        + sheetmargin_bottom);
	return (ps_height - sheetmargin_bottom - sheetmargin_top) / 4
	        + sheetmargin_bottom;
} /* ybase2 */



int
ybase3()
{
	Debug(DB_POINTS, "%%ybase3: %d\n",
	        (ps_height - sheetmargin_bottom - sheetmargin_top) / 2
	        + sheetmargin_bottom);
	return (ps_height - sheetmargin_bottom - sheetmargin_top) / 2
	        + sheetmargin_bottom;
} /* ybase3 */



int
ybase4()
{
	Debug(DB_POINTS, "%%ybase4: %d\n",
	        (ps_height - sheetmargin_bottom - sheetmargin_top) * 3 / 4
	        + sheetmargin_bottom);
	return  (ps_height - sheetmargin_bottom - sheetmargin_top) * 3 / 4
	        + sheetmargin_bottom;
} /* ybase4 */



int
ytop1()
{
	Debug(DB_POINTS, "%%ytop1: %d\n", ybase1() + yht4());
	/* return ybase1() + yht4(); */
	return ybase2();
} /* ytop1 */



int
ytop2()
{
	Debug(DB_POINTS, "%%ytop2: %d\n", ybase2() + yht4());
	/* return ybase2() + yht4(); */
	return ybase3();
} /* ytop2 */



int
ytop3()
{
	Debug(DB_POINTS, "%%ytop3: %d\n", ybase3() + yht4());
	/* return ybase3() + yht4(); */
	return ybase4();
} /* ytop3 */



int
ytop4()
{
	Debug(DB_POINTS, "%%ytop4: %d\n", ybase4() + yht4());
	/* return ybase4() + yht4(); */
	return ps_height - sheetmargin_bottom - sheetmargin_top
	                 + sheetmargin_bottom;
} /* ytop4 */



int
xwid1()
{
	Debug(DB_POINTS, "%%xwid1: %d\n",
	       ps_width - sheetmargin_left - sheetmargin_right);
	return ps_width - sheetmargin_left - sheetmargin_right;
} /* xwid1 */



int
xwid2()
{
	Debug(DB_POINTS, "%%xwid2: %d\n",
	       (ps_width - sheetmargin_left - sheetmargin_right) / 2);
	return (ps_width - sheetmargin_left - sheetmargin_right) / 2;
} /* xwid2 */



int
yht1()
{
	Debug(DB_POINTS, "%%yht1: %d\n",
	       ps_height - sheetmargin_top - sheetmargin_bottom);
	return ps_height - sheetmargin_top - sheetmargin_bottom;
} /* yht1 */



int
yht2()
{
	Debug(DB_POINTS, "%%yht2: %d\n",
	       (ps_height - sheetmargin_top - sheetmargin_bottom) / 2);
	return (ps_height - sheetmargin_top - sheetmargin_bottom) / 2;
} /* yht2 */



int
yht4()
{
	Debug(DB_POINTS, "%%yht4: %d\n",
	       (ps_height - sheetmargin_top - sheetmargin_bottom) / 4);
	return (ps_height - sheetmargin_top - sheetmargin_bottom) / 4;
} /* yht4 */



void
outline_1(outfd)
 FILE *outfd;
{
	/* one page outline */
	fprintf(outfd, "0 setlinewidth\n");
        fprintf(outfd, "%d %d moveto 0 %d rlineto\n",
                       xbase1(), ybase1(), yht1());
	fprintf(outfd, "%d 0 rlineto 0 %d rlineto closepath stroke\n",
                       xwid1(), -yht1());

        return;
} /* outline_1 */



void
outline_2(outfd)
 FILE *outfd;
{
	/* two page outline */
	outline_1(outfd);
	fprintf(outfd, "%d %d moveto %d 0 rlineto stroke\n",
                xbase1(), ybase3(), xwid1());

        return;
} /* outline_2 */



void
outline_4(outfd)
 FILE *outfd;
{
	/* four page outline */
	outline_2(outfd);
	fprintf(outfd, "%d %d moveto 0 %d rlineto stroke\n",
                xbase2(), ybase1(), yht1());

        return;
} /* outline_4 */



void
outline_8(outfd)
 FILE *outfd;
{
	/* eight page outline */
	outline_4(outfd);
	fprintf(outfd, "%d %d moveto %d 0 rlineto stroke\n",
                xbase1(), ybase2(), xwid1());
	fprintf(outfd, "%d %d moveto %d 0 rlineto stroke\n",
                xbase1(), ybase4(), xwid1());

        return;
} /* outline_8 */



void
mp_outline(outfd, asheet)
 FILE *outfd;
 struct sheet *asheet;
{
	if (opt_outline) {
		(*asheet->sh_outline)(outfd);
	}

        return;
} /* mp_outline */

