/* Replace most octal and hexadecimal C characters by %3d decimal.
   Copyright (C) 1993 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1993.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

%{

void
convert_base (int base, char *string, int offset)
{
  char *cursor;
  int digit;
  int value;

  value = 0;
  for (cursor = string + offset; *cursor; cursor++)
    {
      switch (*cursor)
	{
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	  digit = *cursor - '0';
	  break;

	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	  digit = *cursor - 'A' + 10;
	  break;

	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	  digit = *cursor - 'a' + 10;
	  break;

	default:
	  digit = 99;
	}
      if (digit >= base)
	break;
      value = base * value + digit;
    }
  if (value < 256)
    printf ("%3d", value);
  else
    printf ("%s", string);
}

%}

%%

[1-9][0-9]*(\.[0-9]*)?		ECHO;
\.[0-9]+			ECHO;

0[0-7]*[89][0-9]*		ECHO;
0[0-7]+				convert_base (8, yytext, 1);

\\[1-7][0-7]*			convert_base (8, yytext, 1);
\\0[0-7]+			convert_base (8, yytext, 1);

'\\[1-7][0-7]*'			convert_base (8, yytext, 2);
'\\0[0-7]+'			convert_base (8, yytext, 2);

0[xX][0-9a-fA-F]+		convert_base (16, yytext, 2);

.				ECHO;

%%

int
main (int argc, char *const *argv)
{
  if (argc > 2)
    {
      fprintf (stderr, "Usage: %s [SOURCE]\n", argv[0]);
      exit (1);
    }
  if (argc == 2)
    {
      fclose (stdin);
      if (fopen (argv[1], "r") == NULL)
	{
	  perror (argv[1]);
	  exit (1);
	}
    }
  yylex ();
  exit (0);
}
