/* Conversion of files between different charsets and usages.
   Copyright (C) 1993 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1993.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "recode.h"

/* Data for Atari ST to ISO Latin-1 code conversions.  */

static KNOWN_PAIR known_pairs[] =
  {
    {128, 199},			/* C, */
    {129, 252},			/* u" */
    {130, 233},			/* e' */
    {131, 226},			/* a^ */
    {132, 228},			/* a" */
    {133, 224},			/* a` */
    {134, 229},			/* aa */
    {135, 231},			/* c, */
    {136, 234},			/* e^ */
    {137, 235},			/* e" */
    {138, 232},			/* e` */
    {139, 239},			/* i" */
    {140, 238},			/* i^ */
    {141, 236},			/* i` */
    {142, 196},			/* A" */
    {143, 197},			/* AA */
    {144, 201},			/* E' */
    {145, 230},			/* ae */
    {146, 198},			/* AE */
    {147, 244},			/* o^ */
    {148, 246},			/* o" */
    {149, 242},			/* o` */
    {150, 251},			/* u^ */
    {151, 249},			/* u` */
    {152, 255},			/* y" */
    {153, 214},			/* O" */
    {154, 220},			/* U" */
    {155, 162},			/* \cent */
    {156, 163},			/* \pound */
    {157, 165},			/* \yen */
    {158, 223},			/* \ss */

    {160, 225},			/* a' */
    {161, 237},			/* i' */
    {162, 243},			/* o' */
    {163, 250},			/* u' */
    {164, 241},			/* n~ */
    {165, 209},			/* N~ */
    {166, 170},			/* a_ */
    {167, 186},			/* o_ */
    {168, 191},			/* ?' */

    {170, 172},			/* \neg */
    {171, 189},			/* 1/2 */
    {172, 188},			/* 1/4 */
    {173, 161},			/* !` */
    {174, 171},			/* `` */
    {175, 187},			/* '' */
    {176, 227},			/* a~ */
    {177, 245},			/* o~ */
    {178, 216},			/* O/ */
    {179, 248},			/* o/ */

    {182, 192},			/* A` */
    {183, 195},			/* A~ */
    {184, 213},			/* O~ */
    {185, 168},			/* diaeresis */
    {186, 180},			/* acute accent */

    {188, 182},			/* pilcrow sign */
    {189, 169},			/* copyright sign */
    {190, 174},			/* registered trade mark sign */

    {221, 167},			/* paragraph sign, section sign */

    {230, 181},			/* mu, micro */

    {241, 177},			/* +- */

    {246, 247},			/* \div */

    {248, 176},			/* \deg */

    {250, 183},			/* \cdot */

    {253, 178},			/* ^2 */
    {254, 179},			/* ^3 */
  };
#define NUMBER_OF_PAIRS (sizeof (known_pairs) / sizeof (KNOWN_PAIR))

extern int ascii_graphics;

static void
init_latin1_atarist (STEP *step)
{
  complete_pairs (step, 1, known_pairs, NUMBER_OF_PAIRS, 1);
}

static void
init_atarist_latin1 (STEP *step)
{
  complete_pairs (step, 1, known_pairs, NUMBER_OF_PAIRS, 0);
}

void
module_atarist (void)
{
  declare_step ("latin1", "atarist", strict_mapping ? ONE_TO_MANY : REVERSIBLE,
		init_latin1_atarist, NULL);
  declare_step ("atarist", "latin1", strict_mapping ? ONE_TO_MANY : REVERSIBLE,
		init_atarist_latin1, NULL);
}
