.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XcmsStoreColor 3X11 "Release 5" "X Version 11" "XLIB FUNCTIONS"
.SH NAME
XcmsStoreColor, XcmsStoreColors \- set colors
.SH SYNTAX
Status XcmsStoreColor\^(\^\fIdisplay\fP, \fIcolormap\fP\^, \fIcolor\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Colormap \fIcolormap\fP\^;
.br
      XcmsColor *\fIcolor\fP\^;
.LP
Status XcmsStoreColors\^(\^\fIdisplay\fP, \fIcolormap\fP\^, \fIcolors\fP\^, \fIncolors\fP\^, \fIcompression_flags_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Colormap \fIcolormap\fP\^;
.br
      XcmsColor \fIcolors\fP\^[\^]\^;
.br
      int \fIncolors\fP\^;
.br
      Bool \fIcompression_flags_return\fP\^[\^]\^;
.SH ARGUMENTS
.\" $Header: display.a,v 1.1 88/02/26 10:26:29 mento Exp $
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIcolor\fP 1i
Specifies the color cell and the color to store.
Values specified in this
.ZN XcmsColor
structure remain unchanged upon return.
.IP \fIcolors\fP 1i
Specifies the color specification array of
.ZN XcmsColor
structures, each specifying a color cell and the color to store in that
cell.
Values specified in the array remain unchanged upon return.
.\" $Header: cmap.a,v 1.2 88/05/09 06:39:13 mento Exp $
.IP \fIcolormap\fP 1i
Specifies the colormap.
.IP \fIcompression_flags_return\fP 1i
Specifies an array of Boolean values for returning compression status.
If a non-NULL pointer is supplied,
each element of the array is set to
.ZN True
if the corresponding color was compressed, and
.ZN False
otherwise.
Pass NULL if the compression status is not useful.
.IP \fIncolors\fP 1i
Specifies the number of 
.ZN XcmsColor
structures in the color specification array.
.SH DESCRIPTION
The
.ZN XcmsStoreColor
function converts the color specified in the
.ZN XcmsColor
structure into RGB values and then uses this RGB specification in an
.ZN XColor
structure, whose three flags 
.Pn ( DoRed , 
.ZN DoGreen ,
and
.ZN DoBlue )
are set, in a call to
.ZN XStoreColor
to change the color cell specified by the pixel member of the
.ZN XcmsColor
structure.
This pixel value must be a valid index for the specified colormap,
and the color cell specified by the pixel value must be a read/write cell.
If the pixel value is not a valid index, a
.ZN BadValue
error results.
If the color cell is unallocated or is allocated read-only, a
.ZN BadAccess
error results.
If the colormap is an installed map for its screen, 
the changes are visible immediately.
.LP
Note that 
.ZN XStoreColor
has no return value; therefore, a
.ZN XcmsSuccess
return value from this function indicates that the conversion 
to RGB succeeded and the call to
.ZN XStoreColor
was made.
To obtain the actual color stored, use
.ZN XcmsQueryColor .
Due to the screen's hardware limitations or gamut compression,
the color stored in the colormap may not be identical
to the color specified.
.LP
.ZN XcmsStoreColor
can generate
.ZN BadAccess ,
.ZN BadColor ,
and
.ZN BadValue
errors.
.LP
The
.ZN XcmsStoreColors
function converts the colors specified in the array of
.ZN XcmsColor
structures into RGB values and then uses these RGB specifications in an
.ZN XColor
structures, whose three flags 
.Pn ( DoRed , 
.ZN DoGreen ,
and
.ZN DoBlue )
are set, in a call to
.ZN XStoreColors
to change the color cells specified by the pixel member of the corresponding
.ZN XcmsColor
structure.
Each pixel value must be a valid index for the specified colormap,
and the color cell specified by each pixel value must be a read/write cell.
If a pixel value is not a valid index, a
.ZN BadValue
error results.
If a color cell is unallocated or is allocated read-only, a
.ZN BadAccess
error results.
If more than one pixel is in error,
the one that gets reported is arbitrary.
If the colormap is an installed map for its screen, 
the changes are visible immediately.
.LP
Note that 
.ZN XStoreColors
has no return value; therefore, a
.ZN XcmsSuccess
return value from this function indicates that conversions 
to RGB succeeded and the call to
.ZN XStoreColors
was made.
To obtain the actual colors stored, use
.ZN XcmsQueryColors .
Due to the screen's hardware limitations or gamut compression,
the colors stored in the colormap may not be identical
to the colors specified.
.LP
.LP
.ZN XcmsStoreColors
can generate
.ZN BadAccess ,
.ZN BadColor ,
and
.ZN BadValue
errors.
.SH DIAGNOSTICS
.\" $Header: badaccess2.e,v 1.1 87/09/04 08:22:45 mento Exp $
.TP 1i
.ZN BadAccess
A client attempted
to free a color map entry that it did not already allocate.
.\" $Header: badaccess3.e,v 1.1 87/09/04 08:22:50 mento Exp $
.TP 1i
.ZN BadAccess
A client attempted
to store into a read-only color map entry.
.\" $Header: badcolor.e,v 1.1 87/09/04 08:22:57 mento Exp $
.TP 1i
.ZN BadColor
A value for a Colormap argument does not name a defined Colormap.
.\" $Header: badvalue.e,v 1.1 87/09/04 08:23:19 mento Exp $
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
XcmsAllocColor(3X11),
XcmsQueryColor(3X11)
.br
\fI\*(xL\fP
