.\" $XConsortium: MBToCT.man,v 1.2 91/10/08 15:24:17 rws Exp $
.\" Copyright 1990 by OMRON Corp.  All Rights Reserved.
.TH _XConvertMBToCT 3X11 "Release 5" "X Version 11" "XSI FUNCTIONS"
.SH NAME
_XConvertMBToCT \- conversion from mb string to CT
.SH SYNOPSIS
.B int _XConvertMBToCT\f2(xlocale, mb_str, mb_bytes, ct_str, ct_bytes,
.br
.B                                    \f2scanned_bytes, state)
.br
.B XLocale \f2xlocale\f3;
.br
.B char \f2*mb_str\f3;
.br
.B int \f2mb_bytes\f3;
.br
.B char \f2*ct_str\f3;
.br
.B int \f2*ct_bytes\f3;
.br
.B int \f2*scanned_bytes\f3;
.br
.B _State \f2*state\f3;
.SH ARGUMENTS
.IP \fIxlocale\fP 1i
In: specifies locale, the default NULL is the current locale.
.IP \fImb_str\fP 1i
In: multibyte string.
.br
.IP \fImb_bytes\fP 1i 
In: length of mb string, counted in bytes.
.br
.IP \fIct_str\fP 1i 
Out: conversion buffer of result CT string.
.br
.IP \fIct_bytes\fP 1i 
In/Out: as "In" it is length of buffer ct_str
passed by caller; as "Out" it is the returned
length of converted CT string, both counted in bytes.
.br
.IP \fIscanned_bytes\fP 1i 
Out: scanned number of bytes of mb_str,
.br
.IP \fIstate\fP 1i 
In/Out: as "In" it is the state at the beginning of mb string;
as "Out" it is the current state stopped at the last converted mb string.
.br
.SH DESCRIPTION
The
.B _XConvertMBToCT
converts the multibyte string encoded in the specfied \fIxlocale\fP
to CT string.
After a successful conversion the default state designation of CT (usually
it's Latin-1 GL) will
be appended at ct_str if the last state is not default state.
And function will automatically
append a null character to ct_str if more room in output buffer ct_str.
This null character is not counted in length of CT string.
.PP
When fucntion returns at any time, scanned_bytes always remembers
where stopped, and \fIstate\fP always remembers the curren state
of \fIxlocale\fP if it is state-dependent codeset.
.PP
The caller of this funcion has to provide the output buffer ct_str.
By using \fIscanned_bytes\fP and \fIstate\fP, the caller can break a large
mb string into pieces, and convert one piece at a time.
The result of CT string is concatenatable. However concatenation
may produce reduntant designation sequence.
.PP
If the codeset of the \fIxlocale\fP is state-dependent and
the mb_str is passed as NULL pointer, the function will set
initial state in the specfied \fIxlocale\fP.
Usually, the application should calls it with NULL mb_str for first
conversion as the following:
.IP "" "   "
\f3_XConvertMBToCT(NULL, mb_bytes, wc_str,
            &mb_bytes, &scanned)\f2
.PP
The function returns BadBuffer meaning that
the output buffer ct_str was exhausted. In this case function
ensure that the ct_str
stores already converted CT string; ct_bytes stores 
number of bytes of ct_str; the scanned_bytes stores
the number of already proccessed mb string. 
Caller can move mb_str to (mb_str + *scanned_bytes) for next conversion.
.PP
The function returns a number greate than zero meaning a BadEncoding,
the unconvertable codes in mb string were met.
In this case the function will automatically recover the wrong code
with the following algorithm:
.IP "" 2
If a byte of mb codepoint is wrong, replace it with the mininum byte
of the character encoded in the current charset.
.PP
Then function continues to do conversion.
.PP
Both the null character and mb_bytes will terminate the conversion.
.PP
All errors are defined less than zero, i.e.:
.IP "" 2
#define Success         0
.IP 
#define BadBuffer      -1
.IP
#define BadTerminate   -2
.IP
#define BadEncoding    -3
.SH RETURNED VALUE
The
.B _XConvertMBToCT returns the following value:
.TP
.B Success
successful conversion.
.TP
.B BadBuffer
buffer was exhausted.
.TP
.B BadTerminate
mb_str terminated at uncomplete codepoint.
.TP
.B BadEncoding
wrong codepoints can not be recovered.
.TP
.B "> 0"
number of wrong codepoints, but recovered.
.SH "SEE ALSO"
Refer to "CT and WC" for their definitions.
