.\" $XConsortium: LocalIM.man,v 1.4 91/12/27 15:11:47 rws Exp $
.\" Copyright 1991 by OMRON Corp.  All Rights Reserved.
.TH LocalIM 3X11 "Release 5" "X Version 11" "XSI FUNCTIONS"
.SH NAME
LocalIM \- Conversion table of Local Input Method
.SH DESCRIPTION
.PP
Converts keysyms to some keysym and strings.
.PP
If the modifier @im is defined "\fILocal\fP", this table is loaded
by the input method.
.PP
.B Coding format:
.sp
.RS
<from>[<from>...]  [<to>[<to>...]]  [{str}[{str}...]
.br
or
.br
<from>[<from>...]  Command
.br
or
.br
InitialState  OnState/OffState
.sp
.RE
.IP \fBfrom\fP 1i
Specifies a input keysym name which is enclosed with '<' and '>'.
.IP \fBto\fP 1i
Specifies a output keysym name which is enclosed with '<' and '>'.
.IP \fBstr\fP 1i
Specifies output string name which is enclosed with '{' and '}'.
the number of \fIstr\fP must equal to the number of \fIto.\fP
.IP \fBCommand\fP 1i
Specifies which command (NoFilter/ConvertOn/ConvertOff).
.br
.sp
.RS
.IP NoFilter 1i
The input keysym(s) (from) is(are) not filtered by the input method.
.IP ConvertOn 1i
If the input keysym(s) (from) is(are) pressed, the input method
move in a conversion \fBon\fP state.
.IP ConvertOff 1i
If the input keysym(s) (from) is(are) pressed, the input method
move in a conversion \fBoff\fP state.
.sp
.RE
.IP InitialState 1i
Specifies the initial state. The second argument is OnState or
OffState. The default state is OnState.
.sp
.PP
It is possible to omit \fIto\fP or \fIstr\fP. But either must be set.
.PP
.B Code notation of str:
.sp
.RS
\\n	--> NewLine
.br
\\t	--> Tab
.br
\\b	--> BackSpace
.br
\\r	--> CarriageReturn
.br
\\f	--> FormFeed
.br
\\e or \\E	--> Escape
.br
\\\\	--> BackSlash
.br
\\??? or \\o???	--> Octal
.br
\\x??	--> Hexadecimal
.br
other	--> raw code
.sp
.RE
.SH EXAMPLE
.sp
.RS
InitialState            OffState
.br
<Meta_L>                NoFilter
.br
<Execute>               ConvertOn
.br
<Execute>               ConvertOff
.br
<backslash><Mod1><C>    <cent>          {\\E-A\\xa2}
.br
<grave><A>              <Agrave>        {\\E-A\\xc0}
.sp
.RE
