.\" $XConsortium: xdpr.man,v 1.13 91/07/30 18:10:03 gildea Exp $
.TH XDPR 1 "Release 5" "X Version 11"
.SH NAME
xdpr \- dump an X window directly to a printer
.SH SYNOPSIS
.B xdpr
[
.I filename
]
[
.B \-display
.I host:display
]
[
.B \-P\fIprinter\fP
]
[
.B \-device
.I devtype
]
[
.I option
\&.\|.\|.
]

.SH DESCRIPTION
.I Xdpr
uses the commands 
.I xwd,
.I xpr, 
and
.I lpr
or
.I lp
to dump an X window, process it for a particular printer type, and
print it out on the printer of your choice.  This is the easiest way
to get a printout of a window.  \fIXdpr\fP by default will print the
largest possible representation of the window on the output page.
.PP
The options for \fIxdpr\fP are the same as those for \fIxpr\fP,
\fIxwd\fP, and \fIlpr\fP or \fIlp\fP.
The most commonly-used options are described
below; see the manual pages for these commands for
more detailed descriptions of the many options available.
.SH OPTIONS
.TP
.I filename
Specifies a file containing a window dump (created by \fIxwd\fP) to be
printed instead of selecting an X window.
.TP
.B \-P\fIprinter\fP
Specifies a printer to send the output to.  If a printer name is not
specified here, \fIxdpr\fP (really, \fIlpr\fP or \fIlp\fP)
will send your output to the
printer specified by the \fIPRINTER\fP environment variable. 
Be sure that type of the printer matches the type specified
with the \fI\-device\fP option.
.TP
.B \-display \fIhost:display\fP[\fI.screen\fP]
.cm .IB host : display
Normally,
.I xdpr
gets the host and display number to use from the environment
variable ``DISPLAY.''
One can, however, specify them explicitly; see \fIX\fP(1).
.TP
.B \-device \fIdevtype\fP
Specifies the device on which the file will be printed.  Currently supported:
.RS 12
.PD 0
.TP
.B la100
Digital LA100
.TP
.B ljet
\s-1HP\s+1 LaserJet series and other monochrome PCL devices
such as ThinkJet, QuietJet, RuggedWriter, \s-1HP\s+12560 series,
and \s-1HP\s+12930 series printers
.TP
.B ln03
Digital LN03
.TP
.B pjet
HP PaintJet (color mode)
.TP
.B pjetxl
HP HP PaintJet XL Color Graphics Printer (color mode)
.TP
.B pp
IBM PP3812
.TP
.B ps
PostScript printer
.PD
.RE
.IP
The default is PostScript.
\fB\-device lw\fP (LaserWriter) is equivalent to \fB\-device ps\fP and is
provided only for backwards compatibility.
.TP
.B \-help
This option displays the list of options known to
.I xdpr.
.PP
Any other arguments 
will be passed to the 
.I xwd,
.I xpr,
and
.I lpr
or
.I lp
commands as appropriate for each.
.SH SEE ALSO
.IR xwd (1),
.IR xpr (1),
.IR lpr (1),
.IR lp (1),
.IR xwud (1),
.IR X (1)
.SH ENVIRONMENT
.TP 10
DISPLAY
which display to use by default.
.TP 10
PRINTER
which printer to use by default.
.SH COPYRIGHT
Copyright 1985, 1988, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Paul Boutin, MIT Project Athena
.br
Michael R. Gretzinger, MIT Project Athena
.br
Jim Gettys, MIT Project Athena
