#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <ctype.h>
#include <dirent.h>
#include <unistd.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>

#include "filemgr.h"
#include "debug.h"

extern int do_all;
extern char *actual_command1[];


/***************************************************************************
 *
 * Attempts to open a selected file 
 *
 ***************************************************************************/
void OpenFile(struct dir_win *dir, struct filelist *list, 
	      struct dir_win **dir_root,struct mapping *mapping_root,
	      char *newname)
{
  char *t1 = NULL, *t2 = NULL, *temp_string = NULL;

  if((!dir)||(!dir->dir_name))
    return;
  
  if((newname)&&(strlen(newname) > 0))
    {
      /* Open the file called newname */
      while(isspace(*newname))newname++;
      if(strlen(newname)==0)
	return;

      if(*newname == '~')
	{
	  temp_string = safemalloc(strlen(newname)+1,"opentemp");	  
	  strcpy(temp_string,newname);
	  temp_string = ExpandDirName(temp_string);
	}
      else if(*newname == '/')
	{
	  temp_string = safemalloc(strlen(newname)+1,"opentemp");
	  strcpy(temp_string,newname);
	}
      else if (*newname == '!')
	{
	  chdir(dir->dir_name);
	  system(newname+1);
	  refresh_dir_list(dir,dir_root,do_all,mapping_root);
	  return;
	}
      else
	{
	  temp_string = safemalloc(strlen(dir->dir_name)+strlen(newname)+1,
				    "opentemp2");
	  strcpy(temp_string,dir->dir_name);
	  strcat(temp_string,"/");
	  strcat(temp_string,newname);
	}
      OpenNamedFile(temp_string,dir_root, do_all,mapping_root,dir);
      safefree(temp_string,"a","b");
      return;
    }

  if(!list)
    return;

  if((list->mode[0] == 'd')&&(dir->one_op_cmd == 0))
    {
      temp_string = (char *)
	safemalloc(strlen(dir->dir_name)+
		   strlen(list->filename)+2,"Temp_String");
      strcpy(temp_string,dir->dir_name);
      strcat(temp_string,"/");
      strcat(temp_string,list->filename);
      create_dir_list(dir_root,temp_string,do_all,mapping_root);
      safefree(temp_string,"temp_string","Open1");
    }
  else
    {
      /* not a directory, start the application */
      chdir(dir->dir_name);
      t1 = 
	ExpandDollarsignFile(actual_command1[dir->one_op_cmd],
			     "$open",list->command,0);
      t2 = ExpandDollarsignFile(t1, "$file", list->filename,1);
      safefree(t1,"t1","open");
      if(t2 != NULL)
	system(t2);
      safefree(t2,"temp_string","Open2");
      refresh_dir_list(dir,dir_root,do_all,mapping_root);
    }
}





/***************************************************************************
 *
 * Attempts to open a file whose name was typed in to the OpenFile: box.
 *
 ***************************************************************************/
void OpenNamedFile(char *name,struct dir_win **dir_root,
		   int do_all,struct mapping *mapping_root, 
		   struct dir_win *thatdir)
{
  struct stat filestat;
  char mode[11];
  struct mapping *map;
  char *t1,*t2;
  int i;
  
  if(stat(name,&filestat)==0)
    {
      if((S_ISDIR(filestat.st_mode))&&(thatdir->one_op_cmd == 0))
	{
	  create_dir_list(dir_root,name,do_all,mapping_root);
	}
      else
	{
	  for(i=0;i<10;i++)
	    mode[i] = '-';
	  if(filestat.st_mode& S_IRUSR)
	    mode[1] = 'r';
	  if(filestat.st_mode& S_IWUSR)
	    mode[2] = 'w';
	  if(filestat.st_mode& S_IXUSR)
	    {
	      if(filestat.st_mode & S_ISUID)
		mode[3] = 's';
	      else
		mode[3] = 'x';
	    }
	  
	  if(filestat.st_mode& S_IRGRP)
	    mode[4] = 'r';
	  if(filestat.st_mode& S_IWGRP)
	    mode[5] = 'w';
	  
	  if(filestat.st_mode& S_IXGRP)
	    {
	      if(filestat.st_mode & S_ISGID)
		mode[6] = 's';
	      else
		mode[6] = 'x';
	    }
	  
	  if(filestat.st_mode& S_IROTH)
	    mode[7] = 'r';
	  if(filestat.st_mode& S_IWOTH)
	    mode[8] = 'w';
	  if(filestat.st_mode& S_IXOTH)
	    mode[9] = 'x';
	  map = matchup(mapping_root,name,NULL,mode);
	  if((map != NULL)&&(map->command != NULL))
	    {
	      /* not a directory, start the application */
	      t1 = 
		ExpandDollarsignFile(actual_command1[thatdir->one_op_cmd],
				     "$open",map->command,0);
	      t2 = ExpandDollarsignFile(t1, "$file", name,1);
	      safefree(t1,"t1","open");
	      chdir(thatdir->dir_name);
	      if(t2 != NULL)
		system(t2);
	      safefree(t2,"temp_string","Open2");
	      refresh_dir_list(thatdir,dir_root,do_all,mapping_root);
	    }
	}
    }
}



char *ExpandDollarsignFile(char *intext,char *key, char *replacement, 
			   int add_to_end)
{
  char *thisptr,*newtext,*lastptr;
  int occurances = 0;
  int rw;


  if((intext == NULL)||(key == NULL))
    {
      return NULL;
    }

  if(replacement == NULL)
    rw = 0;
  else
    rw = strlen(replacement);

  thisptr = intext;
  while(thisptr != NULL)
    {
      thisptr = strstr(thisptr,key);
      if(thisptr != NULL)
	{
	  occurances++;
	  thisptr += 5;
	}
    }

  if(occurances == 0)
    occurances = 1;

  newtext = safemalloc(strlen(intext) - occurances*strlen(key) +
		       occurances*rw+4,"NewText");
  newtext[0] = 0;
  thisptr = intext;
  lastptr = intext;

  occurances = 0;
  thisptr = intext;
  lastptr = intext;

  while(thisptr != NULL)
    {
      thisptr = strstr(lastptr,key);
      if(thisptr != NULL)
	{
	  strncat(newtext,lastptr,thisptr-lastptr);
	  if(replacement != NULL)
	    strcat(newtext,replacement);
	  lastptr = thisptr+strlen(key);
	  occurances++;
	}
      else
	strcat(newtext,lastptr);
    }

  if((occurances == 0)&&(add_to_end)&&(replacement != NULL))
    {
      strcat(newtext," ");
      strcat(newtext,replacement);
    }
  fprintf(stderr,"expansion done\n");  
  return newtext;
}
