#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <math.h>
#include <time.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>


#include "filemgr.h"
#include "debug.h"

#include <X11/extensions/shape.h>



extern Display *dpy;
extern int x_fd,screen, ScreenWidth,ScreenHeight, d_depth;
extern Window Root;
extern char *MyName;
extern char *iconPath, *pixmapPath, *ForeColor, *BackColor;
extern int w,h,x,y,max_w,min_w,max_h,min_h;
extern Atom wm_del_win;

extern Window garbage_win;
extern XpmIcon garbage;
extern XpmIcon full_garbage;
extern struct dir_win *garbage_dir;
extern char this_is_garbage;

XFontStruct *font;
extern int font_height;
extern GC  NormalGC,ShadowGC,ReliefGC, rvGC;
extern Pixel hilite_pix, back_pix, shadow_pix, fore_pix;

int min_pixmap_width = MIN_PIXMAP_WIDTH;
int min_pixmap_height = MIN_PIXMAP_HEIGHT;

char *one_op_command[]={"open","trash","remove"};
/* "Open" should be first, since it gets special treatment */
char *actual_command1[] = {"$open $file &", 
			     "mv $file $HOME/.wastebasket",
			     "rm $file"};
char *two_op_command[] = {"move","copy"};
char *actual_command2[] = {"mv $file1 $file2",
			     "cp -r $file1 $file2"};

#ifndef S_ISLNK
#ifndef _S_IFMT
#define _S_IFMT S_IFMT
#endif
#define S_ISLNK(mode)           (((mode) & _S_IFMT) == S_IFLNK)
#endif /* S_ISLNK */
			     

#define TW_EVENTS   (ExposureMask | StructureNotifyMask| ButtonReleaseMask |\
		     ButtonPressMask | ButtonMotionMask | KeyPressMask)
#define MW_EVENTS   (ButtonReleaseMask | ButtonPressMask | ButtonMotionMask)
/***************************************************************************
 *
 * Scans the directory named "dirname", after first expanding any leading 
 * "~". If do_all is set, then it includes hidden directories too 
 *
 ***************************************************************************/
struct dir_win *create_dir_list(struct dir_win **dir_root,
				char *dirname,int do_all,
				struct mapping *mapping_root)
{
  char *dir= NULL,*filename;
  DIR *activeDir;
  struct dirent *newEntry;
  struct stat filestat;
  struct filelist *list = NULL;
  struct dir_win *thisdir,*tempdir;
  
  if(dirname == NULL)return NULL;

  dir = (char *)safemalloc(strlen(dirname)+1,"dir");
  strcpy(dir,dirname);
  dir = ExpandDirName(dir);
  if(dir == NULL)
    return NULL;

  /* see if a window for this directory already exists */
  tempdir = *dir_root;
  while(tempdir != NULL)
    {
      if(strcmp(tempdir->dir_name,dir)==0)
	{
	  safefree(dir,"dir","Already exists");
	  if(tempdir->open != 1)
	    {
	      tempdir->open = 1;
	      XMapWindow(dpy,tempdir->top_win);
	    }
	  XRaiseWindow(dpy,tempdir->top_win);
	  return NULL;
	}
      tempdir = tempdir->next;
    }
  
  thisdir = (struct dir_win *)
    safemalloc(sizeof(struct dir_win),"dir_win");

  thisdir->nfiles = 0;
  thisdir->file_root = NULL;
  thisdir->w = 0;
  thisdir->h = 0;
  thisdir->next = *dir_root;
  thisdir->pixmap_width = min_pixmap_width;
  thisdir->pixmap_height = min_pixmap_height;
  thisdir->stacking_order = 0;
  thisdir->frame_x = 0;
  thisdir->frame_y = 0;
  thisdir->frame_width = 0;
  thisdir->frame_height = 0;
  thisdir->open = 1;
  *dir_root = thisdir;

  CreateWindow(thisdir);

  thisdir->dir_name = dir;
  change_window_name(thisdir->top_win,thisdir->dir_name);

  activeDir = opendir(dir);

  if(activeDir == NULL)
    {
      delete_filelist(thisdir, dir_root,mapping_root);
      return NULL;
    }
  while((newEntry = readdir(activeDir))!= NULL)
    {
      if((newEntry->d_name[0] != '.')||(do_all))
	{
	  if(list == NULL)
	    {
	      list = (struct filelist *)
		safemalloc(sizeof(struct filelist),"list");
	      thisdir->file_root = list;
	    }
	  else
	    {
	      list->nextfile = (struct filelist *)
		safemalloc(sizeof(struct filelist),"listnext");
	      list = list->nextfile;
	    }

	  list->nextfile = NULL;
	  list->icon_loc_count = 0;
	  list->type = NULL;
	  list->command = NULL;
	  filename = (char *) 
	    safemalloc(strlen(dir)+strlen(newEntry->d_name)+2,"filename");
	  strcpy(filename,dir);
	  strcat(filename,"/");
	  strcat(filename,newEntry->d_name);
	  list->filename = (char *) 
	    safemalloc(strlen(newEntry->d_name)+1,"filename");
	  strcpy(list->filename,newEntry->d_name);
	  
	  if(stat(filename,&filestat)==0)
	    {
	      expand_mode(list->mode, filestat.st_mode);
	      list->size = filestat.st_size;
	      list->st_mode = filestat.st_mode;
	    }
	  else
	    {
	      list->st_mode = 0;
	      list->size = 0;
	      list->mode[0] = 0;
	    }
	  safefree(filename,"filename","dir");
	  find_icon(list,mapping_root);
	  
	  CreateIconWindow(thisdir->main_win,list);
	  if(list->icon_w > thisdir->pixmap_width)
	    thisdir->pixmap_width = list->icon_w;
	  if(list->icon_h > thisdir->pixmap_height)
	    thisdir->pixmap_height = list->icon_h;
	  list->selected = 0;
	  list->CheckedOut = 0;
	  list->drawn_selected = 0;
	  
	  thisdir->nfiles++;
	}
    }
  closedir(activeDir);
  Sort(thisdir);
  
  ReconfigureWin(thisdir,0,0,0);
  XMapSubwindows(dpy,thisdir->top_win);
  XMapWindow(dpy,thisdir->top_win);    
  thisdir->last_update_time = time(0);
  
  return thisdir;
}


/***************************************************************************
 *
 * Frees memory used by the currently cached directory list 
 *
 ***************************************************************************/
void delete_filelist(struct dir_win *thisdir,struct dir_win **dir_root,
		     struct mapping *mapping_root)
{
  struct filelist *next,*list,**listptr, **nextptr;
  struct dir_win *temp,*prev;
  extern struct filelist *selection;
  
  list = thisdir->file_root;
  listptr = &(thisdir->file_root);
  XUnmapWindow(dpy,thisdir->top_win);

  while(list != NULL)
    {
      next = list->nextfile;
      nextptr = &(list->nextfile);
      if(!(list->CheckedOut))
	{
	  *listptr = next;
	  nextptr = listptr;
	  if(selection == list)
	    selection = NULL;
	  XDestroyWindow(dpy,list->IconWin);
	  XDestroyWindow(dpy,list->HoldingWin);
	  XDestroyWindow(dpy,list->LabelWin);
	  safefree(list->filename,"dir","del");
	  if(list->type != NULL)
	    safefree(list->type,"type","b");
	  safefree(list,"dir","del2");
	  thisdir->nfiles--;
	}
      list = next;
      listptr = nextptr;
    }
  
  if(thisdir->nfiles == 0)
    {
      temp = *dir_root;
      prev = NULL;
      while((temp!=NULL)&&(temp != thisdir))
	{
	  prev = temp;
	  temp = temp->next;
	}
      if(prev != NULL)
	prev->next = thisdir->next;
      else
	*dir_root = thisdir->next;

      safefree(thisdir->dir_name,"dir_name","del");
      XDestroyWindow(dpy,thisdir->main_win);
      XDestroyWindow(dpy,thisdir->top_win);
      if(thisdir == garbage_dir)
	{
	  XDestroyWindow(dpy,garbage_win);
	  garbage_dir = NULL;
	}
      safefree(thisdir,"dir_win","del");
    }
  else
    {
      XUnmapWindow(dpy,thisdir->top_win);
      thisdir->stacking_order = 0;
      thisdir->open = -1;
    }
  if((*dir_root) == NULL)
    {
      free_mapping(mapping_root);
      terminate("Delete");
    }
}



void find_icon(struct filelist *list, struct mapping *mapping_root)
{
  struct mapping *map;
  
  if(list == NULL)
    return;
  list->HoldingWin = None;
  list->IconWin = None;
  map = matchup(mapping_root,list->filename,list->type,list->mode);
  if((map != NULL)&&(map->icon == None))
    LoadIcon(map);
  if(map != NULL)
    {
      list->icon = map->icon;
      list->icon_w = map->icon_w;
      list->icon_h = map->icon_h;
      list->icon_depth = map->icon_depth;
      list->icon_mask = map->icon_mask;
      list->command = map->command;
    }
  else
    {
      list->icon = None;
      list->icon_w = 0;
      list->icon_h = 0;
      list->icon_depth = 0;
      list->icon_mask = None;  
    }
}

struct mapping *matchup(struct mapping *map,char *name,
			char *type,char *permissions)
{
  while(map != NULL)
    {
      if(matchWildcards(map->name,name))
	{
	  if(matchWildcards(map->type,type))
	    {
	      if(matchWildcards(map->permissions,permissions))
		return map;
	     }
	}
      map = map->next;
      
    }
  return NULL;
}




/************************************************************************
 *
 * Sizes and creates the window 
 *
 ***********************************************************************/
XSizeHints mysizehints;
void CreateWindow(struct dir_win *dir)
{
  int gravity = NorthWestGravity,width,width2,width3,width4,width5;
  Window main_win,top_win;
  XClassHint class1;
  XWMHints wmhints;
  
  mysizehints.flags = PWinGravity| PResizeInc | PBaseSize;
  /* subtract one for the right/bottom border */
  mysizehints.width =ScreenWidth/2;
  mysizehints.height= ScreenHeight/2;
  mysizehints.width_inc = 1;
  mysizehints.height_inc = 1;
  mysizehints.base_height = 1;
  mysizehints.base_width = 1;
  
  if(w > -1)
    {
      mysizehints.width = w;
      mysizehints.flags |= USSize;
      dir->w = w;
    }
  if(h > -1)
    {
      mysizehints.height = h;
      mysizehints.flags |= USSize;
      dir->h = h;
    }
  
  if(x > -100000)
    {
      if (x< 0)
	{
	  mysizehints.x = ScreenWidth + x - mysizehints.width - 2;
	  gravity = NorthEastGravity;
	}
      else 
	mysizehints.x = x;
      if ( y<0)
	{
	  mysizehints.y = ScreenHeight + y - mysizehints.height-2;
	  gravity = SouthWestGravity;
	}
      else 
	mysizehints.y = y;
      
      if((x < 0) && (y < 0))
	gravity = SouthEastGravity;	
      mysizehints.flags |= USPosition;
    }
  
  mysizehints.win_gravity = gravity;
#define BW 1
  
  top_win = XCreateSimpleWindow(dpy,Root,mysizehints.x,mysizehints.y,
				mysizehints.width,mysizehints.height,
				BW,fore_pix,back_pix);
  XSetWMProtocols(dpy,top_win,&wm_del_win,1);
  
  XSetWMNormalHints(dpy,top_win,&mysizehints);
  XSelectInput(dpy,top_win,TW_EVENTS);
  
  if(this_is_garbage)
    {
      wmhints.initial_state = IconicState;
      wmhints.icon_window = garbage_win;
      wmhints.input = True;
      wmhints.flags = InputHint | StateHint | IconWindowHint;
      class1.res_name = "Garbage";
    }
  else
    {
      wmhints.initial_state = NormalState;
      wmhints.input = True;
      wmhints.flags = InputHint | StateHint;
      class1.res_name = MyName;
    }
  
  class1.res_class = "FvwmModule";
  
  XSetWMProperties(dpy,top_win,NULL,NULL,NULL,0,
		   &mysizehints,&wmhints,&class1);
  
   change_window_name(top_win,MyName);  
  
  main_win = 
     XCreateSimpleWindow(dpy,top_win,-BW,2*font_height+3,
			 mysizehints.width,
			 mysizehints.height-(font_height+3),
			 BW,fore_pix,back_pix);
  
  XSelectInput(dpy,main_win,MW_EVENTS);
  
  width = XTextWidth(font,"Commands: 1-<op ",14) + EDGE_PAD + 1;
  width2 = (int)mysizehints.width/2 - width;
  width3 = XTextWidth(font,"drwxrwxrwx 9999999999 ",22);
  width4 = XTextWidth(font," 2-op",5);
  width5 = XTextWidth(font,"MMMMMM",6);
  if(width2 < 100)width2 = 100;
  dir->open_width = width2;
  dir->open_x = width;
  dir->open_win = XCreateSimpleWindow(dpy,top_win,width,
				      font_height+2, width2,
				      font_height-2,
				      BW,fore_pix,back_pix);
  
  dir->size_win = XCreateSimpleWindow(dpy,top_win,width+width2+5,
				      font_height+3,
				      width3 ,
				      font_height-2,
				      0,fore_pix,back_pix);
  dir->one_op_win = XCreateSimpleWindow(dpy,top_win,width,1, width5,
					font_height-2,
					BW,fore_pix,back_pix);  
  dir->two_op_win = XCreateSimpleWindow(dpy,top_win,width4+width+width2+3,
					1, width5,
					font_height-2,
					BW,fore_pix,back_pix);  

  dir->one_op_cmd = 0;
  dir->two_op_cmd = 0;

  XSelectInput(dpy,dir->open_win,(ButtonReleaseMask | ButtonPressMask | 
				  ButtonMotionMask|ExposureMask));
  XSelectInput(dpy,dir->one_op_win,(ButtonReleaseMask | ButtonPressMask | 
				  ButtonMotionMask|ExposureMask));
  XSelectInput(dpy,dir->two_op_win,(ButtonReleaseMask | ButtonPressMask | 
				    ExposureMask));
  XSelectInput(dpy,dir->size_win,(ButtonReleaseMask | ButtonPressMask | 
				  ExposureMask));
  
  dir->main_win = main_win;
  dir->top_win = top_win;
  dir->nx = 0;
  return;
}

/**************************************************************************
 *  Change the window name displayed in the title bar.
 **************************************************************************/
void change_window_name(Window w, char *str)
{
  XTextProperty name;
  char *gstring = "Garbage";
  
   if (XStringListToTextProperty(&str,1,&name) == 0) 
     {
       fprintf(stderr,"%s: cannot allocate window name",MyName);
       return;
     }
  XSetWMName(dpy,w,&name);
  
  if((this_is_garbage)||((garbage_dir)&&(w == garbage_dir->top_win)))
    {
      XFree(name.value);
      if (XStringListToTextProperty(&gstring,1,&name) == 0) 
	{
	  fprintf(stderr,"%s: cannot allocate garbage name",MyName);
	  return;
	}
      XSetWMIconName(dpy,w,&name);
    }
  else
    XSetWMIconName(dpy,w,&name);
  XFree(name.value);
}




void ReconfigureWin(struct dir_win *dir, char Force, int w, int h)
{
  int xcmax,nx,ny,w2;
  struct filelist *list;
  
  if(!dir)
    return;
  
  if(dir->w == 0)
    nx = (int)sqrt((float)(dir->nfiles));
  else
    nx = (dir->w-2*EDGE_PAD)/(dir->pixmap_width);
  
  if(nx < 1)
    nx = 1;
  
  ny = nx;
  if(ny < 1)
    ny = 1;
  while(ny*nx < dir->nfiles)
    {
      ny++;
      if(ny*nx < dir->nfiles)
	nx++;
    }
  if((w == 0)&&(h == 0))
    {
      w = (dir->pixmap_width)*nx + 2*EDGE_PAD;
      if(w > max_w)
	w = max_w;
      if(w < min_w)
	 w = min_w;
      h = (dir->pixmap_height+font_height)*ny + 2*EDGE_PAD;
      if(h > max_h)
	h = max_h;
      if(h < min_h)
	 h = min_h;
      XResizeWindow(dpy,dir->top_win,w,h+2*font_height+3);
    }
  if((dir->w !=w)||(dir->h!=h))
    {
      XResizeWindow(dpy,dir->main_win,w,h);
      dir->open_width = w/2 - dir->open_x;
      if(dir->open_width < 100)
	dir->open_width = 100;
      XResizeWindow(dpy,dir->open_win,dir->open_width,
		    font_height-2);
      XMoveWindow(dpy,dir->size_win,dir->open_x + dir->open_width + 5,
		  font_height+3);
      w2 = dir->open_x + dir->open_width + XTextWidth(font," 2-op",5)+3;
      XMoveWindow(dpy,dir->two_op_win,w2,1);
      XClearArea(dpy,dir->top_win,0,0,dir->w,dir->h,1);
      dir->w = w;
      dir->h = h;
      dir->nx = nx;
    }
  nx = (dir->w-2*EDGE_PAD)/(dir->pixmap_width);

  if((Force)||(dir->nx == 0))
    {
      dir->nx = nx;
    }
  
  nx = dir->nx;
  
  xcmax = nx*dir->pixmap_width;
  /* Force a complete re-arrangement */
  if(Force)
    {
      list = dir->file_root;
      while(list != NULL)
	{
	  list->icon_x = 0;
	  list->icon_y = 0;
	  list = list->nextfile;
	}
    }
  list = dir->file_root;
  while(list != NULL)
    {
      if((list->icon_x == 0)&&(list->icon_y == 0))
	{
	  FindSpot(dir,list,nx,ny,xcmax);
	  ConfigureIconWindow(list,dir->pixmap_width,dir->pixmap_height);
	}
      list = list->nextfile;
    }
}

void Sort(struct dir_win *thisdir)
{
  struct filelist *list,*list2,**prev2,**prev,*swaptarget,*t,**swapprev=NULL;
  
  /* Sort the windows alphabetically */
  list = thisdir->file_root;
  prev = &thisdir->file_root;
  while(list != NULL)
    {
      swaptarget = list;
      
      list2 = list->nextfile;
      prev2 = &(list->nextfile);
      while(list2 != NULL)
	{
	  if(strcasecmp(list2->filename,swaptarget->filename)<0)
	    {
	      swaptarget = list2;
	      swapprev = prev2;
	    }
	  prev2 = &(list2->nextfile);
	  list2 = list2->nextfile;
	}
      if(swaptarget != list)
	{
	  /* swap list and swaptarget */
	  t = swaptarget->nextfile;
	  if(list->nextfile == swaptarget)
	    swaptarget->nextfile = list;
	  else
	    swaptarget->nextfile = list->nextfile;
	  *prev = swaptarget;
	  *swapprev = list;
	  list->nextfile = t;
	}
      list = swaptarget->nextfile;
      prev = &(swaptarget->nextfile);
    }
}



/***************************************************************************
 *
 * Refresh directory list
 *
 *************************************************************************/
void refresh_dir_list(struct dir_win *thisdir,
		      struct dir_win **dir_root,
		      int do_all,
		      struct mapping *mapping_root)
{
  char *dir= NULL,*filename;
  DIR *activeDir;
  struct dirent *newEntry;
  struct stat filestat;
  struct filelist *list = NULL, *list2,**prev, *next;
  int changed = 0;
  char matched;
  extern struct filelist *selection;
  
  if(thisdir->dir_name == NULL)
    {
      delete_filelist(thisdir,dir_root,mapping_root);
      return;
    }

  if((thisdir->open != 1)&&(thisdir != garbage_dir))
    return;

  dir = safemalloc(strlen(thisdir->dir_name)+1,"dir");
  strcpy(dir,thisdir->dir_name);
  dir = ExpandDirName(dir);
  if(dir == NULL)
    {
      delete_filelist(thisdir, dir_root,mapping_root);
      return;
    }    
  
  if(strcmp(dir,thisdir->dir_name) != 0)
    {
      safefree(thisdir->dir_name,"dir_name","a");
      thisdir->dir_name = dir;
      change_window_name(thisdir->main_win,thisdir->dir_name);
    }
  else
    safefree(dir,"dir","a");
  
  dir = thisdir->dir_name;
  
  activeDir = opendir(dir);
  
  if(activeDir == NULL)
    {
      delete_filelist(thisdir, dir_root,mapping_root);
      return;
    }
  /* Mark all files in the file-list as not updated */
  list = thisdir->file_root;
  while(list != NULL)
    {
      list->updated = 0;
      list = list->nextfile;
    }
  while((newEntry = readdir(activeDir))!= NULL)
    {
      if((newEntry->d_name[0] != '.')||(do_all))
	{
	  list = (struct filelist *)
	    safemalloc(sizeof(struct filelist),"list");
	  list->icon_loc_count = 0;
	  list->nextfile = NULL;
	  list->type = NULL;
	  list->command = NULL;
	  filename = (char *) 
	    safemalloc(strlen(dir)+strlen(newEntry->d_name)+2,"filename");
	  strcpy(filename,dir);
	  strcat(filename,"/");
	  strcat(filename,newEntry->d_name);
	  list->filename = (char *) 
	    safemalloc(strlen(newEntry->d_name)+1,"filename");
	  strcpy(list->filename,newEntry->d_name);
	  
	  if(stat(filename,&filestat)==0)
	    {
	      list->size = filestat.st_size;
	      list->st_mode = filestat.st_mode;
	    }
	  else
	    {
	      list->st_mode = 0;
	      list->size = 0;
	      list->mode[0] = 0;
	    }
	  safefree(filename,"filename","dir");
	  /* "list" contains a file-entry. If its name matches an
	   * existing entry, then just update the existing entry,
	   * otherwise, add it to the file-list. */
	  list2 = thisdir->file_root;
	  matched = 0;
	  while((list2 != NULL)&&(matched == 0))
	    {
	      if((list2->updated == 0)&&
		(strcmp(list->filename,list2->filename)==0))
		{
		  /* got a match */
		  list2->updated = 1;
		  matched = 1;
		  list2->size = list->size;
		  if(list2->st_mode != list->st_mode)
		    {
		      /* need to actually replace entry & get new icon */
		      list2->st_mode = list->st_mode;
		      expand_mode(list2->mode,(long)list2->st_mode);
		      if(list2->type != NULL)
			  safefree(list2->type,"type","a");
		      list2->type = list->type;
		      list->type = NULL;
		      XDestroyWindow(dpy,list2->IconWin);
		      XDestroyWindow(dpy,list2->HoldingWin);
		      XDestroyWindow(dpy,list2->LabelWin);
		      
		      find_icon(list2,mapping_root);
		      CreateIconWindow(thisdir->main_win,list2);
		      if(list2->icon_w > thisdir->pixmap_width)
			thisdir->pixmap_width = list2->icon_w;
		      if(list2->icon_h > thisdir->pixmap_height)
			thisdir->pixmap_height = list2->icon_h;
		      changed = 1;
		    }
		}
	      list2 = list2->nextfile;
	    }	  
	  if(matched)
	    {
	      if(list->filename != NULL)
		free(list->filename);
	      if(list->type != NULL)
		safefree(list->type,"type","b");
	      safefree(list,"list","H");
	    }
	  else
	    {
	      /* add to dir list */
	      expand_mode(list->mode,(long)list->st_mode);
	      list->nextfile = thisdir->file_root;
	      thisdir->file_root= list;
	      list->selected =0;
	      list->CheckedOut =0;
	      list->drawn_selected = 0;
	      find_icon(list,mapping_root);
	      CreateIconWindow(thisdir->main_win,list);
	      if(list->icon_w > thisdir->pixmap_width)
		thisdir->pixmap_width = list->icon_w;
	      if(list->icon_h > thisdir->pixmap_height)
		thisdir->pixmap_height = list->icon_h;
	      thisdir->nfiles++;
	      list->updated = 1;
	      changed = 1;
	    }
	}
    }
  closedir(activeDir);
  
  /* remove files that are no longer in the list */
  list = thisdir->file_root;
  prev = &thisdir->file_root;
  while(list != NULL)
    {
      next = list->nextfile;
      if(list->updated == 0)
	{
	  if(selection == list)
	    selection = NULL;
	  XDestroyWindow(dpy,list->IconWin);
	  XDestroyWindow(dpy,list->HoldingWin);
	  XDestroyWindow(dpy,list->LabelWin);
	  safefree(list->filename,"dir","del");
	  if(list->type != NULL)
	    safefree(list->type,"type","b");
	  *prev = list->nextfile;
	  safefree(list,"dir","del2");
	  thisdir->nfiles --;
	  changed = 1;
	}
      else
	{
	  prev = &list->nextfile;
	}
      list = next;
    }
  
  if(changed)
    {
      Sort(thisdir);
      if(thisdir->nfiles == 1)
	ReconfigureWin(thisdir,1,thisdir->w,thisdir->h);
      else
	ReconfigureWin(thisdir,0,thisdir->w,thisdir->h);
      if(thisdir == garbage_dir)
	update_garbage_dir(garbage_dir, do_all);
    }
  thisdir->last_update_time = time(0);
  return;
}

void RedrawWindow(struct dir_win *dir,char *newname)
{
  int w;

  XDrawString(dpy,dir->top_win,NormalGC,EDGE_PAD, font_height+font->ascent+4,
	      "Open File:",10);
  XDrawString(dpy,dir->top_win,NormalGC,EDGE_PAD, font->ascent+3,
	      "Commands: 1-op",14);
  w = dir->open_x + dir->open_width+2;
  XDrawString(dpy,dir->top_win,NormalGC,w, font->ascent+3,
	      " 2-op",5);
  RelabelFile(dir,newname);
  
}

void RelabelFile(struct dir_win *dir, char *newname)
{
  extern struct dir_win *seldir;
  extern struct filelist *selection;
  char SizeString[23];
  int w,x;

  if(!dir)
    return;

  XClearWindow(dpy,dir->open_win);
  XClearWindow(dpy,dir->size_win);
  if((seldir== dir)&&(selection))
    {
      w = XTextWidth(font,selection->filename,strlen(selection->filename));
      if(w > dir->open_width)
	x = dir->open_width - w;
      else
	x = 2;
      XDrawString(dpy,dir->open_win,NormalGC,x, font->ascent+1,
		selection->filename,strlen(selection->filename));
      strcpy(SizeString,selection->mode);
      sprintf(&SizeString[10]," %10ld",(long)selection->size);
      XDrawString(dpy,dir->size_win,NormalGC,0, font->ascent+1,
		SizeString,21);
    }
  else if(newname)
    {
      w = XTextWidth(font,newname,strlen(newname));
      if(w > dir->open_width)
	x = dir->open_width - w;
      else
	x = 2;
      XDrawString(dpy,dir->open_win,NormalGC,x, font->ascent+1,
		  newname,strlen(newname));  
    }
}


void update_garbage_dir(struct dir_win *garbage_dir,int do_all)
{
  static int last_state = -1;

  if(!garbage_dir) return;

  if((garbage_dir->nfiles == 0)||((do_all)&&(garbage_dir->nfiles <= 2)))
    {
      if(last_state != 0)
	{
	  XSetWindowBackgroundPixmap(dpy, garbage_win,garbage.pixmap);
	  XShapeCombineMask(dpy,garbage_win, ShapeBounding, 0, 0,
			    garbage.mask, ShapeSet);
	  XClearWindow(dpy,garbage_win);
	  last_state = 0;
	}
    }
  else
    {
      if(last_state != 1)
	{
	  XSetWindowBackgroundPixmap(dpy,garbage_win,full_garbage.pixmap);
	  XShapeCombineMask(dpy,garbage_win, ShapeBounding, 0, 0,
			    full_garbage.mask, ShapeSet);
	  XClearWindow(dpy,garbage_win);
	  last_state = 1;
	}
    }
}


void FindSpot(struct dir_win *dir,struct filelist *list,
	      int nx,int ny,int xcmax)
{
  struct filelist *temp;
  int found = 0, x = EDGE_PAD ,y =EDGE_PAD;
  int pw2, ph2;

  pw2 = dir->pixmap_width*3/4;
  ph2 = (dir->pixmap_height+font_height)*3/4;
  while(!found)
    {
      found = 1;
      temp = dir->file_root;
      while(temp != NULL)
	{
	  if((temp != list)&&
	     (abs(temp->icon_x -x) < pw2)&&(abs(temp->icon_y -y) < ph2)&&
	     (temp->icon_x != 0)&&(temp->icon_y != 0))
	    {
	      found = 0;
	      temp = NULL;
	    }
	  else
	    temp = temp->nextfile;
	}
      
      if(!found)
	{
	  x += dir->pixmap_width;
	  if(x > xcmax)
	    {
	      y += dir->pixmap_height+font_height;
	      x = EDGE_PAD;
	    }
	}
    }
  list->icon_x = x;
  list->icon_y = y;
}


void expand_mode(char *mode, long st_mode)
{
  int i;

  for(i=0;i<10;i++)
    mode[i] = '-';

  if(S_ISDIR(st_mode))
    mode[0] = 'd';
  if(S_ISLNK(st_mode))
    mode[0] = 'l';
  if(st_mode& S_IRUSR)
    mode[1] = 'r';
  if(st_mode& S_IWUSR)
    mode[2] = 'w';
  if(st_mode& S_IXUSR)
    {
      if(st_mode & S_ISUID)
	mode[3] = 's';
      else
	mode[3] = 'x';
    }
  
  if(st_mode& S_IRGRP)
    mode[4] = 'r';
  if(st_mode& S_IWGRP)
    mode[5] = 'w';
  
  if(st_mode& S_IXGRP)
    {
      if(st_mode & S_ISGID)
	mode[6] = 's';
      else
	mode[6] = 'x';
    }
  
  if(st_mode& S_IROTH)
    mode[7] = 'r';
  if(st_mode& S_IWOTH)
    mode[8] = 'w';
  if(st_mode& S_IXOTH)
    mode[9] = 'x';
  mode[10] = 0;
}


void RelabelCommands(struct dir_win *dir)
{
  if(!dir)
    return;
  XClearWindow(dpy,dir->one_op_win);
  XDrawString(dpy,dir->one_op_win,NormalGC,2, font->ascent+1,
	      one_op_command[dir->one_op_cmd],
	      strlen(one_op_command[dir->one_op_cmd]));
  XClearWindow(dpy,dir->two_op_win);
  XDrawString(dpy,dir->two_op_win,NormalGC,2, font->ascent+1,
	      two_op_command[dir->two_op_cmd],
	      strlen(two_op_command[dir->two_op_cmd]));
}
