.\" This file Copyright 1992 Robert J. Nation 
.\" (nation@rocket.sanders.lockheed.com)
.\" It may be distributed under the GNU Public License, version 2, or
.\" any higher version.  See section COPYING of the GNU Public license
.\" for conditions under which this file may be redistributed.
.TH XConsole 1 "Feb 1 1993" "Linux" "Linux Programmer's Manual"
.SH NAME
L_XConsole \- display kernel messages in an X window
.SH SYNOPSIS
L_XConsole [-log filename] [X options]
.SH DESCRIPTION
.B "L_XConsole " 
(Linux X-Windows Console) displays kernel messages in an X window. Also 
displays the current date and  
time, and the system name and kernel release number
.PP
.SH "COMMAND\-LINE OPTIONS"
.B L_XConsole 
accepts all the standard X-Windows command line options. In 
addition, a log file can be specified which will contain a record of the 
kernel messages. Only some of the standard X windows command line options
are listed here.
.TP 0.5i
.B "-log filename "
If specified, the all kernel messages will be appended to this file. If
the file does not exist, it will be created.
.TP 0.5i
.B "-font fontname "
Specifies a font to use for messages in the window. The kernel release number
is listed in the title bar, and its font is controlled by the window manager.
.TP 0.5i
.B "-fg color"
Specifies the foreground (text) color
.TP 0.5i
.B "-bg color"
Specifies the background (text) color
.TP 0.5i
.B "-geometry WxH+X+Y"
Specifies the initial window geometry, as WidthxHeight+X0+Y0.
You may specify just WxH or +X+Y.
.TP 0.5i
.B "-display name"
Tells what screen to send the window to.

.SH UPDATING
This proc-based XConsole window works by reading the files in the proc 
filesystem, mounted on /proc.  

.SH NOTES
.PP
Only the super-user can run this program, unless the program binary is
suid root.
.PP
More than one instance of 
.B L_XConsole 
can exist at any time, in which case they
will fight over the messages, and no single window will get all messages.
.SH BUGS
Does not prevent more than one invocation of 
.B L_XConsole 
>from starting.
.PP
Console window can be sent to any screen, not just the console screen.

.SH AUTHOR
.B L_XConsole
was written by Robert Nation (nation@rocket.sanders.lockheed.com).
