/*
 *  Color Routines.. randomizing, rotating, and init'ing colormap
 */

#include <X11/X.h>
#include <X11/Xlib.h>
#include <math.h>
#include <stdio.h>
#include "trippy.h"

#ifndef sgn
#define sgn(x) ( ((x)<0)?(-1):(1))
#endif

extern Visual *vis;
XColor *color_info; /* [NCOLORS]; */
short m_color=1;

unsigned long
StrColor(char *string,unsigned long def)
{  
/* Lookup a color by its name */
  XColor screen_def_return, exact_def_return;
  if (string==(char*)0 || XAllocNamedColor(display, colmap, string,
					   &exact_def_return,
					   &screen_def_return)==False)
    return def;
  else 
    return screen_def_return.pixel;
}
     
void
randomize_color()
{
/* pick a random color from the list, set it to a random value */
  XColor color;
  int i=rndm((long)numcolors-1);
  
  if(i==0) i=1;  /* overwriting the Background color is a Bad Thing */
  
  color.pixel = color_info[i].pixel;
  colors[i][0]=color.red = rndm(65535L);
  colors[i][1]=color.green = rndm(65535L);
  colors[i][2]=color.blue = rndm(65535L);
  color.flags = DoRed|DoGreen|DoBlue;
  XStoreColor(display, colmap, &color);
  color_info[i].red = color.red;
  color_info[i].green = color.green;
  color_info[i].blue = color.blue;
}

void
randomize_colors()
{
  int i;
  /* randomize the whole Colormap */
  if(!options.mono)
    {
      XColor *color;
      color=(XColor *)malloc(numcolors*sizeof(XColor));
      for (i=1; i<numcolors; i++) 
	{
	  color[i].pixel = color_info[i].pixel; 
	  colors[i][0]=color[i].red = rndm(65535L);
	  colors[i][1]=color[i].green = rndm(65535L);
	  colors[i][2]=color[i].blue = rndm(65535L);
	  color[i].flags = DoRed|DoGreen|DoBlue;
	  XStoreColor(display, colmap, &color[i]); 
	  color_info[i].red = color[i].red;
	  color_info[i].green = color[i].green;
	  color_info[i].blue = color[i].blue;
	}
      free (color);
      /*  XStoreColors(display,colmap, &color[1], numcolors-1); */
    }
  else
    {
      XColor *color;
      color=(XColor *)malloc(numcolors*sizeof(XColor));
      for (i=1; i<numcolors; i++) 
	{
	  color[i].pixel = color_info[i].pixel; 
	  colors[i][0]=color[i].red = 
	  colors[i][1]=color[i].green =
	  colors[i][2]=color[i].blue = rndm(65535L);
	  color[i].flags = DoRed|DoGreen|DoBlue;
	  XStoreColor(display, colmap, &color[i]); 
	  color_info[i].red = color[i].red;
	  color_info[i].green = color[i].green;
	  color_info[i].blue = color[i].blue;
	}
      free (color);
      /*  XStoreColors(display,colmap, &color[1], numcolors-1); */
    }      
}

void
rotate_colors()
{ 
/*  Rotate the colormaps
 *  Palette 0 is the standard RYGCyBM
 *  Palette 1 is 3 band of Red, Green and Blue
 *  Palette 2 starts out Greyscale
 *  in rotating palettes 1 and 2, the 3 primary colors (RGB) are independent
 *  of each other...
 */

  XColor temp_color;
  register int i;
  static int plusme1=0,plusme2=0,plusme3=0;
  static int add1=1,add2=1,add3=1;
  int a,b,c;
  temp_color.pixel = color_info[1].pixel;
  for (i=1; i<numcolors; i++)
    {
      if(options.palette!=0&&options.palette!=3)
	{
	  a= (i+plusme1)%numcolors;
	  b= (i+plusme2)%numcolors;
	  c= (i+plusme3)%numcolors;
	  if(a<0) a=numcolors-1+a;
	  if(b<0) b=numcolors-1+b;
	  if(c<0) c=numcolors-1+c;
	  color_info[i].red=colors[a][0];
	  color_info[i].green=colors[b][1];
	  color_info[i].blue=colors[c][2];
	}
      else
	color_info[i].pixel = color_info[i+1].pixel;
      color_info[i].flags = DoRed|DoGreen|DoBlue;
/*      XStoreColor(display,colmap,&color_info[i]); */
    }
  if(options.palette==0||options.palette==3)
    {
      color_info[numcolors-1].pixel = temp_color.pixel;
      color_info[numcolors-1].flags = DoRed|DoGreen|DoBlue;
    }
  else
    {
      if(!rndm(5000l))
	add1*= -1;
      plusme1+=add1;
      if(!rndm(5000l))
	add2*= -1;
      plusme2+=add2;
      if(!rndm(5000l))
	add3*= -1;
      plusme3+=add3;
    }
  XStoreColors(display,colmap,&color_info[1],numcolors-1); 
}

/*
void
EndofTunnel()
{
  XColor temp_color;
  int i,j;
  
  for(j=1; j<numcolors-1; j++)
    {
      for (i=2; i<numcolors-1; i++)
	{
	  color_info[i].pixel = color_info[i+1].pixel;
	  color_info[i].flags = DoRed|DoGreen|DoBlue;
	  XStoreColor(display,colmap,&color_info[i]);
	}
      color_info[1].pixel=color_info[i+1].pixel;
      color_info[1].flags=0;
      XStoreColor(display,colmap,&color_info[1]); 
      color_info[numcolors-1].pixel = temp_color.pixel;
      color_info[numcolors-1].flags = DoRed|DoGreen|DoBlue;
      XStoreColor(display,colmap,&color_info[numcolors-1]);
    }
}
*/
/*
int
myfunc (int in, int max)
{
  int tmp;

  tmp = (sin (in * M_PI / (max*3/4) ) * max);
  fprintf(stderr, "tmp=%d\n",tmp);

  if (tmp<0)
    return 0;
  else
    return tmp;
}
*/

void
get_them_colors()
{
/* Allocate the Colormap and Initialize them */
  unsigned long *pixels; /*[NCOLORS];  */
  unsigned long *plane_masks;
  int i;
  int mask_for;
  XGCValues values;  
  if ((HC =(int *)calloc(options.tryfor,sizeof(int))) == NULL) return ;
  pixels=(unsigned long *)malloc(sizeof(unsigned long)*options.tryfor);
/*
  if(options.perfect)
    mask_for=1;
  else
*/
    mask_for=0;

  if (!vis->class)
    {
      color_info=(XColor *)malloc(sizeof(XColor)*2);
      numcolors=2;
      color_info[0].pixel = WhitePixel(display,screen);
      color_info[1].pixel = BlackPixel(display,screen);
      for(i=0;i<numcolors;i++)
	{
	  int win;
	  values.foreground = color_info[i].pixel;
	  values.background = options.bgcolor;
/*	  for(win=0;win<options.windows;win++) */
	  color_gcs[i]=XCreateGC(display,window[0],
				 GCForeground|GCBackground,&values);
	}
    }
  else if (options.dynamic_colors) 
    {
      for (numcolors=options.tryfor; numcolors>=2; numcolors-=6) 
	{
	  if (XAllocColorCells(display,colmap, True , plane_masks,
			       mask_for, pixels,
			       (unsigned int)numcolors) != 0) 
	    {
	      color_info=(XColor *)malloc(sizeof(XColor)*numcolors);
	      for (i=0;i<numcolors;i++)
		color_info[i].pixel=pixels[i];
	      randomize_colors();
	      break;
	    }
	}
      
      fprintf(stderr,"Alloc'ing %d colors \n",numcolors);
      if (numcolors < 2) 
	fatalerror("Cannot allocate R/W color cells","");

      color_info[0].pixel=options.bgcolor;
      for(i=0;i<numcolors;i++)
	{
	  int win=0;
	  values.foreground = color_info[i].pixel;
	  values.background = options.bgcolor;
	  for(win=0;win<options.windows;win++)
	    color_gcs[i] = XCreateGC(display,window[win],
				     GCForeground|GCBackground,&values);
	}
    }
  else if(!options.mono)
    {
      XColor screen_in_out;
      int poisson=options.tryfor;
      int done=0;
      screen_in_out.flags=DoRed|DoGreen|DoBlue;
      
      while(!done)
	{
	  if (XAllocColorCells(display, colmap, True, plane_masks,
			       mask_for, pixels, poisson) != 0) 
	    {

/* this is Prof's Color setting code.. Good, but it skips Yellow and Cyan */
/* 		  color_info=(XColor *)malloc(sizeof(XColor)*poisson); */
/*  		  for(i=0;i<=poisson;i++)                              */
/* 		    {                                                  */
/* 		      int num;                                         */
/* 		      num = myfunc (i, poisson);                       */
/* 		      colors[i][0] = (256 * num / poisson) << 8;       */
/* 		      if (m_color)                                     */
/* 			{                                              */
/* 			  num = i + poisson/3;                         */
/* 			  if (num>poisson)                             */
/* 			    num -= poisson;                            */
/* 			  num = myfunc(num, poisson);                  */
/* 			}                                              */
/* 		      colors[i][1] = (256 * num / poisson) << 8;       */
/* 		      if (m_color)                                     */
/* 			{                                              */
/* 			  num = i + 2*poisson/3;                       */
/* 			  if (num>poisson)                             */
/* 			    num -= poisson;                            */
/* 			  num = myfunc(num,poisson);                   */
/* 			}                                              */
/* 		      colors[i][2] = (256 * num / poisson) << 8;       */
		  
 		  float fact = (float)65535/(poisson/6); 
 		  color_info=(XColor *)malloc(sizeof(XColor)*poisson);
 		  for(numcolors=0;numcolors<=(poisson/6);numcolors++) 
		    { 
		      switch (options.palette)
			{
			case 3:
			  {
			    int stepX,stepY;
			    int sqrtColors,sqrColors,done,x,y;
			    fprintf(stderr,"poisson=%d\n",poisson);
/*			    sqrtColors=sqrt(sqrt(poisson)); /* squareroot */
			    sqrColors= sqrt(poisson); /*(sqrtColors*sqrtColors);*/
			    done=0;
			    x=sqrColors;
			    y=(sqrColors-1)*sqrColors;
 			    
			    do
			      {
				colors[x][0]=rndm(65535);
				colors[x][1]=rndm(65535);
				colors[x][2]=rndm(65535);
				
				colors[y][0]=rndm(65535);
				colors[y][1]=rndm(65535);
				colors[y][2]=rndm(65535);

/* make sure at least one of the colors is fairly strong */
				if(( (colors[x][0]<32767) &&
				     (colors[x][1]<32767) &&
				     (colors[x][2]<32767) ) ||
				   ( (colors[y][0]<32767) &&
				     (colors[y][1]<32767) &&
				     (colors[y][2]<32767) ) ||
				   ( colors[x][0]+colors[y][0]>65535) ||
				   ( colors[x][1]+colors[y][1]>65535) ||
				   (colors[x][2]+colors[y][2]>65535) )
				  done=0;
				else done=1;
			      } while (!done);

/*			    fprintf(stderr,"colors[%d]= (%d,%d,%d)\n",x,
			            colors[x][0],colors[x][1],colors[x][2]);
			    fprintf(stderr,"colors[%d]= (%d,%d,%d)\n",y,
			            colors[y][0],colors[y][1],colors[y][2]);
*/			    
			    colors[0][0]=
			      colors[0][1]=
				colors[0][2]=0;
			    
			    for(stepX=1;stepX<x;stepX++)
			      {
				colors[stepX][0]= colors[x][0]*((float)stepX/x);
				colors[stepX][1]= colors[x][1]*((float)stepX/x);
				colors[stepX][2]= colors[x][2]*((float)stepX/x);
/*				fprintf(stderr,"Color[%d]= (%d,%d,%d)\n",stepX,colors[stepX][0],colors[stepX][1],colors[stepX][2]); */
			      }
			    
			    for(stepY=1;stepY<x;stepY++)
			      {
				colors[stepY*x][0]= colors[y][0]*((float)stepY/x);
				colors[stepY*x][1]= colors[y][1]*((float)stepY/x);
				colors[stepY*x][2]= colors[y][2]*((float)stepY/x);
	/*			fprintf(stderr,"Color[%d]= (%d,%d,%d)\n",stepY*x,colors[stepY*x][0],colors[stepY*x][1],colors[stepY*x][2]); */
 }
			    
			    for(stepX=1;stepX<x;stepX++)
			      for(stepY=1;stepY<x;stepY++)
				{
				  colors[stepX+(stepY*x)][0]= 
				    colors[stepX][0] + colors[stepY*x][0];
				  colors[stepX+(stepY*x)][1]= 
				    colors[stepX][1] + colors[stepY*x][1];
				  colors[stepX+(stepY*x)][2]= 
				    colors[stepX][2] + colors[stepY*x][2];
				/*  fprintf(stderr,"Color[%d]= (%d,%d,%d)\n",
					  stepX+(stepY*x),
					  colors[stepX+(stepY*x)][0],
					  colors[stepX+(stepY*x)][1],
					  colors[stepX+(stepY*x)][2]); */
				}

			    numcolors=8000; /* break out of the loop */
			    poisson=sqrColors*sqrColors;
			 /*   fprintf(stderr,"sqrColors= %d\t sqrtColors=%d\n", sqrColors,sqrtColors); */
			    break;
			  }				
			case 2:
			  {
			    for(;numcolors<=poisson>>1;numcolors++)
			      {
				colors[numcolors][0]=
				  colors[poisson-numcolors][0]=
				colors[numcolors][1]=
				  colors[poisson-numcolors][1]=
				colors[numcolors][2]=
				  colors[poisson-numcolors][2]=
			     (unsigned long)numcolors*2*(float)(65535/poisson);
			      }
			    break;
			  }
			case 1:
			{
			  colors[numcolors][0]= 
			    colors[numcolors+(poisson*2/6)][1]= 
			      colors[numcolors+(poisson*4/6)][2]= 
				(unsigned long)(fact*numcolors); 
			  colors[numcolors+(poisson/6)][0]= 
			    colors[numcolors+(poisson*3/6)][1]= 
			      colors[numcolors+(poisson*5/6)][2]= 
				(unsigned long)(65535-(fact*numcolors)); 
			  break;
			}			  
		      case 0:
		      default:
			{
			  colors[numcolors][1]= 
			    colors[numcolors+(poisson*2/6)][2]= 
			      colors[numcolors+(poisson*4/6)][0]= 
				(unsigned long)(fact*numcolors); 
			  colors[numcolors+(poisson/6)][0]= 
			    colors[numcolors+(poisson*3/6)][1]= 
			      colors[numcolors+(poisson*5/6)][2]= 
				(unsigned long)(65535-(fact*numcolors)); 
			  colors[numcolors][0]= 
			    colors[numcolors+(poisson/6)][1]= 
			      colors[numcolors+(poisson*2/6)][1]= 
				colors[numcolors+(poisson*3/6)][2]= 
				  colors[numcolors+(poisson*4/6)][2]= 
				    colors[numcolors+(poisson*5/6)][0]=
				      (unsigned long)65535; 
			  break;
			 }
		      }
		      if(options.palette!=2&&options.palette!=3)
			{
			  /* and then we zero out anything else */
			  colors[numcolors][2]= 
			    colors[numcolors+(poisson/6)][2]= 
			      colors[numcolors+(poisson*2/6)][0]= 
				colors[numcolors+(poisson*3/6)][0]=
				  colors[numcolors+(poisson*4/6)][1]= 
				    colors[numcolors+(poisson*5/6)][1]=
				      (unsigned long)0; 
			}
		    }
		  done=1;
		}
	      else
		poisson-=6;
	    }
	  fprintf(stderr,"Alloc'ing %d colors \n",poisson);

	  for(numcolors=0;numcolors<poisson;numcolors++)
	    {
	      int win;
	      screen_in_out.red   = colors[numcolors][0];
	      screen_in_out.green = colors[numcolors][1];
	      screen_in_out.blue  = colors[numcolors][2];
	      screen_in_out.pixel = pixels[numcolors];

	      if (XStoreColor(display, colmap, &screen_in_out)==False) 
		{
		  /* oh well... guess this doesn't mean anything now */
	/*	  fatalerror("Cannot allocate colors",""); */
		}

/*
	      fprintf(stderr, "Got to #%d in here:",numcolors);
 		fprintf(stderr, "red:%ld\tgreen:%ld\tblue:%ld\n",
 	        colors[numcolors][0],colors[numcolors][1],
 		        colors[numcolors][2]);
 		fflush(stderr);
 */

	      color_info[numcolors].pixel = screen_in_out.pixel;
	      color_info[numcolors].red = screen_in_out.red;
	      color_info[numcolors].green = screen_in_out.green;
	      color_info[numcolors].blue = screen_in_out.blue;
	      color_info[0].pixel=options.bgcolor;
	      values.foreground = color_info[numcolors].pixel;
	      values.background = options.bgcolor;
	      for(win=0;win<options.windows;win++)
		color_gcs[numcolors] = XCreateGC(display,window[win],
						 GCForeground|GCBackground,
						 &values);
	    }
	}
  else                                           /*greyscale */
    { 
      XColor screen_in_out;
      int poisson=options.tryfor;
      int done=0;
      screen_in_out.flags=DoRed|DoGreen|DoBlue;

      while(!done)
	{
	  if (XAllocColorCells(display,colmap, True, plane_masks, mask_for,
			       pixels, poisson) != 0) 
	    {
	      color_info=(XColor *)malloc(sizeof(XColor)*poisson);
	      for (numcolors=0; numcolors<poisson; numcolors++) 
		{
		  int win;
		  colors[numcolors][0]=
		    colors[numcolors][1]=
		      colors[numcolors][2]=
			(unsigned long)(numcolors*(float)(65535/poisson));
		
		  screen_in_out.flags = DoRed | DoGreen | DoBlue;
		  screen_in_out.red = colors[numcolors][0];
		  screen_in_out.green = colors[numcolors][1];
		  screen_in_out.blue = colors[numcolors][2];
		  screen_in_out.pixel = pixels[numcolors];	  
		  if (XStoreColor(display, colmap,&screen_in_out)==False) 
		    {
/*
		      if (numcolors < 2) 
			fatalerror("Cannot allocate colors","");
		      break;
*/
		    }
		  color_info[numcolors].pixel = screen_in_out.pixel;
		  color_info[numcolors].red = screen_in_out.red;
		  color_info[numcolors].green = screen_in_out.green;
		  color_info[numcolors].blue = screen_in_out.blue;
		  values.foreground = color_info[numcolors].pixel;
		  values.background = options.bgcolor;
		  for(win=0;win<options.windows;win++)
		    color_gcs[numcolors] = XCreateGC(display,window[win],
						     GCForeground|GCBackground,
						     &values);
		}
	      done=1;
	    }
	  else
	    poisson-=6;
	}
      fprintf(stderr,"Alloc'ing %d colors \n",poisson);
    }
  free (pixels);
}
