/***********************************************************************\
*	Copyright (C) 1992 by Michael K. Johnson, johnsonm@stolaf.edu	*
*									*
*	This file is placed under the conditions of the GNU public	*
*	license, version 2, or any later version.  See file COPYING	*
*	for information on distribution conditions.			*
\***********************************************************************/

#include<unistd.h>
#include<stdio.h>
#include<fcntl.h>
#include<linux/lp.h>
#include<linux/fs.h>
#include<sys/ioctl.h>
#include<sys/stat.h>
#include<sys/types.h>
#include<malloc.h>
#include<string.h>

struct command {
  long op;
  long val;
  struct command *next;
};




void print_usage(char *progname) {
/*  printf("%s: invalid usage.\n", progname); */
  printf("Usage: %s <device> [ -i IRQ | -t TIME | -c CHARS | -w WAIT | -a [on|off]]\n",
	 progname);
  exit ( 1 );
}





void *mylloc(long size) {
  void *ptr;
  if(!(ptr = (void*)malloc(size))) {
    perror( "malloc error" );
    exit(2);
  }
  return ptr;
}



long get_val(char *val) {
  long ret;
  sscanf(val, "%d", &ret);
  /* I should error-check the previous line, but I haven't found my K&R... */
  return ret;
}


long get_onoff(char *val) {
  if (!strncasecmp("on", val, 2))
    return 1;
  return 0;
}



int main (int argc, char ** argv) {
  int c, fd;
  char *progname;
  struct stat statbuf;
  struct command *cmds, *cmdst;


  progname = argv[0];
  if (argc < 4) print_usage(progname);
  if ((argc % 2) != 0) print_usage(progname);

  /* should stat here, not fstat later */
  fd = open(argv[1], O_WRONLY, 0);
  if (fd < 0) { perror(argv[1]); return -1; }
  /* ugly error message */

  fstat(fd, &statbuf);

  if((!S_ISCHR(statbuf.st_mode)) || (MAJOR(statbuf.st_rdev) != 6 )
     || (MINOR(statbuf.st_rdev) > 3)) {
    printf("%s: %s not an lp device.\n", argv[0], argv[1]);
    print_usage(progname);
  }

  cmdst = cmds = mylloc(sizeof(struct command)); cmds->next = 0;

  while ((c = getopt(argc, argv, "t:c:w:a:i:")) != EOF) {
    switch (c) {
    case 'i':
      cmds->op = LPSETIRQ;
      cmds->val = get_val(optarg);
      cmds->next = mylloc(sizeof(struct command));
      cmds = cmds->next; cmds->next = 0;
      break;
    case 't':
      cmds->op = LPTIME;
      cmds->val = get_val(optarg);
      cmds->next = mylloc(sizeof(struct command));
      cmds = cmds->next; cmds->next = 0;
      break;
    case 'c':
      cmds->op = LPCHAR;
      cmds->val = get_val(optarg);
      cmds->next = mylloc(sizeof(struct command));
      cmds = cmds->next; cmds->next = 0;
      break;
    case 'w':
      cmds->op = LPWAIT;
      cmds->val = get_val(optarg);
      cmds->next = mylloc(sizeof(struct command));
      cmds = cmds->next; cmds->next = 0;
      break;
    case 'a':
      cmds->op = LPABORT;
      cmds->val = get_onoff(optarg);
      cmds->next = mylloc(sizeof(struct command));
      cmds = cmds->next; cmds->next = 0;
      break;
    default: print_usage(progname);
    }
  }

  cmds = cmdst;
  while (cmds->next) {
    if (ioctl(fd, cmds->op, cmds->val) < 0)
      perror("tunelp: ioctl");
    cmdst = cmds;
    cmds = cmds->next;
    free(cmdst);
  }

  close(fd);

  return 0;
}
