# 1 "boot/head.S"










.text
.globl _idt,_gdt,
.globl _swapper_pg_dir,_pg0
.globl _empty_bad_page
.globl _empty_bad_page_table
.globl _empty_zero_page
.globl _floppy_track_buffer

# 1 "/usr/src/linux/include/linux/tasks.h" 1









# 19 "boot/head.S" 2

# 1 "/usr/src/linux/include/linux/segment.h" 1










# 20 "boot/head.S" 2


# 1 "/usr/src/linux/include/linux/fd.h" 1




























































# 224 "/usr/src/linux/include/linux/fd.h"














# 22 "boot/head.S" 2











startup_32:
	cld
	movl $(0x18),%eax
	mov %ax,%ds
	mov %ax,%es
	mov %ax,%fs
	mov %ax,%gs
	lss _stack_start,%esp



	xorl %eax,%eax
	movl $__edata,%edi
	movl $__end,%ecx
	subl %edi,%ecx
	cld
	rep
	stosb




	call setup_idt
	xorl %eax,%eax
1:	incl %eax		# check that A20 really IS enabled
	movl %eax,0x000000	# loop forever if it isn't
	cmpl %eax,0x100000
	je 1b





	pushl $0
	popfl





	movl $0x90000,%esi
	movl $_empty_zero_page,%edi
	movl $512,%ecx
	cld
	rep
	movsl
	xorl %eax,%eax
	movl $512,%ecx
	rep
	stosl
	cmpw $(0xA33F),0x90020
	jne 1f
	movl $_empty_zero_page+2048,%edi
	movzwl 0x90022,%esi
	addl $(0x90000),%esi
	movl $2048,%ecx
	rep
	movsb
1:






	movl %esp,%edi		# save stack pointer
	andl $0xfffffffc,%esp	# align stack to avoid AC fault
	movl $3,_x86
	pushfl			# push EFLAGS
	popl %eax		# get EFLAGS
	movl %eax,%ecx		# save original EFLAGS
	xorl $0x40000,%eax	# flip AC bit in EFLAGS
	pushl %eax		# copy to EFLAGS
	popfl			# set EFLAGS
	pushfl			# get new EFLAGS
	popl %eax		# put it in eax
	xorl %ecx,%eax		# change in flags
	andl $0x40000,%eax	# check if AC bit changed
	je is386
	movl $4,_x86
	movl %ecx,%eax
	xorl $0x200000,%eax	# check ID flag
	pushl %eax
	popfl			# if we are on a straight 486DX, SX, or
	pushfl			# 487SX we can't change it
	popl %eax
	xorl %ecx,%eax
	andl $0x200000,%eax
	je is486
isnew:	pushl %ecx		# restore original EFLAGS
	popfl
	movl $1, %eax		# Use the CPUID instruction to 
	.byte 0x0f, 0xa2	# check the processor type
	andl $0xf00, %eax	# Set _x86 with the family
	shrl $8, %eax		# returned.	
	movl %eax, _x86
	movl %edi,%esp		# restore esp
	movl %cr0,%eax		# 486+
	andl $0x80000011,%eax	# Save PG,PE,ET
	orl $0x50022,%eax	# set AM, WP, NE and MP
	jmp 2f
is486:	pushl %ecx		# restore original EFLAGS
	popfl
	movl %edi,%esp		# restore esp
	movl %cr0,%eax		# 486
	andl $0x80000011,%eax	# Save PG,PE,ET
	orl $0x50022,%eax	# set AM, WP, NE and MP
	jmp 2f
is386:	pushl %ecx		# restore original EFLAGS
	popfl
	movl %edi,%esp		# restore esp
	movl %cr0,%eax		# 386
	andl $0x80000011,%eax	# Save PG,PE,ET
	orl $2,%eax		# set MP
2:	movl %eax,%cr0
	call check_x87
	call setup_paging
	lgdt gdt_descr
	lidt idt_descr
	ljmp $(0x10),$1f
1:	movl $(0x18),%eax	# reload all the segment registers
	mov %ax,%ds		# after changing gdt.
	mov %ax,%es
	mov %ax,%fs
	mov %ax,%gs
	lss _stack_start,%esp
	xorl %eax,%eax
	lldt %ax
	pushl %eax		# These are the parameters to main :-)
	pushl %eax
	pushl %eax
	cld			# gcc2 wants the direction flag cleared at all times
	call _start_kernel
L6:
	jmp L6			# main should never return here, but
				# just in case, we know what happens.




check_x87:
	movl $0,_hard_math
	clts
	fninit
	fstsw %ax
	cmpb $0,%al
	je 1f
	movl %cr0,%eax		
	xorl $4,%eax		
	movl %eax,%cr0
	ret
.align 2
1:	movl $1,_hard_math
	.byte 0xDB,0xE4		
	ret











setup_idt:
	lea ignore_int,%edx
	movl $(0x10 << 16),%eax
	movw %dx,%ax		
	movw $0x8E00,%dx	

	lea _idt,%edi
	mov $256,%ecx
rp_sidt:
	movl %eax,(%edi)
	movl %edx,4(%edi)
	addl $8,%edi
	dec %ecx
	jne rp_sidt
	ret













.align 2
setup_paging:
	movl $1024*2,%ecx		
	xorl %eax,%eax
	movl $_swapper_pg_dir,%edi	
	cld;rep;stosl

	movl $_pg0+7,_swapper_pg_dir		

	movl $_pg0+7,_swapper_pg_dir+3072	
	movl $_pg0+4092,%edi
	movl $0x03ff007,%eax		
	std
1:	stosl			
	subl $0x1000,%eax
	jge 1b
	cld
	movl $_swapper_pg_dir,%eax
	movl %eax,%cr3			
	movl %cr0,%eax
	orl $0x80000000,%eax
	movl %eax,%cr0		
	ret			











.org 0x1000
_swapper_pg_dir:




.org 0x2000
_pg0:

.org 0x3000
_empty_bad_page:

.org 0x4000
_empty_bad_page_table:

.org 0x5000
_empty_zero_page:

.org 0x6000






_floppy_track_buffer:
	.fill 512*2*24 ,1,0


int_msg:
	.asciz "Unknown interrupt\n"
.align 2
ignore_int:
	cld
	pushl %eax
	pushl %ecx
	pushl %edx
	push %ds
	push %es
	push %fs
	movl $(0x18),%eax
	mov %ax,%ds
	mov %ax,%es
	mov %ax,%fs
	pushl $int_msg
	call _printk
	popl %eax
	pop %fs
	pop %es
	pop %ds
	popl %edx
	popl %ecx
	popl %eax
	iret




.align 4
.word 0
idt_descr:
	.word 256*8-1		# idt contains 256 entries
	.long 0xc0000000+_idt

.align 4
_idt:
	.fill 256,8,0		# idt is uninitialized

.align 4
.word 0
gdt_descr:
	.word (8+2*128)*8-1
	.long 0xc0000000+_gdt





.align 4
_gdt:
	.quad 0x0000000000000000	
	.quad 0x0000000000000000	
	.quad 0xc0c39a000000ffff	
	.quad 0xc0c392000000ffff	
	.quad 0x00cbfa000000ffff	
	.quad 0x00cbf2000000ffff	
	.quad 0x0000000000000000	
	.quad 0x0000000000000000	
	.fill 2*128,8,0		
