/*
 * X11 utility functions
 *
 * <stdio.h> must be included before this
 */

#ifndef X11_UTIL_HEADER
#define X11_UTIL_HEADER

#include "../copyright.h"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>

#ifdef __STDC__
#define DECLARE(func, rtn, args)	extern rtn func args
#else
#define DECLARE(func, rtn, args)	extern rtn func ()
#endif

#define UX11_END	0L

DECLARE(ux11_open_display, Display *, (int argc, char *argv[]));

DECLARE(ux11_fill_wattr, unsigned long, (XSetWindowAttributes *wattr, ...));

DECLARE(ux11_fill_gcvals, unsigned long, (XGCValues *, ...));

DECLARE(ux11_fill_hints, unsigned long, (XWMHints *, ...));

DECLARE(ux11_fill_xa, int, (Arg *arg_list, int *size, ...));

DECLARE(ux11_find_visual, int, (Display *disp, int (*good_func)(),
				XVisualInfo *rtn_vis));

DECLARE(ux11_color_vis, int, (XVisualInfo *vis));

#define UX11_DEFAULT	1
#define UX11_ALTERNATE	2

DECLARE(ux11_std_vismap, int, (Display *disp, Visual **rtn_vis,
			       Colormap *rtn_cmap, int *rtn_scrn,
			       int *rtn_depth));

DECLARE(ux11_get_value, char *, (int argc, char *argv[], char *value, char *def));

DECLARE(ux11_find_font, int, (Display *disp, int scrn_num, char *pat,
			      long (*good_func)(), void *data,
			      XFontStruct **rtn_font, char **rtn_name));

DECLARE(ux11_size_font, int, (Display *disp, int scrn_num, long size,
			      XFontStruct **rtn_font, char **rtn_name));

DECLARE(ux11_error, char *, (XErrorEvent *evt));

#endif
