/*
 * db_management.c: some maintenance routines to deal with database access.
 * 
 * Copyright (C), 1994, Graeme W. Wilford. (Wilf.)
 *
 * You may distribute under the terms of the GNU General Public
 * License as specified in the file COPYING that comes with the man
 * distribution.
 *
 * Thu Apr 28 21:31:44 BST 1994  Wilf. (G.Wilford@ee.surrey.ac.uk)
 */

#define MAN_MAIN 	/* to not define config_file */
#define MANPATH_MAIN	/* to not define *std_sections[] */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "config.h"
#include "mydbm.h"
#include "dbver.h"

extern int debug; 
extern char *database;

int try_section (char *path, char *section, char *name, int glob);

void remove_db_entry(char *fullpath, datum key)
{
	datum content;
	MYDBM_FILE dbf;

	if( (dbf = MYDBM_RWOPEN(database)) != NULL){

		/* re-get the manpage list from the db */
				
		dbver_rd(dbf);

		content = MYDBM_FETCH(dbf, key);
	
		if (debug)
			fprintf(stderr, "remove_db_entry: %s from %s\n", fullpath, content.dptr);
	
		if (strchr(content.dptr, ':') == NULL)
					
			/* manpage is lonely, just bin it. */
						
			MYDBM_DEL(dbf, key);
		else {
			/* manpage has friends, find it and bin it. */
			
			char *start, *end;
			
			start = strstr(content.dptr, fullpath);
			end = strchr(start, ':');
	
			if (end == NULL)
				*(--start) = '\0';
			else 
				strcpy(start, ++end);
	
			content.dsize = strlen(content.dptr) + 1;
			MYDBM_REPLACE(dbf, key, content);
		}
		MYDBM_FREE(content.dptr);
		MYDBM_CLOSE(dbf);
	}
	else {
		if (debug)
			fprintf(stderr,
			  "remove_db_entry: couldn't open db: %s in RW mode\n", database);
	}
}

int try_db_manpage(char *fullpath, datum key, char *manp, char *section)
{
	/* 
	 * we can happily trash contents of fullpath.
	 * except we can't due to remove_db_entry, which needs the 
	 * fullpath
	 */
	
	char *sec;
	char *bigpath;

	bigpath = strdup(fullpath);

	/*
	 * isolate the section number
	 *
	 * there is a discussion as to whether we should use 
	 * strchr() or strrchr() next. See mandb.c:123
	 *
	 * MUST use strrchr due to man pages like ld.so.8
	 */
	
	sec = strrchr (bigpath, '.') + 1;

	/*
	 * see if the found man page has the correct section number
	 * (if section has been set)
	 */
	 
	if (section == NULL || strcmp (sec, section) == 0){
		int exists;

		*strrchr (bigpath, '/') = '\0';
		*strrchr (bigpath, '/') = '\0';

		/* 
		 * now check to see if the path found in the db is also
		 * in the manpath, (filters out -M . etc)
		 */

		if (strstr(manp, bigpath) != NULL){

			/* 
			 * see if the db manpage actually exists in reality.
			 * if so, show it.
			 */

			exists = try_section (bigpath, sec, key.dptr, 0);

			if (!exists)
			
				/*
				 * We should remove the page from the db
				 */

				remove_db_entry(fullpath, key);
				
			return exists;
		}	
		else 
			if (debug)
				fprintf(stderr, "but... db path: %s is not in man_searchpath\n", bigpath);
	}
	free(bigpath);
	return 0;
}
