#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <ctype.h>
#include <sys/param.h>
#include <fcntl.h>
#include <sys/time.h>
#include <unistd.h>
#include <signal.h>
#ifdef ISC /* Saul */
#include <sys/bsdtypes.h> /* Saul */
#endif /* Saul */

#if defined ___AIX || defined _AIX || defined __QNX__ || defined ___AIXV3 || defined AIXV3 || defined _SEQUENT_
#include <sys/select.h>
#endif

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>


#include "filemgr.h"
#include "debug.h"
#include "../../version.h"
#include "../../fvwm/module.h"

struct dir_win *garbage_dir;
char this_is_garbage = 0;
int fd[2];

extern Display *dpy;
extern int x_fd,screen, ScreenWidth,ScreenHeight;
extern int d_depth;
extern Window Root;

char *MyName;
char *iconPath, *pixmapPath, *ForeColor="Black", *BackColor="White";
char *font_string = "fixed";
int w=-1,h=-1,x=-100000,y= -100000,max_w=0,min_w=100,max_h=0,min_h=100;
struct mapping *mapping_root = NULL;
int do_all = 0;
int fd_width;
extern XFontStruct *font;
extern int font_height;
extern Pixel hilite_pix, back_pix, shadow_pix, fore_pix;

int main(int argc, char **argv)
{
  int i,did_one = 0, j;
  struct dir_win *dir_list_root = NULL,*newdir;
  char *temp,*s;

  /* Dead pipe == Fvwm died */
  signal (SIGPIPE, DeadPipe);  

#ifndef NO_SYSCONF
  fd_width = sysconf(_SC_OPEN_MAX);
#else
  fd_width = getdtablesize();
#endif

  temp = argv[0];

  s=strrchr(argv[0], '/');
  if (s != NULL)
    temp = s + 1;

  MyName = safemalloc(strlen(temp)+1,"MyName");
  strcpy(MyName, temp);

  if(argc < 4)
    {
      fprintf(stderr,"%s version %s should be executed from fvwm only!\n",
	      MyName,VERSION);
      exit(1);
    }
  fd[0] = atoi(argv[1]);
  fd[1] = atoi(argv[2]);
  mapping_root = read_config_file();
  initialize_X();

  ParseOptions(argv[3]);
  LoadXThings();

  for(i=6;i<argc;i++)
    {
      if(argv[i][0] == '-')
	{
	  for(j=0;j<strlen(argv[i]);j++)
	    {
	      if(argv[i][j] == 'a')
		do_all = 1;
	    }
	}
      else
	{
	  newdir = create_dir_list(&dir_list_root,argv[i],do_all,mapping_root);
	  did_one = 1;
	}
    }

  if(!did_one)
    {
      newdir = create_dir_list(&dir_list_root,"~",do_all,mapping_root);
    }

  this_is_garbage = 1;
  garbage_dir = create_dir_list(&dir_list_root,"~/.wastebasket",
				do_all,mapping_root);
  this_is_garbage = 0;
  XSync(dpy,0);
  update_garbage_dir(garbage_dir, do_all);

  Loop(&dir_list_root);
  return 0;
}


/*****************************************************************************
 * 
 * This routine is responsible for reading and parsing the config file
 *
 ****************************************************************************/
void ParseOptions(char *filename)
{
  FILE *fd = (FILE *)0;
  char *tline,*orig_tline,*tmp,*tmp2;
  int Clength;
  int g_x, g_y, flags;
  unsigned width,height;
  char line[256];

  fd = fopen(filename,"r");
  if(fd == (FILE *)0)
    {
      fprintf(stderr,"%s: can't open config file %s",MyName,filename);
      free_mapping(mapping_root);
      exit(1);
    }

  tline = fgets(line,255,fd);
  orig_tline = tline;
  Clength = strlen(MyName);
  while(tline != (char *)0)
    {
      while(isspace(*tline))tline++;

      if(strlen(&tline[0])>1)
	{
	  if(strncasecmp(tline,Cs3("*",MyName,"Geometry"),Clength+9)==0)
	    {
	      tmp = &tline[Clength+9];
	      while(((isspace(*tmp))&&(*tmp != '\n'))&&(*tmp != 0))
		tmp++;
	      tmp[strlen(tmp)] = 0;
	      CopyString(&tmp2,tmp);
	      flags = XParseGeometry(tmp2,&g_x,&g_y,&width,&height);
	      safefree(tmp2,"Why","why");
	      if (flags & WidthValue) 
		w = width;
	      if (flags & HeightValue) 
		h = height;
	      if (flags & XValue) 
		x = g_x;
	      if (flags & YValue) 
		y = g_y;
	    }
	  if(strncasecmp(tline,Cs3("*",MyName,"MaxGeometry"),Clength+12)==0)
	    {
	      tmp = &tline[Clength+12];
	      while(((isspace(*tmp))&&(*tmp != '\n'))&&(*tmp != 0))
		tmp++;
	      tmp[strlen(tmp)] = 0;
	      CopyString(&tmp2,tmp);
	      flags = XParseGeometry(tmp2,&g_x,&g_y,&width,&height);
	      safefree(tmp2,"Why","why");
	      if (flags & WidthValue) 
		max_w = width;
	      if (flags & HeightValue) 
		max_h = height;
	    }
	  if(strncasecmp(tline,Cs3("*",MyName,"MinGeometry"),Clength+12)==0)
	    {
	      tmp = &tline[Clength+12];
	      while(((isspace(*tmp))&&(*tmp != '\n'))&&(*tmp != 0))
		tmp++;
	      tmp[strlen(tmp)] = 0;
	      
	      CopyString(&tmp2,tmp);
	      flags = XParseGeometry(tmp2,&g_x,&g_y,&width,&height);
	      safefree(tmp2,"Why","why");
	      if (flags & WidthValue) 
		min_w = width;
	      if (flags & HeightValue) 
		min_h = height;
	    }
	  else if(strncasecmp(tline,Cs3("*",MyName,"Font"),Clength+5)==0)
	    CopyString(&font_string,&tline[Clength+5]);
	  else if(strncasecmp(tline,Cs3("*",MyName,"Fore"),Clength+5)==0)
	    CopyString(&ForeColor,&tline[Clength+5]);
	  else if(strncasecmp(tline,Cs3("*",MyName, "Back"),Clength+5)==0)
	    CopyString(&BackColor,&tline[Clength+5]);
	  else if(strncasecmp(tline,"IconPath",8)==0)
	    CopyString(&iconPath,&tline[8]);
	  else if(strncasecmp(tline,"PixmapPath",10)==0)
	    CopyString(&pixmapPath,&tline[10]);
	}
      tline = fgets(line,255,fd);
      orig_tline = tline;
    }
  
  return;
}


/************************************************************************
 *
 * Concatentates 3 strings
 *
 ***********************************************************************/
char CatS[256];

char *Cs3(char *a, char *b, char *c)
{
  if (strlen(a)+strlen(b)+strlen(c) > 255)
    {
      return NULL;
    }
  strcpy(CatS, a);
  strcat(CatS, b);
  strcat(CatS, c);
  return CatS;
}



/***************************************************************************
 *
 * A simple routine to copy a string, stripping spaces and mallocing
 * space for the new string 
 ***************************************************************************/
void CopyString(char **dest, char *source)
{
  int len;
  char *start;

  while(((isspace(*source))&&(*source != '\n'))&&(*source != 0))
    {
      source++;
    }
  len = 0;
  start = source;
  while((*source != '\n')&&(*source != 0))
    {
      len++;
      source++;
    }

  source--;
  while((isspace(*source))&&(*source != 0)&&(len >0))
    {
      len--;
      source--;
    }
  *dest = safemalloc(len+1,"CopyString");
  strncpy(*dest,start,len);
  (*dest)[len]=0;	  
}


#ifdef NEEDS_STRNCASECMP
int strncasecmp(char *s1,char *s2,int n)
{
  register int c1,c2;
  
  for (;;)
    {
      if (!n) return(0);
      c1 = *s1,c2 = *s2;
      if (!c1 || !c2) return(c1 - c2);
      if (isupper(c1)) c1 = 'a' - 1 + (c1 & 31);
      if (isupper(c2)) c2 = 'a' - 1 + (c2 & 31);
      if (c1 != c2) return(c1 - c2);
      n--,s1++,s2++;
    }
}
#endif



#ifdef NEEDS_STRCASECMP
int strcasecmp(char *s1,char *s2)
{
  register int c1,c2;
  
  for (;;)
    {
      c1 = *s1,c2 = *s2;
      if (!c1 || !c2) return(c1 - c2);
      if (isupper(c1)) c1 = 'a' - 1 + (c1 & 31);
      if (isupper(c2)) c2 = 'a' - 1 + (c2 & 31);
      if (c1 != c2) return(c1 - c2);
      s1++,s2++;
    }
}
#endif



struct filelist *selection = NULL;
/***********************************************************************
 *
 *  Procedure:
 *	Loop - wait for data to process
 *
 ***********************************************************************/
#define KBUFSIZE 100
struct dir_win *seldir = NULL;

void Loop(struct dir_win **dir_root)
{
  XEvent Event;
  struct filelist *list, *list2;
  int select_x = 0, select_y = 0,w,h;
  Time ButtonPressTime = 0;
  struct dir_win *dir, *dir2;
  char kbuf[KBUFSIZE];
  static XComposeStatus compose = {NULL,0};
  KeySym keysym;
  int count;
  char newname[MAXPATHLEN];
  extern Display *dpy;
  extern Atom wm_del_win;
  char *temp_string;

  newname[0] = 0;

  while(1)
    {
#ifdef DEBUG_MALLOC
      check_all_mem("Loop","a");
#endif
      if(My_XNextEvent(dpy,&Event,dir_root))
	{
	  FindWindows(Event.xany.window, *dir_root, &dir, &list);
	  switch(Event.type)
	    {
	    case Expose:
	      if(Event.xexpose.count == 0)
		{
		  if((list)&&(list->LabelWin == Event.xexpose.window))
		    {
		      if((list == selection)&&(newname[0] != 0))
			RedrawIcon(list,newname);
		      else
			RedrawIcon(list,NULL);
		    }
		  if((dir)&&(dir->top_win == Event.xexpose.window))
		    RedrawWindow(dir,newname);
		  if((dir)&&((dir->open_win == Event.xexpose.window)||
			     (dir->size_win == Event.xexpose.window)))
		    RelabelFile(dir,newname);
		  if((dir)&&((dir->one_op_win == Event.xexpose.window)||
			     (dir->two_op_win == Event.xexpose.window)))
		    RelabelCommands(dir);
		}
	      break;
	      
	    case ConfigureNotify:
	      if((dir)&&(dir->top_win == Event.xany.window))
		{
		  if((dir->w != Event.xconfigure.width)||
		     (dir->h != Event.xconfigure.height-
		      (2*font_height+3)))
		     {
		       w = Event.xconfigure.width;
		       h = Event.xconfigure.height-(2*font_height+3);
		       ReconfigureWin(dir,1,w,h);
		     }
		}
	      break;
	      
	    case ButtonPress:
	      FindWindows(Event.xbutton.subwindow, *dir_root, &dir, &list);
	      FindWindows(Event.xbutton.window, *dir_root, &dir2, &list2);
	      if((list)&&((Event.xbutton.subwindow == list->HoldingWin)||
		 (Event.xbutton.subwindow == list->LabelWin)))
		{
		  if((Event.xbutton.time-ButtonPressTime < DOUBLE_CLICK_TIME)&&
		     (dir)&&(list)&&(list== selection))
		    {
		      OpenFile(dir,list,dir_root, mapping_root,NULL);
		      if(selection)
			{
			  selection->selected = 0;
			  RedrawIcon(selection,NULL);
			  selection = NULL;
			  RelabelFile(seldir,NULL);
			  seldir = NULL;
			}
		      newname[0] = 0;
		      ButtonPressTime = 0;
		    }
		  else
		    {
		      ButtonPressTime = Event.xbutton.time;
		      
		      if(selection)
			{
			  selection->selected = 0;
			  newname[0] = 0;
			  RedrawIcon(selection,NULL);
			  selection = NULL;
			  RelabelFile(seldir,newname);
			  seldir = NULL;
			}
		      list->selected = 1;
		      selection = list;
		      seldir = dir;
		      XRaiseWindow(dpy,list->HoldingWin);
		      XRaiseWindow(dpy,list->LabelWin);
		      select_x = Event.xbutton.x - selection->actual_x;
		      select_y = Event.xbutton.y - selection->actual_y;
		      RedrawIcon(list,NULL);
		      RelabelFile(seldir,newname);
		    }
		}
	      if((dir2)&&(Event.xbutton.window == dir2->one_op_win))
		{
		  dir2->one_op_cmd++;
		  if(dir2->one_op_cmd >= NUM_ONE_OP_CMDS)
		    dir2->one_op_cmd = 0;
		  RelabelCommands(dir2);
		}
	      if((dir2)&&(Event.xbutton.window == dir2->two_op_win))
		{
		  dir2->two_op_cmd++;
		  if(dir2->two_op_cmd >= NUM_TWO_OP_CMDS)
		    dir2->two_op_cmd = 0;
		  RelabelCommands(dir2);
		}
	      
	      if((selection)&&(!list))
		{
		  selection->selected = 0;
		  newname[0] = 0;
		  RedrawIcon(selection,NULL);
		  selection = NULL;
		  RelabelFile(seldir,newname);
		  seldir = NULL;
		}
	      break;
	      
	    case ButtonRelease:
	      break;
	      
	    case MotionNotify:
	      while(XCheckTypedEvent(dpy,MotionNotify,&Event));
	      MoveIcon(seldir,selection,&Event,select_x,select_y);
	      break;
	    case MapNotify:
	      if((dir)&&(list)&&(list->HoldingWin == Event.xany.window)&&
		 (list->CheckedOut))
		{
		  XIconifyWindow(dpy,list->HoldingWin,screen);
		  OpenFile(dir,list,dir_root,mapping_root,NULL);
		  if(selection)
		    {
		      selection->selected = 0;
		      RedrawIcon(selection,NULL);
		      selection = NULL;
		      RelabelFile(seldir,NULL);
		      seldir = NULL;
		    }
		  newname[0] = 0;

		}
	      break;
	      
	    case ClientMessage:
	      if ((Event.xclient.format==32) && 
		  (Event.xclient.data.l[0]==wm_del_win))
		{
		  if((dir==seldir)||(list==selection))
		    {
		      selection = NULL;
		      seldir = NULL;
		    }
		  if(dir == garbage_dir)
		    {
		      temp_string = 
			safemalloc(strlen(garbage_dir->dir_name)+10,"Waste");
		      strcpy(temp_string,"rm -rf ");
		      strcat(temp_string,garbage_dir->dir_name);
		      strcat(temp_string,"/*");
		      system(temp_string);
		      refresh_dir_list(dir,dir_root,do_all,mapping_root);
		      safefree(temp_string,"Waste","Empty");
		    }
		  else if((dir)&&(!list))
		    delete_filelist(dir,dir_root,mapping_root);
		  else if((dir)&&(list)&&(dir->open  != -1))
		    {
		      list->CheckedOut = 0;
		      XUnmapWindow(dpy,list->HoldingWin);
		      XUnmapWindow(dpy,list->LabelWin);
		      strcpy(list->filename,"");
		      refresh_dir_list(dir,dir_root,do_all,mapping_root);
		    }
		  else if((dir)&&(list)&&(dir->open  == -1))		  
		    {
		      list->CheckedOut = 0;
		      delete_filelist(dir,dir_root,mapping_root);
		    }
		    
		  if(selection == NULL)
		    newname[0] = 0;
		  if((*dir_root) == NULL)
		    {
		      free_mapping(mapping_root);
		      terminate("Delete");
		    }
		}
	      break;
	    case KeyPress:
	      count = XLookupString(&Event.xkey,
				    kbuf,KBUFSIZE-1,&keysym,&compose);
	      kbuf[count] = (unsigned char)0;
	      if((selection != NULL)&&(seldir == dir))
		{
		  /* We're renaming a file */
		  if((kbuf[0] == '\n')||(kbuf[0] == '\r'))
		    {
		      RenameFile(selection,seldir,newname,
				 dir_root, do_all, mapping_root);
		      if(selection)
			{
			  selection->selected = 0;
			  RedrawIcon(selection,NULL);
			  selection = NULL;
			  RelabelFile(seldir,NULL);
			  seldir = NULL;
			}
		      newname[0] = 0;
		    }
		  else if((kbuf[0] == 127)||(kbuf[0] == '\b'))
		    {
		      if(strlen(newname) > 0)
			newname[strlen(newname)-1] = 0;
		      XClearWindow(dpy,selection->LabelWin);
		      RedrawIcon(selection,newname);
		    }
		  else
		    {
		      strcat(newname,kbuf);
		      XClearWindow(dpy,selection->LabelWin);
		      RedrawIcon(selection,newname);
		    }
		  RelabelFile(seldir,newname);
		}
	      else
		{
		  selection = NULL;
		  RelabelFile(seldir,NULL);
		  /* We're typing in a file name to open*/
		  if((kbuf[0] == '\n')||(kbuf[0] == '\r'))
		    {
		      OpenFile(dir,NULL,dir_root,mapping_root,newname);
		      if(selection)
			{
			  selection->selected = 0;
			  RedrawIcon(selection,NULL);
			  selection = NULL;
			  RelabelFile(seldir,NULL);
			  seldir = NULL;
			}
		      newname[0] = 0;
		    }
		  else if((kbuf[0] == 127)||(kbuf[0] == '\b'))
		    {
		      if(strlen(newname) > 0)
			newname[strlen(newname)-1] = 0;
		    }
		  else
		    {
		      strcat(newname,kbuf);
		    }

		  RelabelFile(dir,newname);
		}
	      break;
	    case MappingNotify:
	      XRefreshKeyboardMapping(&Event.xmapping);
	      break;
	    default:
	      break;
	    }
	}
    }
  return;
}


void FindWindows(Window win,struct dir_win *dir_root,
		 struct dir_win **dir, struct filelist **list)
{
  struct dir_win *thisdir;
  struct filelist *thisfile;

  thisdir = dir_root;

  while(thisdir != NULL)
    {
      if((win == thisdir->main_win)||(win == thisdir->top_win)||
	 (thisdir->one_op_win == win)||(thisdir->two_op_win == win)||
	 (thisdir->open_win == win)||(thisdir->size_win == win))

	{
	  *dir = thisdir;
	  *list = NULL;
	  return;
	}

      thisfile = thisdir->file_root;
      while(thisfile != NULL)
	{
	  if((thisfile->IconWin == win)||
	     (thisfile->HoldingWin == win)||
	     (thisfile->LabelWin == win))
	    {
	      *dir = thisdir;
	      *list = thisfile;
	      return;	      
	    }
	  thisfile = thisfile->nextfile;
	}
      thisdir = thisdir->next;
    }
  *dir = NULL;
  *list = NULL;
}



/***************************************************************************
 *
 * Waits for next X event, or for an auto-raise timeout.
 *
 ****************************************************************************/
int My_XNextEvent(Display *dpy, XEvent *event, struct dir_win **dir_root)
{
  static int miss_counter = 0;
  fd_set in_fdset;
  unsigned long header[3];
  int body_length,count,count2 = 0;
  unsigned long *body;
  int total,retval;
  char *cbody;
  struct itimerval value;
  extern int x_fd;
  struct dir_win *dir;
  long t_now;

  if(XPending(dpy))
    {
      XNextEvent(dpy,event);
      return 1;
    }
  
  t_now = time(0);
  dir = *dir_root;
  while(dir != NULL)
    {
      if(t_now - dir->last_update_time > 10)
	{
	  refresh_dir_list(dir,dir_root,do_all,mapping_root);
	}
      dir = dir->next;
    }  

  FD_ZERO(&in_fdset);
  FD_SET(x_fd,&in_fdset);
  FD_SET(fd[1],&in_fdset);

  value.it_value.tv_usec = 0;
  value.it_value.tv_sec = 5;  
  retval = select(fd_width,&in_fdset, 0, 0, &value.it_value);
  
  if(FD_ISSET(x_fd, &in_fdset))
    {
      if(XPending(dpy))
	{
	  XNextEvent(dpy,event);
	  miss_counter = 0;
	  return 1;
	}
      else
	miss_counter++;
      if(miss_counter > 100)
	DeadPipe(0);
    }
  
  if(FD_ISSET(fd[1], &in_fdset))
    {
      if((count = read(fd[1],header,3*sizeof(unsigned long))) >0)
	{
	  if(header[0] == START_FLAG)
	    {
	      body_length = header[2]-3;
	      body = (unsigned long *)
		safemalloc(body_length * sizeof(unsigned long),"body");
	      cbody = (char *)body;
	      total = 0;
	      while(total < body_length*sizeof(unsigned long))
		{
		  if((count2=
		      read(fd[1],&cbody[total],
			   body_length*sizeof(unsigned long)-total)) >0)
		    {
		      total += count2;
		    }
		  else if(count2 < 0)
		    {
		      DeadPipe(0);
		    }
		}
	      process_message(header[1],body, dir_root);
	      free(body);
	    }
	}
      if(count <= 0)
	{
	  DeadPipe(1);
	}
    }
  return 0;
}



void process_message(unsigned long type,unsigned long *body, 
		     struct dir_win **dir_root)
{
  int x,y,icon_w,icon_h,targetstack;
  Window w;
  struct dir_win *dir, *targetdir,*newdir;
  struct filelist *list;
  static int laststack = 0;

  w = (Window)body[0];
  FindWindows(w, *dir_root, &dir, &list);      
  if(dir == NULL)
    return;

  if((type == M_CONFIGURE_WINDOW)&&(list == NULL))
    {
      dir->frame_x = body[3];
      dir->frame_y = body[4];
      dir->frame_width = body[5];
      dir->frame_height = body[6];
    }
  else if((type == M_RAISE_WINDOW)&&(list == NULL))
    {
      dir->stacking_order = laststack++;
    }
  else if((type == M_LOWER_WINDOW)&&(list == NULL))
    {
      dir->stacking_order = 0;
    }
  else if ((type == M_ICONIFY)&&(list == NULL))
    {
      dir->open = 0;
    }
  else if ((type == M_DEICONIFY)&&(list == NULL))
    {
      dir->open = 1;
      refresh_dir_list(dir,dir_root,do_all,mapping_root);
    }
  else if(type == M_ICON_LOCATION)
    {
      FindWindows(w, *dir_root, &dir, &list);
      x = body[3];
      y = body[4];
      icon_w = body[5];
      icon_h = body[6];
      if(list == NULL)
	{
	  dir->icon_x = x;
	  dir->icon_y = y;
	  dir->icon_width = icon_w;
	  dir->icon_height = icon_h;
	}
      else 
	{
	  list->icon_loc_count++;
	  if(list->icon_loc_count == 1)
	    return;
	  targetstack = -1;
	  targetdir = NULL;
	  /* move a file-icon from one dir to another? */
	  /* see if the new location is inside an directory */
	  newdir = *dir_root;
	  while(newdir != NULL)
	    {
	      if((x > newdir->frame_x+5)&&
		 (y > newdir->frame_y+5)&&
		 (x+icon_w < newdir->frame_x + newdir->frame_width-5)&&
		 (y+icon_h < newdir->frame_y + newdir->frame_height-5)&&
		 (newdir->stacking_order > targetstack)&&
		 (newdir->open==1))
		{
		  targetdir = newdir;
		  targetstack = newdir->stacking_order;
		}
	      if(!newdir->open)
		{
		  fprintf(stderr,"Comparing file at %d+%dx%dx%d to dir icon at %d+%dx%dx%d\n",x,y,icon_w,icon_h, newdir->icon_x,newdir->icon_y,newdir->icon_width,newdir->icon_height);
		}
	      if((x +icon_w/2 > newdir->icon_x)&&
		 (y +icon_h/2> newdir->icon_y)&&
		 (x +icon_w/2 < newdir->icon_x + newdir->icon_width)&&
		 (y +icon_h/2< newdir->icon_y + newdir->icon_height)&&
		 (newdir->stacking_order > targetstack)&&
		 (newdir->open == 0))
		{
		  fprintf(stderr,"Matched\n");
		  targetdir = newdir;
		  targetstack = newdir->stacking_order;
		}
	      newdir = newdir->next;
	    }
	  if(targetdir != NULL)
	    {
	      fprintf(stderr,"Moving\n");
	      MoveToNewDir(dir,list,targetdir, dir_root, mapping_root);
	      if(selection)
		{
		  selection->selected = 0;
		  RedrawIcon(selection,NULL);
		  selection = NULL;
		  RelabelFile(seldir,NULL);
		  seldir = NULL;
		}
	    }
	}
    }
}

/***********************************************************************
 *
 *  Procedure:
 *	SIGPIPE handler - SIGPIPE means fvwm is dying
 *
 ***********************************************************************/
void DeadPipe(int nonsense)
{
  free_mapping(mapping_root);
  terminate("Delete");
}


/***********************************************************************
 *
 *  Procedure:
 *	SendInfo - send a command back to fvwm 
 *
 ***********************************************************************/
void SendInfo(int *fd,char *message,unsigned long window)
{
  int w;
  
  if(message != NULL)
    {
      write(fd[0],&window, sizeof(unsigned long));
      
      w=strlen(message);
      write(fd[0],&w,sizeof(int));
      write(fd[0],message,w);
      
      /* keep going */
      w=1;
      write(fd[0],&w,sizeof(int));
    }
}
