static const char *pcmciad_c_rcsid = "$Id: pcmciad.c,v 1.4 1993/09/08 02:51:51 bjaspan Exp $";

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/wait.h>

#define DEBUG

#include "pcmcia.h"
#include "pcmciad.h"

#ifdef USER_DRV
int mem_fd;
extern struct pcic_sock pcic_socks[];
#define PHYS_ADDR 0xd0000
#endif /* USER_DRV */

#ifdef DEBUG
#define syslog fprintf
#define LOG_NOTICE stderr
#define LOG_INFO stderr
#define SYSLOG(args) syslog args
#else
#define SYSLOG(args)
#endif

void enable_card(struct pcic_sock *sock, struct dev_action *act,
		 struct pcmcia_cfentry *cfent);

main()
{
     extern struct dev_action *dev_actions[];
     struct pcmcia_cfentry *cfent;
     struct sock_state sockstates[MAX_SOCKS];
     int i, j, ret;
     struct dev_action *act;

#ifdef USER_DRV
     /* 0x80 is for REALLY_SLOW_IO */
     if (ioperm(0x3e0, 4, 1) || ioperm(0x80, 1, 1)) {
	  perror("ioperm");
	  exit(1);
     }

     mem_fd = open("/dev/mem", O_RDWR, 0);
     if (mem_fd < 0) {
	  perror("opening /dev/mem");
	  exit(1);
     }

     pcmcia_init(PHYS_ADDR, 0);
#endif /* USER_DRV */

     parse_configfile(stdin);

#ifndef USER_DRV
     error ioctl /* get pcic_socks from kernel */
#endif

     for (i = 0; i < MAX_SOCKS; i++) {
	  if (pcic_socks[i].cardp && sockstates[i].state == EMPTY) {
	       sockstates[i].state = FULL;
	       sockstates[i].devtype = 
		    lookup_devtype(pcic_socks[i].manufacturer,
				   pcic_socks[i].prod_name,
				   pcic_socks[i].addl_info1,
				   pcic_socks[i].addl_info2);
	       
	       SYSLOG((LOG_INFO, "%s card installed in slot %d\n",
		       unparse_devtype(sockstates[i].devtype), i));

	       /* locate the first free action for devtype */
	       for (act = dev_actions[sockstates[i].devtype]; act;
		    act = act->next)
		    if (!act->busy)
			 break;

	       if (act == NULL) {
		    syslog(LOG_NOTICE, "all defined %s cards "
			   "already installed; ignoring\n",
			   unparse_devtype(sockstates[i].devtype));
		    continue;
	       }

	       /* look for a matching config table entry */
	       for (j = 0; j < MAX_CONFIGS; j++) {
		    cfent = &pcic_socks[i].configs[j];
		    if (act_matches(act, cfent))
			 break;
		    else if (pcic_socks[i].config_midx == cfent->idx) {
			 j = MAX_CONFIGS;
			 break; /* no "continue 2;" */
		    }
	       }
	       if (j == MAX_CONFIGS) {
		    syslog(LOG_NOTICE, "%s action not found on card; "
			   "ignoring\n",
			   unparse_devtype(sockstates[i].devtype));
		    /* XXX try <devtype>'s next action? */
		    continue;
	       }
	       
	       enable_card(&pcic_socks[i], act, cfent);
	       syslog(LOG_INFO, "initializing with \"%s\"\n", act->init);
	       ret = system(act->init);
	       if (WIFEXITED(ret)) {
		    if (WEXITSTATUS(ret)) {
			 syslog(LOG_NOTICE, "init action exited with "
				"status %d\n", WEXITSTATUS(ret));
		    }
	       } else
		    syslog(LOG_NOTICE, "init action exited on signal %d\n",
			   WTERMSIG(ret));
	  }
     }

     return 0;
}

int lookup_devtype(char *manufacturer, char *prod_name,
		   char *addl_info1, char *addl_info2)
{
     extern struct prod_map *prod_map;
     struct prod_map *pmap;
     int i;

     for (pmap = prod_map; pmap; pmap = pmap->next) {
	  if (pmap->devtype == UNKNOWN)
	       break;
	  /* XXX this should do a regexp compare */
	  else if ((!strcmp(pmap->manufacturer, ".*") || 
		    !strcmp(pmap->manufacturer, manufacturer)) &&
		   (!strcmp(pmap->prod_name, ".*") ||
		    !strcmp(pmap->prod_name, prod_name)) &&
		   (!strcmp(pmap->addl_info1, ".*") ||
		    !strcmp(pmap->addl_info1, addl_info1)) &&
		   (!strcmp(pmap->addl_info2, ".*") ||
		    !strcmp(pmap->addl_info2, addl_info2)))
	       return pmap->devtype;
     }
     return UNKNOWN;
}

int act_matches(struct dev_action *act, struct pcmcia_cfentry *cfent)
{
     static struct pcmcia_cfentry *def_cfent = NULL;

     if (cfent->defp)
	  def_cfent = cfent;

     if (cfent->irqp) {
	  if (! irq_matches(act, cfent))
	       return 0;
     } else if (def_cfent && def_cfent->irqp) {
	  if (! irq_matches(act, def_cfent))
	       return 0;
     } else if (act->cfent.irqp)
	  return 0;
     else
	  return 1;

#define INTS_MATCH(p, val, len) \
     if (cfent->p) { \
	  if (! ints_match(act->cfent.val, act->cfent.len, \
			   cfent->val, cfent->len)) \
	       return 0; \
     } else if (def_cfent && def_cfent->p) { \
	  if (! ints_match(act->cfent.val, act->cfent.len, \
			   def_cfent->val, def_cfent->len)) \
	       return 0; \
     } else if (act->cfent.p) \
	  return 0; \
     else \
	  return 1;

     INTS_MATCH(iop, io_addrs, ios);
     INTS_MATCH(iop, io_lens, ios);
     INTS_MATCH(memp, mem_caddrs, mems);
     INTS_MATCH(memp, mem_haddrs, mems);
     INTS_MATCH(memp, mem_lens, mems);
#undef INTS_MATCH

     return 1;
}

int irq_matches(struct dev_action *act, struct pcmcia_cfentry *cfent)
{
     return cfent->irq ? cfent->irq == act->cfent.irq :
	  (cfent->irq_mask & (1 << act->cfent.irq));
}

int ints_match(int *addrs1, int num1, int *addrs2, int num2)
{
     if (num1 == num2 && !memcmp(addrs1, addrs2, sizeof(int)*num1))
	  return 1;
     return 0;
}

void enable_card(struct pcic_sock *sock, struct dev_action *act,
		 struct pcmcia_cfentry *cfent)
{
     static char io_addrs[] = {
	  PCIC_IO0_STL, PCIC_IO1_STL,
     };
     static char mem_addrs[] = {
	  PCIC_SM0_STL, PCIC_SM1_STL, PCIC_SM2_STL, PCIC_SM3_STL,
	  PCIC_SM4_STL,
     };
     static char io_enables[] = {
	  PCIC_IO0_EN, PCIC_IO1_EN,
     };
     static char mem_enables[] = {
	  PCIC_SM0_EN, PCIC_SM1_EN, PCIC_SM2_EN, PCIC_SM3_EN,
	  PCIC_SM4_EN,
     };
     u_long start, stop, ofs;
     int i;

     /* Set card type = I/O, select IRQ */
     /* XXX CARDRESET is a dumb name */
     pcic_writereg(sock, PCIC_INT_GEN, PCIC_CARDRESET | PCIC_IOCARD |
		   act->cfent.irq); 

#if 0
     /* the pcic does this automatically */
     pcic_writereg(sock, PCIC_IOCTL, cfent->io_16 ? PCIC_IO1_CS16 |
		   PCIC_IO0_CS16 : 0);
#endif

#ifdef USER_DRV
     /* write cfentry idx to card's reg0 */
     pcmcia_select_cfentry(sock, cfent->idx);
#else
     error ioctl;
#endif

     /* disable all windows */
     pcic_writereg(sock, PCIC_ADDRWINE, 0);

     for (i = 0; i < act->cfent.ios; i++) {
	  pcic_writereg16(sock, io_addrs[i] + PCIC_START,
			  act->cfent.io_addrs[i]);
	  pcic_writereg16(sock, io_addrs[i] + PCIC_END,
			  act->cfent.io_addrs[i] +
			  act->cfent.io_lens[i] - 1);
	  pcic_writereg(sock, PCIC_ADDRWINE,
			pcic_readreg(sock, PCIC_ADDRWINE) |
			io_enables[i]);
     }

     for (i = 0; i < act->cfent.mems; i++) {
	  start = act->cfent.mem_haddrs[i] >> 12;
	  stop = ((act->cfent.mem_haddrs[i] + act->cfent.mem_lens[i] - 1)
		  & 0xfffff000) >> 12;

	  /* XXX magic constants */
	  ofs = (((act->cfent.mem_caddrs[i] >> 12) - start) & 0x3fff)
	       | 0x4000;

#ifdef notdef
	  printf("card start = %#x, stop = %#x, ofs = %#x\n", start,
		 stop, ofs);
#endif

	  pcic_writereg16(sock, mem_addrs[i] + PCIC_START, start);
	  pcic_writereg16(sock, mem_addrs[i] + PCIC_END, stop);
	  pcic_writereg16(sock, mem_addrs[i] + PCIC_MOFF, ofs);
	  pcic_writereg(sock, PCIC_ADDRWINE,
			pcic_readreg(sock, PCIC_ADDRWINE) |
			mem_enables[i]);
     }
}
