#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>

#ifndef USER_DRV
#define REALLY_SLOW_IO
#define extern
#include <asm/io.h>
#undef extern
#endif

#include "pcmcia.h"

#ifdef USER_DRV
int mem_fd;
extern struct pcic_sock pcic_socks[];
#define PHYS_ADDR 0xd0000 /* 0x10b000 */
#endif /* USER_DRV */

struct reg_t {
     char addr;
     char *name;
     int width;
};

struct reg_t pcic_regs[] = {
     PCIC_ID_REV, "Identification and Revision", 1,
     PCIC_STATUS, "Interface Status", 1,
     PCIC_POWER, "Power and RESETDRV control", 1,
     PCIC_INT_GEN, "Interrupt and General Control", 1,
     PCIC_STAT_CHG, "Card Status Change", 1,
     PCIC_STAT_INT, "Card Status Change Interrupt Config", 1,
     PCIC_ADDRWINE, "Address Window Enable", 1,
     PCIC_IOCTL, "I/O Control", 1,
     PCIC_IO0_STL, "I/O Address 0 Start", 2,
     PCIC_IO0_SPL, "I/O Address 0 Stop", 2,
     PCIC_IO1_STL, "I/O Address 1 Start", 2,
     PCIC_IO1_SPL, "I/O Address 1 Stop", 2,
     PCIC_SM0_STL, "System Memory Address 0 Mapping Start", 2,
     PCIC_SM0_SPL, "System Memory Address 0 Mapping Stop", 2,
     PCIC_CM0_L, "Card Memory Offset Address 0", 2,
     PCIC_SM1_STL, "System Memory Address 1 Mapping Start", 2,
     PCIC_SM1_SPL, "System Memory Address 1 Mapping Stop", 2,
     PCIC_CM1_L, "Card Memory Offset Address 1", 2,
     PCIC_SM2_STL, "System Memory Address 2 Mapping Start", 2,
     PCIC_SM2_SPL, "System Memory Address 2 Mapping Stop", 2,
     PCIC_CM2_L, "Card Memory Offset Address 2", 2,
     PCIC_SM3_STL, "System Memory Address 3 Mapping Start", 2,
     PCIC_SM3_SPL, "System Memory Address 3 Mapping Stop", 2,
     PCIC_CM3_L, "Card Memory Offset Address 3", 2,
     PCIC_SM4_STL, "System Memory Address 4 Mapping Start", 2,
     PCIC_SM4_SPL, "System Memory Address 4 Mapping Stop", 2,
     PCIC_CM4_L, "Card Memory Offset Address 4", 2,
     0, NULL, 0,
};     

struct reg_t pcmcia_regs[] = {
     PCMCIA_COR, "Configuration Option Register", 1,
     PCMCIA_CCSR, "Card Configuration Status Register", 1,
     PCMCIA_PIR, "Pin Replacement Register", 1,
     PCMCIA_SCR, "Socket and Copy Register", 1,
     0, NULL, 0,
};

main(int argc, char **argv)
{
     int i, j, idx;
     struct dev_action *act;
     struct pcmcia_cfentry *cfent;

#ifdef USER_DRV
     /* 0x80 is for REALLY_SLOW_IO */
     if (ioperm(0x3e0, 4, 1) || ioperm(0x80, 1, 1)) {
	  perror("ioperm");
	  exit(1);
     }

     mem_fd = open("/dev/mem", O_RDWR, 0);
     if (mem_fd < 0) {
	  perror("opening /dev/mem");
	  exit(1);
     }

     if (argc == 2)
	  pcmcia_init(PHYS_ADDR, 0);
     else
	  pcic_init(pcic_socks);
#endif /* USER_DRV */

     for (i = 0; i < MAX_SOCKS; i++) {
	  if (!pcic_socks[i].valid || !pcic_socks[i].cardp)
	       continue;
	  printf("* PCIC socket %#x + %#x\n", pcic_socks[i].base,
		 pcic_socks[i].ofs);
	  dump_pcic_regs(&pcic_socks[i]);
	  printf("\n");
	  if (argc == 2)
	       dump_pcmcia_regs(&pcic_socks[i]);
     }

     return 0;
}

dump_pcic_regs(struct pcic_sock *sock)
{
     int i;

     for (i = 0; pcic_regs[i].name; i++) {
	  printf("%s: ", pcic_regs[i].name);
	  switch (pcic_regs[i].width) {
	  case 1:
	       printf("%#x", pcic_readreg(sock, pcic_regs[i].addr));
	       break;
	  case 2:
	       printf("%#x", pcic_readreg16(sock, pcic_regs[i].addr));
	       break;
	  }
	  printf("\n");
     }
}

dump_pcmcia_regs(struct pcic_sock *sock)
{
     int i;
     u_char v;

     pcic_map_attr(sock, PHYS_ADDR, 1);
     for (i = 0; pcmcia_regs[i].name; i++) {
	  printf("%s: ", pcmcia_regs[i].name);

	  if (lseek(mem_fd, PHYS_ADDR + sock->base_addr +
		    pcmcia_regs[i].addr, SEEK_SET) < 0) {
	       perror("seeking to tuple memory");
	       exit(1);
	  }
	  if (read(mem_fd, &v, 1) < 0) {
	       perror("reading tuple memory");
	       exit(1);
	  }
	  
	  printf("%#x\n", v);
     }

     pcic_map_attr(sock, PHYS_ADDR, 0);
}
