/*
 * devname.c
 *
 * modified by Michael K. Johnson, johnsonm@stolaf.edu for YAPPS
 * 
 * I am changing this significantly to provide a more reasonable
 * output.  This will make this w incompatible with utmp's ut_id
 * Tough.  utmp is a mess anyway.  Until utmp gets saner, w may
 * grow its own devname stuff, if I have time.
 */

#include <sys/stat.h>
#include <string.h>
#include <stdio.h>

/*
 * ttynames:
 * 	vc00:  v01 v02...	virtual consoles
 *	tty00: s00 s01...	serial lines
 *	ttyp0: p00 p01...	pty's
 */

static char *ttgrp = "    StuvPQRWpqrs";
static char *ttsub = "0123456789abcdef";

void dev_to_tty(char *tty, int dev)
{

  if (dev == -1)
    strcpy(tty," ? ");
  else if (dev == 0)
    strcpy(tty,"con");
  else if (dev < 64) {
    sprintf(tty, "v%02d", dev);
  } else {
    if (dev < 128) {
      sprintf(tty, "s%02d", (dev - 64));
    } else {
      tty[0] = 'p';
      tty[1] = ttgrp[(dev >> 4) & 017];
      tty[2] = ttsub[dev & 017];
    }
  }
  tty[3] = 0;
}

int tty_to_dev(char *tty)
{
    char *p, *q;

    if (*tty == '\0') {		/* empty string: controlling tty */
	struct stat buf;
	if (fstat(0, &buf) != -1)
	    return(buf.st_rdev & 0xff);
	else
	    return -1;
    }
    if (tty[1] == '\0' && *tty >= '0' && *tty <= '9')
	return(*tty - '0');
    if (strcmp(tty, "co") == 0)
	return 0;
    if ((p = strchr(ttgrp, *tty)) != NULL &&
	(q = strchr(ttsub, tty[1])) != NULL)
	return(((p - ttgrp) << 4) | (q - ttsub));
    else
	return -1;
}
