
/* init.c: init program for MCC interim boot disk.
 * Copyright (C) 1994  A. V. Le Blanc

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 * This special init program is used on the MCC interim root disk.
 * By avoiding the need for a shell, it saves over 100k on the disk.
 * On the other hand, this means the potential choices must be carefully
 * thought through and useful options made available.
 */

#include <unistd.h>
#include <stdio.h>
#include <sys/mount.h>

void main(void)
{
  char buffer[11];
  int retcode;
  char *argv[] = {"/mnt/etc/init", NULL};

  do {
    puts("\nNow remove the boot disk from the floppy drive, place the root "
      "disk\nin the drive, and press <RETURN>.\n");
    fgets(buffer, 10, stdin);
    retcode = mount("/dev/fd0", "/mnt", "minix", 0xc0ed0001, NULL);
      if (retcode)
	puts("Mount failed.");
  } while(retcode);
  execv(argv[0], argv);
}
