#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define MAXFILE 50

typedef struct	{
	char *name;
	int size;
	} afile;
afile files [MAXFILE];

int	lowest[MAXFILE],
	where[MAXFILE],
	best[MAXFILE],
	sum[MAXFILE + 1],
	smallest, maxfile = 0, maxsize;

void readinput(void)
{
  char buffer[1024], name[100];

  while (fgets(buffer, 1024, stdin))
    if (maxfile < MAXFILE) {
      sscanf(buffer, "%99s%*d%d", name, &files[maxfile].size);
      if (files[maxfile].size <= maxsize) {
	files[maxfile].name = strdup(name);
	maxfile++;
      }
      else fprintf(stderr, "Rejecting %s (%d)\n", name, files[maxfile].size);
    }
    else fprintf(stderr, "Rejecting %s (%d)\n", name, files[maxfile].size);
}

void sort(void)
{
  int gap, a, b, c;
  afile temp;

  gap = 1;
  while (gap <= maxfile) gap <<= 1;
  gap--;

  while (gap >>= 1)
    for (c = maxfile - gap - 1; c >= 0; c--) {
      b = c;
      while ((a = b + gap) < maxfile) {
	if (files[b].size <= files[a].size)
	  break;
	temp = files[a];
	files[a] = files[b];
	files[b] = temp;
	b += gap;
      }
    }
}

void try(int top)
{
  int i, j, size = files[top].size;

  for (i = lowest[top]; i < smallest; i++)
    if (size <= sum[i]) {
      sum[i] -= size;
      where[top] = i;
      if (top)
	try(top - 1);
      else {
	j = i + 1;
	while (sum[j] < maxsize)
	  j++;
	if (smallest > --j) {
	  fprintf(stderr, "Reducing smallest to %d.\n", j);
	  smallest = j;
	  for (j = maxfile; j; ) {
	    j--;
	    best[j] = where[j];
	  }
	}
      }
      if ((sum[i] += size) == maxsize)
	break;
    }
}

void fit(void)
{
  int i, j, k, thistotal, mindisks, size, total = 0, wasted = 0;

  smallest = maxfile + 1;
  i = maxfile - 1;
  if (i >= 0) {
    sum[i] = sum[maxfile] = maxsize;
    lowest[i] = mindisks = 1;
  }
  else i = 0;
  while (i--) {
    sum[i] = maxsize;
    size = files[i].size;
    lowest[i] = mindisks + 1;
    for (k = maxfile - 1; k > i; k--)
      if (files[k].size + size <= maxsize) {
	lowest[i] = lowest[k];
	break;
      }
    if (lowest[i] > mindisks)
      mindisks++;
  }

  try(maxfile - 1);
  for (i = smallest; i; i--) {
    thistotal = 0;
    printf("\nDisk %d:\n", smallest - i + 1);
    for (j = maxfile; j; )
      if (best[--j] == i) {
	size = files[j].size;
	thistotal += size;
	printf("%7d  %s\n", size, files[j].name);
      }
    printf("\n  Used: %d", thistotal);
    total += thistotal;
    thistotal = maxsize - thistotal;
    wasted += thistotal;
    printf("\n  Left: %d\n", thistotal);
  }
  printf("\n Total: %d\nWasted: %d\n", total, wasted);
}

void main(int argc, char **argv) {
  if (argc != 3) {
    fprintf(stderr, "usage: fit infile size\n");
    exit(1);
  }
  if ((maxsize = atoi(argv[2])) < 100) {
    fprintf(stderr, "Size %d is too small.\n", maxsize);
    exit(1);
  }
  if (!freopen(argv[1], "r", stdin)) {
    fprintf(stderr, "Unable to read %s.\n", argv[1]);
    exit(1);
  }
  readinput();
  sort();
  fit();
  fclose(stdin);
  exit(0);
}
