# Makefile for brik
# ::[[ @(#) makefile.nix 1.2 89/07/08 10:41:32 ]]::

# Please see brik.h for configuration options.

# Make sure this file is called "makefile" (rename it if necessary).  Then
# type one of the following.
#
# "make bsd", "make sys_v", "make ultrix", "make uport"
#                   -- makes brik in current directory
# "make install"    -- makes brik, then moves it into DESTDIR defined below
# "make clean"      -- deletes "core", objects, and executable

# Directory where we want to move executable brik on "make install"
DESTDIR=/usr/local/bin/.

# CFLAGS and CMORE are flags for the C compiler. 
# LDFLAGS and LDMORE are flags for the loader.

CFLAGS=-O
CMORE=
LDFLAGS=
LDMORE=

CC=cc
LD=cc

.c.o :
	$(CC) -c $(CFLAGS) $(CMORE) $*.c

OBJS = brik.o initcrc.o addbfcrc.o

all:
	@echo 'Please type "make sys_v", "make bsd", "make ultrix", or "make uport"'

sys_v:
	make "CMORE=-DSYS_V" brik

bsd:
	make "CMORE=-DBSD" brik

uport:
	make "CMORE=-Ml -DSYS_V" "LDMORE=-Ml" brik

ultrix:
	make "CMORE=-DBSD -DULTRIX_BUG" brik

brik: $(OBJS)
	$(LD) $(LDFLAGS) $(LDMORE) -o brik $(OBJS)

brik.o: brik.c brik.h assert.h

initcrc.o: initcrc.c brik.h

install: brik
	mv brik $(DESTDIR)/brik

clean:
	/bin/rm -f $(OBJS) core brik
