/* chain.S  -  LILO boot chainer */

/* Written 1992,1993 by Werner Almesberger */


#include <linux/config.h>

#define LILO_ASM
#include "lilo.h"


	.text

	.globl	_main
	.org	0

_main:	jmp	start

	.org	2

	.ascii	"LILO"
	.word	STAGE_CHAIN
	.word	VERSION

offset:	.word	0
drive:	.byte	0
	.byte	0			! head, always zero

start:	cli				! set SS:SP to 0:7C00
	xor	ax,ax
	mov	ss,ax
	mov	ax,#0x7c00
	mov	sp,ax
	sti
	mov	ax,#SETUPSEG		! move boot sector to default location
	mov	ds,ax
	xor	ax,ax
	mov	es,ax
	mov	cx,#256
	mov	si,#512
	mov	di,#BOOTSEG*16
	rep
	movsw
#ifdef DOS_D
	seg	es
	cmp	byte ptr BOOTSEG*16+0x26,#0x29
	je	dos4
	mov	bx,#baddos		! complain
	call	say
	mov	ax,#FIRSTSEG		! restart LILO
	jmpi	#GO,FIRSTSEG
dos4:	seg	es
	mov	byte ptr BOOTSEG*16+0x24,#0x81
#if 0
	mov	bx,#rdy
	call	say
	mov	ah,#0
	int	0x16
#endif
#endif
	mov	cx,#0x20		! move partition table
	mov	si,#PART_TABLE_OFFSET
	mov	di,#PART_TABLE
	rep
	movsw
	mov	si,offset		! DS:SI and ES:SI point to the partition
					! table entry
	add	si,#PART_TABLE
	mov	dx,drive		! initialize DX (drive and head)
	xor	ax,ax			! set DS and ES to zero
#ifdef XXX
	mov	ax,ds
	mov	es,ax
	mov	si,#lilosig
	mov	bx,#cmd
	mov	dl,#0xfe
#else
	mov	ds,ax
#endif
	mov	ax,#0xaa55		! boot signature (just in case ...)
	jmpi	#BOOTSEG*16,0		! start boot sector

#ifdef XXX
lilosig:.ascii	"LILO"
cmd:	.ascii	"98"
	.byte	0
#endif
#ifdef DOS_D

! Display a NUL-terminated string on the console

say:	mov	al,(bx)		! get byte
	or	al,al		! NUL ?
	jz	aret		! yes -> done
	push	bx		! save pointer
	mov	ah,#14		! display, tty-style
	xor	bh,bh
	int	0x10
	pop	bx
	inc	bx		! next one
	jmp	say
aret:	ret			! done

baddos:	.ascii	"Need DOS version 4 or newer."
	.byte	13,10,0

#if 0
rdy:	.ascii "RDY"
	.byte 13,10,0
#endif
#endif
