;;- Machine description for DLX for GNU C compiler
;;   Copyright (C) 1988 Free Software Foundation, Inc.
;;   Contributed by Yongdong Wang (ywang@postgres.berkeley.edu)
;;   Fixed by Rohit Chandra (rohit@seagull.stanford.edu).

;; This file is part of GNU CC.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU CC General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU CC, but only under the conditions described in the
;; GNU CC General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU CC so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.


;;- See file "rtl.def" for documentation on define_insn, match_*, et. al.

;;- cpp macro #define NOTICE_UPDATE_CC in file tm.h handles condition code
;;- updates for most instructions.

;;- Operand classes for the register allocator:

;; Compare instructions.
;; This controls RTL generation and register allocation.

;; comparison_mode has three possible values "","f","d"
;; for integer, float, and double respectively.

;; Since DLX does not have a condition register, we have to record
;; the operands of the comparison and use them when a conditional jump
;; is encountered later.


;; rohit add peepholes

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "nonmemory_operand" "r")
		 (match_operand:SI 1 "nonmemory_operand" "r")))
   (set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  ""
  "seq\\tr1,%0,%1\;bnez\\tr1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 2 "" ""))))]
  ""
  "sne\\tr1,%0,%1\;beqz\\tr1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 2 "" ""))))]
  ""
  "seq\\tr1,%0,%1\;beqz r1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  ""
  "sne\\tr1,%0,%1\;bnez\\tr1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  ""
  "sgt\\tr1,%0,%1\;bnez r1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 2 "" ""))))]
  ""
  "sgt\\tr1,%0,%1\;bnez r1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (gtu (cc0)
			  (const_int 0))
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  ""
  "sgtu\\tr1,%0,%1\;bnez r1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (leu (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 2 "" ""))))]
  ""
  "sgtu\\tr1,%0,%1\;bnez r1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  ""
  "slt\\tr1,%0,%1\;bnez r1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 2 "" ""))))]
  ""
  "sge\\tr1,%0,%1\;beqz r1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (ltu (cc0)
			  (const_int 0))
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  ""
  "sltu\\tr1,%0,%1\;bnez r1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (geu (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 2 "" ""))))]
  ""
  "sgeu\\tr1,%0,%1\;beqz r1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  ""
  "sge\\tr1,%0,%1\;bnez r1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 2 "" ""))))]
  ""
  "slt\\tr1,%0,%1\;beqz r1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (geu (cc0)
			  (const_int 0))
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  ""
  "sgeu\\tr1,%0,%1\;bnez r1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (ltu (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 2 "" ""))))]
  ""
  "sltu\\tr1,%0,%1\;beqz r1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  ""
  "sle\\tr1,%0,%1\;bnez r1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 2 "" ""))))]
  ""
  "sgt\\tr1,%0,%1\;beqz r1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (leu (cc0)
			  (const_int 0))
		      (label_ref (match_operand 2 "" ""))
		      (pc)))]
  ""
  "sleu\\tr1,%0,%1\;bnez r1,%l2\;nop")

(define_peephole
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "r")
		 (match_operand:SI 1 "general_operand" "r")))
   (set (pc)
	(if_then_else (gtu (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 2 "" ""))))]
  ""
  "sgtu\\tr1,%0,%1\;beqz r1,%l2\;nop")



;; rohit - start comparisons

(define_insn "cmpsi"
  [(set (cc0)
	(compare (match_operand:SI 0 "register_operand" "r")
		 (match_operand:SI 1 "register_operand" "r")))]
  ""
  "*
    compare_collect (SImode, operands[0], operands[1]);
    return \"\\t;cmpsi\\t%0,%1\";
")
	

(define_insn "cmpdf"
  [(set (cc0)
	(compare (match_operand:DF 0 "register_operand" "f")
		 (match_operand:DF 1 "register_operand" "f")))]
  ""
  "*
    compare_collect (DFmode, operands[0], operands[1]);
    return \"\\t;cmpdf\\t%0,%1\" ;
")

(define_insn "cmpsf"
  [(set (cc0)
	(compare (match_operand:SF 0 "register_operand" "f")
		 (match_operand:SF 1 "register_operand" "f")))]
  ""
  "*
    compare_collect (SFmode, operands[0], operands[1]);
    return \"\\t;cmpsf\\t%0,%1\" ;
")

(define_insn ""
  [(set (cc0)
	(match_operand:QI 0 "general_operand" "r"))]
  ""
  "*
    compare_collect (QImode, operands[0], gen_rtx (REG, QImode, 0));
    return \"\\t; (set (cc0)\\t%0)\";
")

(define_insn ""
  [(set (cc0)
	(match_operand:HI 0 "general_operand" "r"))]
  ""
  "*
    compare_collect (HImode, operands[0], gen_rtx (REG, HImode, 0));
    return \"\\t; (set (cc0)\\t%0)\";
")

(define_insn ""
  [(set (cc0)
	(match_operand:SI 0 "general_operand" "r"))]
  ""
  "*
    compare_collect (SImode, operands[0], gen_rtx (REG, SImode, 0));
    return \"\\t; (set (cc0)\\t%0)\";
")

;; rohit - begin branches

(define_insn "beq"
  [(set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"eqd\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"eq\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"seq\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}
")

(define_insn "bne"
  [(set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"eqd\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"eqf\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"sne\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}

")

(define_insn "bgt"
  [(set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"led\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"lef\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"sgt\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}

")

(define_insn "blt"
  [(set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"ltd\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"ltf\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"slt\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}
")

(define_insn "bge"
  [(set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"ltd\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"ltf\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"sge\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}
")

(define_insn "ble"
  [(set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"led\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"lef\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"sle\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}
")


;; unsigned compare and branch
(define_insn "bgtu"
  [(set (pc)
	(if_then_else (gtu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"led\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"lef\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else
    {
;      output_asm_insn (\"sgtu\\t%0,%1,%2\\t#bgtu\", br_ops);
      output_asm_insn (\"sgtu\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}

")

(define_insn "bltu"
  [(set (pc)
	(if_then_else (ltu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"ltd\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"ltf\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"sltu\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}
")


(define_insn "bgeu"
  [(set (pc)
	(if_then_else (geu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"ltd\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"ltf\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"sgeu\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}
")

(define_insn "bleu"
  [(set (pc)
	(if_then_else (leu (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"led\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"lef\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"sleu\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}
")

(define_insn ""
  [(set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"eqd\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"eqf\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"seq\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}
")

(define_insn ""
  [(set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"eqd\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"eqf\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"sne\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}

")

(define_insn ""
  [(set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"led\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"lef\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"sgt\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}
")

(define_insn ""
  [(set (pc)
	(if_then_else (leu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"led\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"lef\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"sgtu\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}
")

(define_insn ""
  [(set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"ltd\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"ltf\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"slt\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}
")

(define_insn ""
  [(set (pc)
	(if_then_else (geu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"ltd\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"ltf\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"sltu\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}
")

(define_insn ""
  [(set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"ltd\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"ltf\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"sge\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}
")

(define_insn ""
  [(set (pc)
	(if_then_else (ltu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"ltd\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"ltf\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpf\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"sgeu\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}
")

(define_insn ""
  [(set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"led\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"lef\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"sle\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}
")

(define_insn ""
  [(set (pc)
	(if_then_else (gtu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
  rtx br_ops[3];
  enum machine_mode mode;
  compare_restore (br_ops,  &mode, insn);
  br_ops[2] = operands[0];
  if (mode == DFmode)
    {
      output_asm_insn (\"led\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else if  (mode == SFmode)
    {
      output_asm_insn (\"lef\\t%0,%1\", br_ops);
      output_asm_insn (\"bfpt\\t%2\;nop\", br_ops);
    }
  else
    {
      output_asm_insn (\"sleu\\tr1,%0,%1\", br_ops);
      output_asm_insn (\"bnez\\tr1,%2\;nop\", br_ops);
    }
  return \"\";
}
")





/* rohit end */

;(define_insn "cmpsi"
;  [(set (cc0)
;	(minus (match_operand:SI 0 "nonmemory_operand" "rI")
;	       (match_operand:SI 1 "nonmemory_operand" "rI")))]
;  ""
;  "*
;{
;  cc_status.value1 = operands[0], cc_status.value2 = operands[1];
;  comparison_mode = \"\";
;  return \"\";
;}")
;
;;; similar for doubles and floats.
;(define_insn "cmpdf"
;  [(set (cc0)
;	(minus:DF (match_operand:DF 0 "register_operand" "f")
;		  (match_operand:DF 1 "register_operand" "f")))]
;  ""
;  "*
;{
;  cc_status.value1 = operands[0], cc_status.value2 = operands[1];
;  comparison_mode = \"d\";
;  return \"\";
;}")
;
;(define_insn "cmpsf"
;  [(set (cc0)
;	(minus:SF (match_operand:SF 0 "register_operand" "f")
;		  (match_operand:SF 1 "register_operand" "f")))]
;  ""
;  "*
;{
;  cc_status.value1 = operands[0], cc_status.value2 = operands[1];
;  comparison_mode = \"f\";
;  return \"\";
;}")
;
;;; We have to have this because cse can optimize the previous pattern
;;; into this one.
;(define_insn "tstsi"
;  [(set (cc0)
;	(match_operand:SI 0 "register_operand" "r"))]
;  ""
;  "*
;{
;  cc_status.value1 = operands[0], cc_status.value2 = const0_rtx;
;  comparison_mode = \"\";
;  return \"\";
;}")
;
;;; These control RTL generation for conditional jump insns
;;; and match them for register allocation.
;
;(define_insn "beq"
;  [(set (pc)
;	(if_then_else (eq (cc0)
;			  (const_int 0))
;		      (label_ref (match_operand 0 "" ""))
;		      (pc)))]
;  ""
;  "* return output_compare (operands, \"eq\"); ")
;
;(define_insn "bne"
;  [(set (pc)
;	(if_then_else (ne (cc0)
;			  (const_int 0))
;		      (label_ref (match_operand 0 "" ""))
;		      (pc)))]
;  ""
;  "* return output_compare (operands, \"ne\"); ")
;
;(define_insn "bgt"
;  [(set (pc)
;	(if_then_else (gt (cc0)
;			  (const_int 0))
;		      (label_ref (match_operand 0 "" ""))
;		      (pc)))]
;  ""
;  "* return output_compare (operands, \"gt\"); ")
;
;(define_insn "bgtu"
;  [(set (pc)
;	(if_then_else (gtu (cc0)
;			   (const_int 0))
;		      (label_ref (match_operand 0 "" ""))
;		      (pc)))]
;  ""
;  "* return output_compare (operands, \"gtu\"); ")
;
;(define_insn "blt"
;  [(set (pc)
;	(if_then_else (lt (cc0)
;			  (const_int 0))
;		      (label_ref (match_operand 0 "" ""))
;		      (pc)))]
;  ""
;  "* return output_compare (operands, \"lt\"); ")
;
;(define_insn "bltu"
;  [(set (pc)
;	(if_then_else (ltu (cc0)
;			   (const_int 0))
;		      (label_ref (match_operand 0 "" ""))
;		      (pc)))]
;  ""
;  "* return output_compare (operands, \"ltu\"); ")
;
;(define_insn "bge"
;  [(set (pc)
;	(if_then_else (ge (cc0)
;			  (const_int 0))
;		      (label_ref (match_operand 0 "" ""))
;		      (pc)))]
;  ""
;  "* return output_compare (operands, \"ge\"); ")
;
;(define_insn "bgeu"
;  [(set (pc)
;	(if_then_else (geu (cc0)
;			   (const_int 0))
;		      (label_ref (match_operand 0 "" ""))
;		      (pc)))]
;  ""
;  "* return output_compare (operands, \"geu\"); ")
;
;(define_insn "ble"
;  [(set (pc)
;	(if_then_else (le (cc0)
;			  (const_int 0))
;		      (label_ref (match_operand 0 "" ""))
;		      (pc)))]
;  ""
;  "* return output_compare (operands, \"le\"); ")
;
;(define_insn "bleu"
;  [(set (pc)
;	(if_then_else (leu (cc0)
;			   (const_int 0))
;		      (label_ref (match_operand 0 "" ""))
;		      (pc)))]
;  ""
;  "* return output_compare (operands, \"leu\"); ")
;
;;; These match inverted jump insns for register allocation.
;
;(define_insn ""
;  [(set (pc)
;	(if_then_else (eq (cc0)
;			  (const_int 0))
;		      (pc)
;		      (label_ref (match_operand 0 "" ""))))]
;  ""
;  "* return output_compare (operands, \"ne\"); ")
;
;(define_insn ""
;  [(set (pc)
;	(if_then_else (ne (cc0)
;			  (const_int 0))
;		      (pc)
;		      (label_ref (match_operand 0 "" ""))))]
;  ""
;  "* return output_compare (operands, \"eq\"); ")
;
;(define_insn ""
;  [(set (pc)
;	(if_then_else (gt (cc0)
;			  (const_int 0))
;		      (pc)
;		      (label_ref (match_operand 0 "" ""))))]
;  ""
;  "* return output_compare (operands, \"le\"); ")
;
;(define_insn ""
;  [(set (pc)
;	(if_then_else (gtu (cc0)
;			   (const_int 0))
;		      (pc)
;		      (label_ref (match_operand 0 "" ""))))]
;  ""
;  "* return output_compare (operands, \"leu\"); ")
;
;(define_insn ""
;  [(set (pc)
;	(if_then_else (lt (cc0)
;			  (const_int 0))
;		      (pc)
;		      (label_ref (match_operand 0 "" ""))))]
;  ""
;  "* return output_compare (operands, \"ge\"); ")
;
;(define_insn ""
;  [(set (pc)
;	(if_then_else (ltu (cc0)
;			   (const_int 0))
;		      (pc)
;		      (label_ref (match_operand 0 "" ""))))]
;  ""
;  "* return output_compare (operands, \"geu\"); ")
;
;(define_insn ""
;  [(set (pc)
;	(if_then_else (ge (cc0)
;			  (const_int 0))
;		      (pc)
;		      (label_ref (match_operand 0 "" ""))))]
;  ""
;  "* return output_compare (operands, \"lt\"); ")
;
;(define_insn ""
;  [(set (pc)
;	(if_then_else (geu (cc0)
;			   (const_int 0))
;		      (pc)
;		      (label_ref (match_operand 0 "" ""))))]
;  ""
;  "* return output_compare (operands, \"ltu\"); ")
;
;(define_insn ""
;  [(set (pc)
;	(if_then_else (le (cc0)
;			  (const_int 0))
;		      (pc)
;		      (label_ref (match_operand 0 "" ""))))]
;  ""
;  "* return output_compare (operands, \"gt\"); ")
;
;(define_insn ""
;  [(set (pc)
;	(if_then_else (leu (cc0)
;			   (const_int 0))
;		      (pc)
;		      (label_ref (match_operand 0 "" ""))))]
;  ""
;  "* return output_compare (operands, \"gtu\"); ")


;; Peepholes for set-on-integer-condition-code insns
;; These are disabled until combiner is taught how to use them correctly
;; (note that better code is generated that should be with these
;;  insns because they fool expand_expr into passing more stuff in
;;  registers than it is supposed to.  Should understand when this
;;  can be taken advantage of officially.)

;; This part is copied from SPARC.  They should be modified for DLX,
;; but too bad I do not have the time to do it.
(define_insn "seq"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(eq (cc0) (const_int 0)))]
  "0"
  "* { return output_scc_insn (GET_CODE (SET_SRC (PATTERN (insn))), operands); }")

(define_insn "sne"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(ne (cc0) (const_int 0)))]
  "0"
  "* { return output_scc_insn (GET_CODE (SET_SRC (PATTERN (insn))), operands); }")

(define_insn "sgt"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(gt (cc0) (const_int 0)))]
  "0"
  "* { return output_scc_insn (GET_CODE (SET_SRC (PATTERN (insn))), operands); }")

(define_insn "sgtu"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(gtu (cc0) (const_int 0)))]
  "0"
  "* { return output_scc_insn (GET_CODE (SET_SRC (PATTERN (insn))), operands); }")

(define_insn "slt"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(lt (cc0) (const_int 0)))]
  "0"
  "* { return output_scc_insn (GET_CODE (SET_SRC (PATTERN (insn))), operands); }")

(define_insn "sltu"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(ltu (cc0) (const_int 0)))]
  "0"
  "* { return output_scc_insn (GET_CODE (SET_SRC (PATTERN (insn))), operands); }")

(define_insn "sge"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(ge (cc0) (const_int 0)))]
  "0"
  "* { return output_scc_insn (GET_CODE (SET_SRC (PATTERN (insn))), operands); }")

(define_insn "sgeu"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(geu (cc0) (const_int 0)))]
  "0"
  "* { return output_scc_insn (GET_CODE (SET_SRC (PATTERN (insn))), operands); }")

(define_insn "sle"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(le (cc0) (const_int 0)))]
  "0"
  "* { return output_scc_insn (GET_CODE (SET_SRC (PATTERN (insn))), operands); }")

(define_insn "sleu"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(leu (cc0) (const_int 0)))]
  "0"
  "* { return output_scc_insn (GET_CODE (SET_SRC (PATTERN (insn))), operands); }")

;; Move instructions
;; Modified for dlx

;; if destination is m, then definitely store
;; else the destination is r 
;; if source is m, then definitely load
;; if source is r, them move between regs
;; if source is a small integer (< 16 bits), treat it as an immediate
;; otherwise it should be a large integer constant, load its address
;; into the register.

(define_insn "movsi"
  [(set (match_operand:SI 0 "general_operand" "=r,r,r,r,m")
	(match_operand:SI 1 "general_operand" "r,m,I,i,rJ"))]
  ""
  "*
{
  switch (which_alternative) {
    case 0: return \"add %0,r0,%1\";
    case 1: return \"lw %0,%1\";
    case 2: return \"addi %0,r0,%1\";
/*    case 3: output_load_immediate (operands); return \"\";  */
    case 3: return \"lhi %0,(%1>>16)&0xffff\;addui %0,%0,(%1&0xffff)\";
    case 4: if (GET_CODE (operands[0]) == MEM)
            return \"sw %0,%r1\";
    default: printf(\"some error in load immediate\\n\"); return \"\"; 
  }
}")

;  if (GET_CODE (operands[1]) == MEM)
;    return \"lw %0,%1\";
;  if (REG_P (operands[1]))
;    return \"add %0,r0,%1\";
;  if (GET_CODE (operands[1]) == CONST_INT && SMALL_INT (operands[1]))
;    return \"add %0,r0,%1\";
;  return \"add %0,r0,%1\";
;}")

;; dlx doesn't support this.
;(define_insn ""
;  [(set (match_operand:SI 0 "register_operand" "=r")
;	(mem:SI (plus:SI (match_operand:SI 1 "register_operand" "r")
;			 (match_operand:SI 2 "register_operand" "r"))))]
;  ""
;  "ld [%1+%2],%0")

(define_insn "movhi"
  [(set (match_operand:HI 0 "general_operand" "=r,m")
	(match_operand:HI 1 "general_operand" "rmi,rJ"))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == MEM)
    return \"sh %0,%r1\";
  if (GET_CODE (operands[1]) == MEM)
    return \"lh %0,%1\";
  if (REG_P (operands[1]))
    return \"add %0,r0,%1\";
  if (GET_CODE (operands[1]) == CONST_INT && SMALL_INT (operands[1]))
    return \"add %0,r0,%1\";
  return \"lh %0,%1\";
}")

(define_insn "movqi"
  [(set (match_operand:QI 0 "general_operand" "=r,m")
	(match_operand:QI 1 "general_operand" "rmi,rJ"))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == MEM)
    return \"sb %0,%r1\";
  if (GET_CODE (operands[1]) == MEM)
    return \"lb %0,%1\";
  return \"add %0,r0,%1\";
}")

;; The definition of this insn does not really explain what it does,
;; but it should suffice
;; that anything generated as this insn will be recognized as one
;; and that it won't successfully combine with anything.
;(define_insn "movstrsi"
;  [(set (match_operand:BLK 0 "general_operand" "=g")
;	(match_operand:BLK 1 "general_operand" "g"))
;   (use (match_operand:SI 2 "arith32_operand" "rn"))
;   (clobber (reg:SI 8))
;   (clobber (reg:SI 9))
;   (clobber (reg:SI 10))]
;  ""
;  "* return output_block_move (operands);")

;; Floating point move insns
;; On DLX, We are using integer registers to move doubles from one
;; memory location to another.  This can be fixed.
(define_insn ""
  [(set (match_operand:DF 0 "general_operand" "=fm")
	(mem:DF (match_operand:SI 1 "immediate_operand" "i")))]
  ""
  "*
{
  if (FP_REG_P (operands[0]))
    return \"add r1,r0,%1\;ld %0,0(r1)\";
  output_asm_insn (\"add r1,r0,%1\;ld f0,0(r1)\",
		   operands);
  operands[1] = gen_rtx (REG, DFmode, 32);
  return output_fp_move_double (operands);
}")

(define_insn ""
  [(set (match_operand:SF 0 "general_operand" "=fm")
	(mem:SF (match_operand:SI 1 "immediate_operand" "i")))]
  ""
  "*
{
  if (FP_REG_P (operands[0]))
    return \"add r1,r0,%1\;lf %0,0(r1)\";
  return \"add r1,r0,%1\;lf f0,0(r1)\;sf %0,f0\";
}")

;; This pattern forces (set (reg:DF ...) (const_double ...))
;; to be reloaded by putting the constant into memory.
;; It must come before the more general movdf pattern.
(define_insn ""
  [(set (match_operand:DF 0 "general_operand" "=r,f,o")
	(match_operand:DF 1 "" "mG,m,G"))]
  "GET_CODE (operands[1]) == CONST_DOUBLE"
  "*
{
  if (FP_REG_P (operands[0]))
    return output_fp_move_double (operands);
  return output_move_double (operands);
}")

(define_insn "movdf"
  [(set (match_operand:DF 0 "general_operand" "=r,m,?f,?rm")
	(match_operand:DF 1 "general_operand" "rm,r,rfm,f"))]
  ""
  "*
{
  if (FP_REG_P (operands[0]) || FP_REG_P (operands[1]))
    return output_fp_move_double (operands);
  return output_move_double (operands);
}")

(define_insn "movdi"
  [(set (match_operand:DI 0 "general_operand" "=r,m,?f,?rm")
	(match_operand:DI 1 "general_operand" "rm,r,rfm,f"))]
  ""
  "*
{
  if (FP_REG_P (operands[0]) || FP_REG_P (operands[1]))
    return output_fp_move_double (operands);
  return output_move_double (operands);
}")

(define_insn "movsf"
  [(set (match_operand:SF 0 "general_operand" "=rf,rm")
	(match_operand:SF 1 "general_operand" "rfm,rf"))]
  ""
  "*
{
  if (FP_REG_P (operands[0]))
    {
      if (FP_REG_P (operands[1]))
	return \"movf %0,%1\";
      if (GET_CODE (operands[1]) == REG)
        return \"movi2fp %0,%1\";
      return \"lf %0,%1\";
    }
  if (FP_REG_P (operands[1]))
    {
      if (GET_CODE (operands[0]) == REG)
	return \"movfp2i %0, %1\";
      return \"sf %0,%1\";
    }
  if (GET_CODE (operands[0]) == MEM)
    return \"sw %0,%r1\";
  if (GET_CODE (operands[1]) == MEM)
    return \"lw %0,%1\";
  return \"add %0,r0,%1\";
}")

;;- truncation instructions
;; This part has been fixed.
(define_insn "truncsiqi2"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(truncate:QI
	 (match_operand:SI 1 "register_operand" "r")))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == MEM)
    return \"sb %0,%1\";
  return \"add %0,r0,%1\";
}")

(define_insn "trunchiqi2"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(truncate:QI
	 (match_operand:HI 1 "register_operand" "r")))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == MEM)
    return \"sb %0,%1\";
  return \"add %0,r0,%1\";
}")

(define_insn "truncsihi2"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(truncate:HI
	 (match_operand:SI 1 "register_operand" "r")))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == MEM)
    return \"sh %0,%1\";
  return \"add %0,r0,%1\";
}")

;;- zero extension instructions

;; Note that the one starting from HImode comes before those for QImode
;; so that a constant operand will match HImode, not QImode.

(define_insn "zero_extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(zero_extend:SI
	 (match_operand:HI 1 "general_operand" "g")))]
  ""
  "*
{
  if (REG_P (operands[1]))
    return \"sll %0,%1,\#0x10\;srl %0,%0,\#0x10\";
  if (GET_CODE (operands[1]) == CONST_INT)
    abort ();
  return \"lhu %0,%1\";
}")

(define_insn "zero_extendqihi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(zero_extend:HI
	 (match_operand:QI 1 "general_operand" "g")))]
  ""
  "*
{
  if (REG_P (operands[1]))
    return \"and %0,\#0xff,%1\";
  if (GET_CODE (operands[1]) == CONST_INT)
    abort ();
  return \"lbu %1,%0\";
}")

(define_insn "zero_extendqisi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(zero_extend:SI
	 (match_operand:QI 1 "general_operand" "g")))]
  ""
  "*
{
  if (REG_P (operands[1]))
    return \"and %0,%1,\#0xff\";
  if (GET_CODE (operands[1]) == CONST_INT)
    abort ();
  return \"lbu %1,%0\";
}")

;;- sign extension instructions
;; Note that the one starting from HImode comes before those for QImode
;; so that a constant operand will match HImode, not QImode.

(define_insn "extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(sign_extend:SI
	 (match_operand:HI 1 "general_operand" "g")))]
  ""
  "*
{
  if (REG_P (operands[1]))
    return \"sll %0,%1,\#0x10\;sra %0,%0,\#0x10\";
  if (GET_CODE (operands[1]) == CONST_INT)
    abort ();
  return \"lh %0,%1\";
}")

(define_insn "extendqihi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(sign_extend:HI
	 (match_operand:QI 1 "general_operand" "g")))]
  ""
  "*
{
  if (REG_P (operands[1]))
    return \"sll %0,%1,\#0x18\;sra %0,%0,\#0x18\";
  if (GET_CODE (operands[1]) == CONST_INT)
    abort ();
  return \"lb %0,%1\";
}")

(define_insn "extendqisi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(sign_extend:SI
	 (match_operand:QI 1 "general_operand" "g")))]
  ""
  "*
{
  if (REG_P (operands[1]))
    return \"sll %0,%1,\#0x18\;sra %0,%0,\#0x18\";
  if (GET_CODE (operands[1]) == CONST_INT)
    abort ();
  return \"lb %0,%1\";
}")

;; Signed bitfield extractions come out looking like
;;	(shiftrt (shift (sign_extend <Y>) <C1>) <C2>)
;; which we expand poorly as four shift insns.
;; These patters yeild two shifts:
;;	(shiftrt (shift <Y> <C3>) <C4>)
(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=r")
	(ashiftrt:SI
	 (sign_extend:SI
	  (match_operand:QI 1 "register_operand" "r"))
	 (match_operand:SI 2 "small_int" "n")))]
  ""
  "sll %0,%1,\#0x18\;sra %0,%0,\#0x18\;sra %0,%0,%2")

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=r")
	(ashiftrt:SI
	 (sign_extend:SI
	  (subreg:QI (ashift:SI (match_operand:SI 1 "register_operand" "r")
				(match_operand:SI 2 "small_int" "n")) 0))
	 (match_operand:SI 3 "small_int" "n")))]
  ""
  "sll %0,%1,\#0x18\;sll %0,%0,%2\;sra %0,%0,\#0x18\;sra %0,%0,%3")

;; Special patterns for optimizing bit-field instructions.
;; Not provided by DLX.

;; First two patterns are for bitfields that came from memory
;; testing only the high bit.  They work with old combiner.
;; @@ Actually, the second pattern does not work if we
;; @@ need to set the N bit.
;(define_insn ""
; [(set (cc0)
;	(zero_extend:SI (subreg:QI (lshiftrt:SI (match_operand:SI 0 "register_operand" "r")
;						(const_int 7)) 0)))]
;  "0"
;  "andcc %0,128,%%g0")
;
;(define_insn ""
;  [(set (cc0)
;	(sign_extend:SI (subreg:QI (ashiftrt:SI (match_operand:SI 0 "register_operand" "r")
;						(const_int 7)) 0)))]
;  "0"
;  "andcc %0,128,%%g0")
;
;; next two patterns are good for bitfields coming from memory
;; (via pseudo-register) or from a register, though this optimization
;; is only good for values contained wholly within the bottom 13 bits
;(define_insn ""
;  [(set (cc0)
;	(and:SI (lshiftrt:SI (match_operand:SI 0 "register_operand" "r")
;			     (match_operand:SI 1 "small_int" "n"))
;		(match_operand:SI 2 "small_int" "n")))]
;  ""
;  "andcc %0,%2<<%1,%%g0")
;
;(define_insn ""
;  [(set (cc0)
;	(and:SI (ashiftrt:SI (match_operand:SI 0 "register_operand" "r")
;			     (match_operand:SI 1 "small_int" "n"))
;		(match_operand:SI 2 "small_int" "n")))]
;  ""
;  "andcc %0,%2<<%1,%%g0")

;; Conversions between float and double.

(define_insn "extendsfdf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(float_extend:DF
	 (match_operand:SF 1 "register_operand" "f")))]
  ""
  "cvtf2d %0,%1")

(define_insn "truncdfsf2"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(float_truncate:SF
	 (match_operand:DF 1 "register_operand" "f")))]
  ""
  "cvtd2f %0,%1")

;; Conversion between fixed point and floating point.
;; Note that among the fix-to-float insns
;; the ones that start with SImode come first.
;; That is so that an operand that is a CONST_INT
;; (and therefore lacks a specific machine mode).
;; will be recognized as SImode (which is always valid)
;; rather than as QImode or HImode.
  
;; This pattern forces (set (reg:SF ...) (float:SF (const_int ...)))
;; to be reloaded by putting the constant into memory.
;; It must come before the more general floatsisf2 pattern.

;; We reserve r1 for temporary usage like this to avoid complication.
;; Sounds stupid?  Then you write the smart code.

(define_insn ""
  [(set (match_operand:SF 0 "general_operand" "=f")
	(float:SF (match_operand 1 "" "m")))]
  "GET_CODE (operands[1]) == CONST_INT"
  "lf f0,%1\;cvti2f %0,f0")

;; On DLX, we can only convert an integer in integer register to
;; float in float register.
(define_insn "floatsisf2"
  [(set (match_operand:SF 0 "general_operand" "=f")
	(float:SF (match_operand:SI 1 "general_operand" "rm")))]
  ""
  "*
{
  if (GET_CODE (operands[1]) == MEM)
    return \"lf f0,%1\;cvti2f %0,f0\";
  else
    return \"movi2fp f0, %1\;cvti2f %0,f0\";
}")

;; This pattern forces (set (reg:DF ...) (float:DF (const_int ...)))
;; to be reloaded by putting the constant into memory.
;; It must come before the more general floatsidf2 pattern.
(define_insn ""
  [(set (match_operand:DF 0 "general_operand" "=f")
	(float:DF (match_operand 1 "" "m")))]
  "GET_CODE (operands[1]) == CONST_INT"
  "ld f0,%1\;cvti2d %0,f0")

(define_insn "floatsidf2"
  [(set (match_operand:DF 0 "general_operand" "=f")
	(float:DF (match_operand:SI 1 "general_operand" "rm")))]
  ""
  "*
{
  if (GET_CODE (operands[1]) == MEM)
    return \"ld f0,%1\;cvti2d %0,f0\";
  else
    return \"movi2fp f0,%1\;cvti2d %0,f0\";
}")

;; Convert a float to an actual integer.
;; Truncation is performed as part of the conversion.
(define_insn "fix_truncsfsi2"
  [(set (match_operand:SI 0 "general_operand" "=rm")
	(fix:SI (fix:SF (match_operand:SF 1 "general_operand" "fm"))))]
  ""
  "*
{
  if (FP_REG_P (operands[1]))
    {
      if (GET_CODE (operands[0]) == MEM)
	return \"cvtf2i f0,%1\;sf %0,f0\";
      else
        return \"cvtf2i f0,%1\;movfp2i %0,f0\";
    }		
  else
    {
      output_asm_insn (\"lf f0,%1\;cvtf2i f1,f0\", operands);
      if (GET_CODE (operands[0]) == MEM) 
	return \"sf %0,f1\";
      else
	return \"movfp2i %0,f1\";
    }
}")

(define_insn "fix_truncdfsi2"
  [(set (match_operand:SI 0 "general_operand" "=rm")
	(fix:SI (fix:DF (match_operand:DF 1 "general_operand" "fm"))))]
  ""
  "*
{
  if (FP_REG_P (operands[1]))
    {
      if (GET_CODE (operands[0]) == MEM)
	return \"cvtd2i f0,%1\;sd %0,f0\";
      else
        return \"cvtd2i f0,%1\;movfp2i %0,f0\";
    }		
  else
    {
      output_asm_insn (\"ld f0,%1\;cvtd2i f1,f0\", operands);
      if (GET_CODE (operands[0]) == MEM) 
	return \"sd %0,f1\";
      else
	return \"movfp2i %0,f1\";
    }
}")

;;- arithmetic instructions

;; On DLX, the compiler does not have to generate an "addi" even
;; if the second operand is an immediate.  
;; The assembler will take care of that.
(define_insn "addsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_operand:SI 1 "nonmemory_operand" "%r")
		 (match_operand:SI 2 "nonmemory_operand" "rI")))]
  ""
  "add %0,%1,%2")

(define_insn "subsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(minus:SI (match_operand:SI 1 "register_operand" "r")
		  (match_operand:SI 2 "nonmemory_operand" "rI")))]
  ""
  "sub %0,%1,%2")

(define_insn "mulsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(mult:SI (match_operand:SI 1 "register_operand" "%r")
		 (match_operand:SI 2 "register_operand" "r")))]
  ""
  "movi2fp f2,%1\;movi2fp f3,%2\;mult f2,f2,f3\;movfp2i %0,f2")

(define_insn "divsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(div:SI (match_operand:SI 1 "register_operand" "r")
		(match_operand:SI 2 "register_operand" "r")))]
  ""
  "movi2fp f2,%1\;movi2fp f3,%2\;div f2,f2,f3\;movfp2i %0,f2")

;(define_insn "modsi3"
;  [(set (match_operand:SI 0 "register_operand" "=r")
;	(mod:SI (match_operand:SI 1 "register_operand" "r")
;		 (match_operand:SI 2 "register_operand" "r")))]
;  ""
;  "movi2fp f2,%1\;movi2fp f3,%2\;divf f2,f2,f3\;movfp2i %0,f3")

;; These should be modified once we can handle unsigned operations
(define_insn "umulsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(umult:SI (match_operand:SI 1 "register_operand" "%r")
		 (match_operand:SI 2 "register_operand" "r")))]
  ""
  "movi2fp f2,%1\;movi2fp f3,%2\;multu f2,f2,f3\;movfp2i %0,f2")

(define_insn "udivsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(udiv:SI (match_operand:SI 1 "register_operand" "r")
		(match_operand:SI 2 "register_operand" "r")))]
  ""
  "movi2fp f2,%1\;movi2fp f3,%2\;divu f2,f2,f3\;movfp2i %0,f2")

;(define_insn "umodsi3"
;  [(set (match_operand:SI 0 "register_operand" "=r")
;	(umod:SI (match_operand:SI 1 "register_operand" "r")
;		 (match_operand:SI 2 "register_operand" "r")))]
;  ""
;  "movi2fp f2,%1\;movi2fp f3,%2\;divf f2,f2,f3\;movfp2i %0,f3")


(define_insn "andsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(and:SI (match_operand:SI 1 "nonmemory_operand" "%r")
		(match_operand:SI 2 "nonmemory_operand" "rI")))]
  ""
  "and %0,%1,%2")

(define_insn "iorsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(ior:SI (match_operand:SI 1 "nonmemory_operand" "%r")
		(match_operand:SI 2 "nonmemory_operand" "rI")))]
  ""
  "or %0,%1,%2")

(define_insn "xorsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(xor:SI (match_operand:SI 1 "nonmemory_operand" "%r")
		(match_operand:SI 2 "nonmemory_operand" "rI")))]
  ""
  "xor %0,%1,%2")

(define_insn "negsi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(neg:SI (match_operand:SI 1 "nonmemory_operand" "rI")))]
  ""
  "sub %0,r0,%1")

(define_insn "one_cmplsi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(not:SI (match_operand:SI 1 "register_operand" "r")))]
  ""
  "lhi r1,\#0xffff\;ori r1,\#0xffff\; xor %0,r1")

;; Floating point arithmetic instructions.

(define_insn "adddf3"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(plus:DF (match_operand:DF 1 "register_operand" "f")
		 (match_operand:DF 2 "register_operand" "f")))]
  ""
  "addd %0,%1,%2")

(define_insn "addsf3"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(plus:SF (match_operand:SF 1 "register_operand" "f")
		 (match_operand:SF 2 "register_operand" "f")))]
  ""
  "addf %0,%1,%2")

(define_insn "subdf3"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(minus:DF (match_operand:DF 1 "register_operand" "f")
		  (match_operand:DF 2 "register_operand" "f")))]
  ""
  "subd %0,%1,%2")

(define_insn "subsf3"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(minus:SF (match_operand:SF 1 "register_operand" "f")
		  (match_operand:SF 2 "register_operand" "f")))]
  ""
  "subf %0,%1,%2")

(define_insn "muldf3"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(mult:DF (match_operand:DF 1 "register_operand" "f")
		 (match_operand:DF 2 "register_operand" "f")))]
  ""
  "multd %0,%1,%2")

(define_insn "mulsf3"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(mult:SF (match_operand:SF 1 "register_operand" "f")
		 (match_operand:SF 2 "register_operand" "f")))]
  ""
  "multf %0,%1,%2")

(define_insn "divdf3"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(div:DF (match_operand:DF 1 "register_operand" "f")
		(match_operand:DF 2 "register_operand" "f")))]
  ""
  "divd %0,%1,%2")

(define_insn "divsf3"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(div:SF (match_operand:SF 1 "register_operand" "f")
		(match_operand:SF 2 "register_operand" "f")))]
  ""
  "divf %0,%1,%2")

(define_insn "negdf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(neg:DF (match_operand:DF 1 "register_operand" "f")))]
  ""
  "movi2fp f0,r0\;cvtf2d f0, f0\;subd %0,f0,%1")

(define_insn "negsf2"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(neg:SF (match_operand:SF 1 "register_operand" "f")))]
  ""
  "movi2fp f0,r0\;cvti2f f0, f0\;subf %0,f0,%1")

; let the compiler do this - there's no instruction in dlx
;(define_insn "absdf2"
;  [(set (match_operand:DF 0 "register_operand" "=f")
;	(abs:DF (match_operand:DF 1 "register_operand" "f")))]
;  ""
;  "dabs %0, %1")

;(define_insn "abssf2"
;  [(set (match_operand:SF 0 "register_operand" "=f")
;	(abs:SF (match_operand:SF 1 "register_operand" "f")))]
;  ""
;  "fabs %0,%1")

;; Shift instructions

;; Optimized special case of shifting.
;; Must precede the general case.

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=r")
	(ashiftrt:SI (match_operand:SI 1 "memory_operand" "m")
		     (const_int 24)))]
  ""
  "lb %0,%1")

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=r")
	(lshiftrt:SI (match_operand:SI 1 "memory_operand" "m")
		     (const_int 24)))]
  ""
  "lbu %0,%1")

;;- arithmetic shift instructions
;; 04/26/91 begin rohit
(define_insn "lshlsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
    (lshift:SI (match_operand:SI 1 "register_operand" "r,r")
               (match_operand:SI 2 "general_operand" "r,I")))]
  ""
  "*
{
    switch (which_alternative) {
        case 0: return \"sll %0,%1,%2\";
        case 1: return \"slli %0,%1,%2\";
    }
}")

(define_insn "ashlsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
    (ashift:SI (match_operand:SI 1 "register_operand" "r,r")
               (match_operand:SI 2 "general_operand" "r,I")))]
  ""
  "*
{
    switch (which_alternative) {
        case 0: return \"sll %0,%1,%2\";
        case 1: return \"slli %0,%1,%2\";
    }
}")

(define_insn "lshrsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
    (lshiftrt:SI (match_operand:SI 1 "register_operand" "r,r")
                (match_operand:SI 2 "general_operand" "r,I")))]
  ""
  "*
{
    switch (which_alternative) {
        case 0: return \"srl %0,%1,%2\";
        case 1: return \"srli %0,%1,%2\";
    }
}")

(define_insn "ashrsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
    (ashiftrt:SI (match_operand:SI 1 "register_operand" "r,r")
                 (match_operand:SI 2 "general_operand" "r,I")))]
  ""
  "*
{
    switch (which_alternative) {
        case 0: return \"sra %0,%1,%2\";
        case 1: return \"srai %0,%1,%2\";
    }
}")

;; 04/26/91 end rohit
;    
;
;(define_insn "ashlsi3"
;  [(set (match_operand:SI 0 "register_operand" "=r")
;	(ashift:SI (match_operand:SI 1 "register_operand" "r")
;		   (match_operand:SI 2 "immediate_operand" "n")))]
;  ""
;  "*
;{
;  if (GET_CODE (operands[2]) == CONST_INT
;      && INTVAL (operands[2]) >= 32)
;    return \"add %0,r0,r0\";
;  return \"sll %0,%1,%2\";
;}")
;
;(define_insn "ashrsi3"
;  [(set (match_operand:SI 0 "register_operand" "=r")
;	(ashiftrt:SI (match_operand:SI 1 "register_operand" "r")
;		     (match_operand:SI 2 "immediate_operand" "n")))]
;  ""
;  "*
;{
;  if (GET_CODE (operands[2]) == CONST_INT
;      && INTVAL (operands[2]) >= 32)
;    return \"sra %0,%1,\#31\";
;  return \"sra %0,%1,%2\";
;}")
;
;(define_insn "lshrsi3"
;  [(set (match_operand:SI 0 "register_operand" "=r")
;	(lshiftrt:SI (match_operand:SI 1 "register_operand" "r")
;		   (match_operand:SI 2 "immediate_operand" "n")))]
;  ""
;  "*
;{
;  if (GET_CODE (operands[2]) == CONST_INT
;      && INTVAL (operands[2]) >= 32)
;    return \"add %0,r0,r0\";
;  return \"srl %0,%1,%2\";
;}")


;; Unconditional and other jump instructions
(define_insn "jump"
  [(set (pc)
	(label_ref (match_operand 0 "" "")))]
  ""
  "j %l0\;nop")

;; Peephole optimizers recognize a few simple cases when delay insns are safe.
(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(match_operand:SI 1 "single_insn_src_p" "p"))
   (set (pc) (label_ref (match_operand 2 "" "")))]
  ""
  "* return output_delay_insn (\"j %l2\", operands, insn);")

(define_peephole
  [(set (match_operand:SI 0 "memory_operand" "=m")
	(match_operand:SI 1 "register_operand" "r"))
   (set (pc) (label_ref (match_operand 2 "" "")))]
  ""
  "* return output_delay_insn (\"j %l2\", operands, insn);")

(define_insn "tablejump"
  [(set (pc) (match_operand:SI 0 "register_operand" "r"))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "jr %0\;nop")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(match_operand:SI 1 "single_insn_src_p" "p"))
   (set (pc) (match_operand:SI 2 "register_operand" "r"))
   (use (label_ref (match_operand 3 "" "")))]
  "REGNO (operands[0]) != REGNO (operands[2])"
  "* return output_delay_insn (\"jr %2\", operands, insn);")

(define_peephole
  [(set (match_operand:SI 0 "memory_operand" "=m")
	(match_operand:SI 1 "register_operand" "r"))
   (set (pc) (match_operand:SI 2 "register_operand" "r"))
   (use (label_ref (match_operand 3 "" "")))]
  ""
  "* return output_delay_insn (\"jr %2\", operands, insn);")

;;- jump to subroutine

(define_expand "call"
  [(call (match_operand:SI 0 "memory_operand" "m")
	 (match_operand 1 "" "i"))]
  ;; operand[2] is next_arg_register
  ""
  "
{
  rtx fn_rtx, nregs_rtx;

  if (TARGET_SUN_ASM && GET_CODE (XEXP (operands[0], 0)) == REG)
    {
      rtx g1_rtx = gen_rtx (REG, SImode, 1);
      emit_move_insn (g1_rtx, XEXP (operands[0], 0));
      fn_rtx = gen_rtx (MEM, SImode, g1_rtx);
    }
  else
    fn_rtx = operands[0];

  /* Count the number of parameter registers being used by this call.
     if that argument is NULL, it means we are using them all, which
     means 6 on the sparc.  */
#if 0
  if (operands[2])
    nregs_rtx = gen_rtx (CONST_INT, VOIDmode, REGNO (operands[2]) - 8);
  else
    nregs_rtx = gen_rtx (CONST_INT, VOIDmode, 6);
#else
  nregs_rtx = const0_rtx;
#endif

  emit_call_insn (gen_rtx (PARALLEL, VOIDmode, gen_rtvec (2,
			   gen_rtx (CALL, VOIDmode, fn_rtx, nregs_rtx),
			   gen_rtx (USE, VOIDmode, gen_rtx (REG, SImode, 31)))));
  DONE;
}")

(define_insn ""
  [(call (match_operand:SI 0 "memory_operand" "m")
	 (match_operand 1 "" "i"))
   (use (reg:SI 31))]
  ;;- Don't use operand 1 for most machines.
  ""
  "*
{
  /* strip the MEM.  */
  operands[0] = XEXP (operands[0], 0);
  return \"jal %a0\;nop\";
}")

;(define_peephole
;  [(set (match_operand:SI 0 "register_operand" "=r")
;	(match_operand:SI 1 "single_insn_src_p" "p"))
;   (parallel [(call (match_operand:SI 2 "memory_operand" "m")
;		    (match_operand 3 "" "i"))
;	      (use (reg:SI 31))])]
;  ;;- Don't use operand 1 for most machines.
;  "! reg_mentioned_p (operands[0], operands[2])"
;  "*
;{
;  /* strip the MEM.  */
;  operands[2] = XEXP (operands[2], 0);
;  return output_delay_insn (\"jal %a2\", operands, insn);
;}")
;
;(define_peephole
;  [(set (match_operand:SI 0 "memory_operand" "=m")
;	(match_operand:SI 1 "register_operand" "r"))
;   (parallel [(call (match_operand:SI 2 "memory_operand" "m")
;		    (match_operand 3 "" "i"))
;	      (use (reg:SI 31))])]
;  ;;- Don't use operand 1 for most machines.
;  ""
;  "*
;{
;  /* strip the MEM.  */
;  operands[2] = XEXP (operands[2], 0);
;  return output_delay_insn (\"jal %a2\", operands, insn);
;}")
;
(define_expand "call_value"
  [(set (match_operand 0 "" "rf")
	(call (match_operand:SI 1 "memory_operand" "m")
  	      (match_operand 2 "" "i")))]
  ;; operand 3 is next_arg_register
  ""
  "
{
  rtx fn_rtx, nregs_rtx;
  rtvec vec;

  if (TARGET_SUN_ASM && GET_CODE (XEXP (operands[1], 0)) == REG)
    {
      rtx g1_rtx = gen_rtx (REG, SImode, 1);
      emit_move_insn (g1_rtx, XEXP (operands[1], 0));
      fn_rtx = gen_rtx (MEM, SImode, g1_rtx);
    }
  else
    fn_rtx = operands[1];

#if 0
  if (operands[3])
    nregs_rtx = gen_rtx (CONST_INT, VOIDmode, REGNO (operands[3]) - 8);
  else
    nregs_rtx = gen_rtx (CONST_INT, VOIDmode, 6);
#else
  nregs_rtx = const0_rtx;
#endif

  vec = gen_rtvec (2,
		   gen_rtx (SET, VOIDmode, operands[0],
			    gen_rtx (CALL, VOIDmode, fn_rtx, nregs_rtx)),
		   gen_rtx (USE, VOIDmode, gen_rtx (REG, SImode, 31)));

  emit_call_insn (gen_rtx (PARALLEL, VOIDmode, vec));
  DONE;
}")

(define_insn ""
  [(set (match_operand 0 "" "rf")
	(call (match_operand:SI 1 "memory_operand" "m")
	      (match_operand 2 "" "i")))
   (use (reg:SI 31))]
  ;;- Don't use operand 1 for most machines.
  ""
  "*
{
  /* strip the MEM.  */
  operands[1] = XEXP (operands[1], 0);
  return \"jal %a1\;nop\";
}")

;(define_peephole
;  [(set (match_operand:SI 0 "register_operand" "=r")
;	(match_operand:SI 1 "single_insn_src_p" "p"))
;   (parallel [(set (match_operand 2 "" "rf")
;		   (call (match_operand:SI 3 "memory_operand" "m")
;			 (match_operand 4 "" "i")))
;	      (use (reg:SI 31))])]
;  ;;- Don't use operand 1 for most machines.
;  "! reg_mentioned_p (operands[0], operands[3])"
;  "*
;{
;  /* strip the MEM.  */
;  operands[3] = XEXP (operands[3], 0);
;  return output_delay_insn (\"jal %a3\", operands, insn);
;}")
;
;(define_peephole
;  [(set (match_operand:SI 0 "memory_operand" "=m")
;	(match_operand:SI 1 "register_operand" "r"))
;   (parallel [(set (match_operand 2 "" "rf")
;		   (call (match_operand:SI 3 "memory_operand" "m")
;			 (match_operand 4 "" "i")))
;	      (use (reg:SI 31))])]
;  ;;- Don't use operand 1 for most machines.
;  ""
;  "*
;{
;  /* strip the MEM.  */
;  operands[3] = XEXP (operands[3], 0);
;  return output_delay_insn (\"jal %a3\", operands, insn);
;}")
;
;; A memory ref with constant address is not normally valid.
;; But it is valid in a call insns.  This pattern allows the
;; loading of the address to combine with the call.
(define_insn ""
  [(call (mem:SI (match_operand:SI 0 "" "i"))
	 (match_operand 1 "" "i"))
   (use (reg:SI 31))]
  "GET_CODE (operands[0]) == SYMBOL_REF"
  "jal %0\;nop")

;(define_peephole
;  [(set (match_operand:SI 0 "register_operand" "=r")
;	(match_operand:SI 1 "single_insn_src_p" "p"))
;   (parallel [(call (mem:SI (match_operand:SI 2 "" "i"))
;		    (match_operand 3 "" "i"))
;	      (use (reg:SI 31))])]
;  "GET_CODE (operands[2]) == SYMBOL_REF"
;  "* return output_delay_insn (\"jal %2\", operands, insn);")
;
;(define_peephole
;  [(set (match_operand:SI 0 "memory_operand" "=m")
;	(match_operand:SI 1 "register_operand" "r"))
;   (parallel [(call (mem:SI (match_operand:SI 2 "" "i"))
;		    (match_operand 3 "" "i"))
;	      (use (reg:SI 31))])]
;  "GET_CODE (operands[2]) == SYMBOL_REF"
;  "* return output_delay_insn (\"jal %2\", operands, insn);")

(define_insn ""
  [(set (match_operand 0 "" "rf")
	(call (mem:SI (match_operand:SI 1 "" "i"))
	      (match_operand 2 "" "i")))
   (use (reg:SI 31))]
  "GET_CODE (operands[1]) == SYMBOL_REF"
  "jal %1\;nop")

;(define_peephole
;  [(set (match_operand:SI 0 "register_operand" "=r")
;	(match_operand:SI 1 "single_insn_src_p" "p"))
;   (parallel [(set (match_operand 2 "" "rf")
;		   (call (mem:SI (match_operand:SI 3 "" "i"))
;			 (match_operand 4 "" "i")))
;	      (use (reg:SI 31))])]
;  "GET_CODE (operands[3]) == SYMBOL_REF"
;  "* return output_delay_insn (\"jal %3\", operands, insn);")
;
;(define_peephole
;  [(set (match_operand:SI 0 "memory_operand" "=m")
;	(match_operand:SI 1 "register_operand" "r"))
;   (parallel [(set (match_operand 2 "" "rf")
;		   (call (mem:SI (match_operand:SI 3 "" "i"))
;			 (match_operand 4 "" "i")))
;	      (use (reg:SI 31))])]
;  "GET_CODE (operands[3]) == SYMBOL_REF"
;  "* return output_delay_insn (\"jal %3\", operands, insn);")

;; DLX uses FUNCTION_EPILOGUE, so not needed.
(define_insn "return"
  [(return)]
  "! TARGET_EPILOGUE"
  "j r31")

(define_insn "nop"
  [(const_int 0)]
  ""
  "nop")
