/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.theme;

import java.awt.Color;
import org.jvnet.substance.color.NegatedColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.theme.SubstanceWrapperTheme;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceNegatedTheme
extends SubstanceWrapperTheme {
    public SubstanceNegatedTheme(SubstanceTheme substanceTheme) {
        super(substanceTheme, new NegatedColorScheme(substanceTheme.getColorScheme()), "Negated " + substanceTheme.getDisplayName(), SubstanceTheme.ThemeKind.NEGATED);
        this.originalTheme = substanceTheme;
    }

    public SubstanceTheme invert() {
        throw new UnsupportedOperationException("Inverting a negated theme is not supported");
    }

    public SubstanceTheme negate() {
        return this.originalTheme;
    }

    public Color getWatermarkStampColor() {
        return SubstanceCoreUtilities.isThemeDark(this) ? SubstanceColorUtilities.getAlphaColor(this.getColorScheme().getDarkColor(), 60) : SubstanceColorUtilities.getAlphaColor(this.getColorScheme().getUltraLightColor(), 25);
    }

    public SubstanceTheme saturate(double saturateFactor, boolean toSaturateEverything) {
        return this.originalTheme.saturate(saturateFactor, toSaturateEverything).negate();
    }

    public SubstanceTheme tint(double tintFactor) {
        return this.originalTheme.tint(tintFactor).negate();
    }

    public SubstanceTheme tone(double toneFactor) {
        return this.originalTheme.tone(toneFactor).negate();
    }

    public SubstanceTheme shade(double shadeFactor) {
        return this.originalTheme.shade(shadeFactor).negate();
    }

    public SubstanceTheme hueShift(double hueShiftFactor) {
        return this.originalTheme.hueShift(hueShiftFactor).negate();
    }

    public SubstanceTheme getDefaultTheme() {
        if (this.defaultTheme == null) {
            this.defaultTheme = this.originalTheme.getDefaultTheme().negate();
        }
        return this.defaultTheme;
    }

    public SubstanceTheme getDisabledTheme() {
        if (this.disabledTheme == null) {
            this.disabledTheme = this.originalTheme.getDisabledTheme().negate();
        }
        return this.disabledTheme;
    }
}

