/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.scroll;

import java.awt.ComponentOrientation;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JScrollBar;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.scroll.ScrollThumbGripPainter;
import org.jvnet.substance.theme.SubstanceTheme;

public class CoreScrollThumbGripPainters {

    public static class DragBumpsScrollThumbGripPainter
    implements ScrollThumbGripPainter {
        public void painScrollThumbGrip(JScrollBar scrollBar, Graphics2D graphics, SubstanceTheme theme, Rectangle scrollThumbArea, boolean isScrollBarVertical, ComponentOrientation scrollBarOrientation) {
            if (isScrollBarVertical) {
                int thumbHeight = scrollThumbArea.height;
                if (thumbHeight < 30) {
                    return;
                }
                int gripHeight = thumbHeight / 4;
                if (gripHeight > 40) {
                    gripHeight = 40;
                }
                int thumbWidth = scrollThumbArea.width;
                int gripWidth = thumbWidth * 2 / 3;
                int gripX = scrollThumbArea.x + (thumbWidth - gripWidth) / 2;
                int gripY = scrollThumbArea.y + (thumbHeight - gripHeight) / 2;
                graphics.drawImage((Image)SubstanceImageCreator.getDragImage(theme, true, gripWidth, gripHeight, true), gripX, gripY, null);
            } else {
                int thumbWidth = scrollThumbArea.width;
                if (thumbWidth < 30) {
                    return;
                }
                int gripWidth = thumbWidth / 4;
                if (gripWidth > 40) {
                    gripWidth = 40;
                }
                int thumbHeight = scrollThumbArea.height;
                int gripHeight = thumbHeight * 2 / 3;
                int gripX = scrollThumbArea.x + (thumbWidth - gripWidth) / 2;
                int gripY = 1 + scrollThumbArea.y + (thumbHeight - gripHeight) / 2;
                graphics.drawImage((Image)SubstanceImageCreator.getRotated(SubstanceImageCreator.getDragImage(theme, true, gripHeight, gripWidth, true), 3), gripX, gripY, null);
            }
        }
    }
}

