/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceFileChooserUI
extends MetalFileChooserUI {
    private final SubstanceFileView fileView = new SubstanceFileView();

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceFileChooserUI((JFileChooser)c);
    }

    public SubstanceFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    private class SubstanceFileView
    extends BasicFileChooserUI.BasicFileView {
        private final Map<String, Icon> pathIconCache;

        private SubstanceFileView() {
            super(SubstanceFileChooserUI.this);
            this.pathIconCache = new HashMap<String, Icon>();
        }

        public Icon getCachedIcon(File f) {
            return this.pathIconCache.get(f.getPath());
        }

        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            icon = this.getDefaultIcon(f);
            if (icon == null && (icon = super.getIcon(f)) == null) {
                icon = new ImageIcon(SubstanceCoreUtilities.getBlankImage(8, 8));
            }
            this.cacheIcon(f, icon);
            return icon;
        }

        public void cacheIcon(File f, Icon icon) {
            this.pathIconCache.put(f.getPath(), icon);
        }

        public void clearIconCache() {
            this.pathIconCache.clear();
        }

        public Icon getDefaultIcon(File f) {
            Icon icon = SubstanceFileChooserUI.this.getFileChooser().getFileSystemView().getSystemIcon(f);
            return icon;
        }
    }
}

