/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.list;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public abstract class AbstractComponentDecorator {
    public static final int TOP = 0;
    private static final int BOTTOM = -1;
    private Point originOffset = new Point(0, 0);
    private Painter painter;
    private JComponent component;
    private Container parent;
    private Listener listener;
    private int layerOffset;
    private int position;
    private Rectangle bounds;
    private static Field nComponents;

    public AbstractComponentDecorator(JComponent c) {
        this(c, 1);
    }

    public AbstractComponentDecorator(JComponent c, int layerOffset) {
        this(c, layerOffset, 0);
    }

    public AbstractComponentDecorator(JComponent c, int layerOffset, int position) {
        this.component = c;
        this.layerOffset = layerOffset;
        this.position = position;
        this.bounds = null;
        this.parent = c.getParent();
        this.painter = new Painter();
        this.listener = new Listener();
        this.component.addHierarchyListener(this.listener);
        this.component.addComponentListener(this.listener);
        this.component.addPropertyChangeListener(this.listener);
        this.attach();
    }

    public void setToolTipText(String text) {
        this.painter.setToolTipText(text);
    }

    public String getToolTipText() {
        return this.painter.getToolTipText();
    }

    public String getToolTipText(MouseEvent e) {
        return this.getToolTipText();
    }

    public void setVisible(boolean visible) {
        this.painter.setVisible(visible);
    }

    protected void attach() {
        Window w = SwingUtilities.getWindowAncestor(this.component);
        if (w instanceof RootPaneContainer) {
            JLayeredPane lp = ((RootPaneContainer)((Object)w)).getLayeredPane();
            Container layeredChild = this.component;
            int layer = JLayeredPane.DRAG_LAYER;
            if (this instanceof BackgroundPainter) {
                layer = ((BackgroundPainter)this).layer;
                this.painter.setDecoratedLayer(layer);
            } else if (layeredChild == lp) {
                this.painter.setDecoratedLayer(layer);
            } else {
                BackgroundPainter bp;
                while (layeredChild.getParent() != lp) {
                    layeredChild = layeredChild.getParent();
                }
                int base = lp.getLayer(layeredChild);
                layer = base + this.layerOffset;
                if (this.layerOffset < 0 && (bp = (BackgroundPainter)lp.getClientProperty(BackgroundPainter.key(base))) == null) {
                    bp = new BackgroundPainter(lp, base);
                }
                this.painter.setDecoratedLayer(base);
            }
            lp.add(this.painter, new Integer(layer), this.position);
        } else {
            Container parent = this.painter.getParent();
            if (parent != null) {
                parent.remove(this.painter);
            }
        }
        if (this.parent != null) {
            this.parent.removeComponentListener(this.listener);
        }
        this.parent = this.component.getParent();
        if (this.parent != null) {
            this.parent.addComponentListener(this.listener);
        }
        this.synch();
    }

    protected void synch() {
        Container painterParent = this.painter.getParent();
        if (painterParent != null) {
            Rectangle visible = this.getVisibleRect(this.getComponent());
            Rectangle decorated = this.getDecorationBounds();
            this.originOffset.x = decorated.x;
            this.originOffset.y = decorated.y;
            Rectangle clipped = decorated.intersection(visible);
            if (decorated.x < visible.x) {
                this.originOffset.x += visible.x - decorated.x;
            }
            if (decorated.y < visible.y) {
                this.originOffset.y += visible.y - decorated.y;
            }
            Point pt = SwingUtilities.convertPoint(this.component, clipped.x, clipped.y, painterParent);
            if (clipped.width <= 0 || clipped.height <= 0) {
                this.setVisible(false);
            } else {
                this.setPainterBounds(pt.x, pt.y, clipped.width, clipped.height);
                this.setVisible(true);
            }
        }
        this.painter.revalidate();
        this.painter.repaint();
    }

    private Rectangle getVisibleRect(JComponent component) {
        Rectangle visible = component.getVisibleRect();
        if (visible.x != 0 || visible.y != 0 || visible.width != component.getWidth() || visible.height != component.getHeight()) {
            return visible;
        }
        Container parent = component.getParent();
        if (parent instanceof JComponent) {
            visible = ((JComponent)parent).getVisibleRect();
            visible.x -= component.getX();
            visible.y -= component.getY();
        }
        return visible;
    }

    public void setDecorationBounds(int x, int y, int w, int h) {
        if (this.bounds == null) {
            this.bounds = new Rectangle(x, y, w, h);
        } else {
            this.bounds.setBounds(x, y, w, h);
        }
        this.synch();
    }

    public void setDecorationBounds(Rectangle bounds) {
        if (this.bounds == null) {
            this.bounds = bounds;
        } else {
            this.bounds.setBounds(bounds);
        }
        this.synch();
    }

    protected Rectangle getDecorationBounds() {
        if (this.bounds == null) {
            return new Rectangle(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
        }
        return this.bounds;
    }

    private void setPainterBounds(int x, int y, int w, int h) {
        this.painter.setLocation(x, y);
        this.painter.setSize(w, h);
        this.repaint();
    }

    protected JComponent getComponent() {
        return this.component;
    }

    protected JComponent getPainter() {
        return this.painter;
    }

    public void repaint() {
        this.component.repaint();
        this.painter.repaint();
    }

    public void dispose() {
        Container painterParent;
        this.component.removeHierarchyListener(this.listener);
        this.component.removeComponentListener(this.listener);
        this.component.removePropertyChangeListener(this.listener);
        if (this.parent != null) {
            this.parent.removeComponentListener(this.listener);
        }
        if ((painterParent = this.painter.getParent()) != null) {
            Rectangle bounds = this.painter.getBounds();
            painterParent.remove(this.painter);
            painterParent.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        this.component.repaint();
        this.component = null;
    }

    public abstract void paint(Graphics var1);

    public String toString() {
        return super.toString() + " on " + this.getComponent();
    }

    private static boolean useSimpleBackground() {
        return nComponents == null;
    }

    static {
        try {
            nComponents = Container.class.getDeclaredField("ncomponents");
            nComponents.setAccessible(true);
        }
        catch (Exception e) {
            nComponents = null;
        }
    }

    private final class Listener
    extends ComponentAdapter
    implements HierarchyListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 1L) != 0L) {
                AbstractComponentDecorator.this.attach();
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            if ("layeredContainerLayer".equals(e.getPropertyName())) {
                AbstractComponentDecorator.this.attach();
            }
        }

        public void componentMoved(ComponentEvent e) {
            AbstractComponentDecorator.this.attach();
        }

        public void componentResized(ComponentEvent e) {
            AbstractComponentDecorator.this.attach();
        }

        public void componentHidden(ComponentEvent e) {
            AbstractComponentDecorator.this.setVisible(false);
        }

        public void componentShown(ComponentEvent e) {
            AbstractComponentDecorator.this.setVisible(true);
        }
    }

    private static class BackgroundPainter
    extends AbstractComponentDecorator {
        private String key;
        private int layer;

        private static String key(int layer) {
            return "backgroundPainter" + layer;
        }

        public BackgroundPainter(JLayeredPane p, int layer) {
            super(p, 0, 0);
            this.layer = layer;
            this.key = BackgroundPainter.key(layer);
            p.putClientProperty(this.key, this);
        }

        private int hideChildren(Container c) {
            if (c == null) {
                return 0;
            }
            int value = c.getComponentCount();
            try {
                nComponents.set(c, new Integer(0));
            }
            catch (Exception e) {
                return c.getComponentCount();
            }
            return value;
        }

        private void restoreChildren(Container c, int count) {
            if (c != null) {
                try {
                    nComponents.set(c, new Integer(count));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void paintBackground(Graphics g, Component parent, JComponent jc) {
            int x = jc.getX();
            int y = jc.getY();
            int w = jc.getWidth();
            int h = jc.getHeight();
            this.paintBackground(g.create(x, y, w, h), jc);
        }

        private void paintBackground(Graphics g, JComponent jc) {
            if (jc.isOpaque()) {
                if (AbstractComponentDecorator.useSimpleBackground()) {
                    g.setColor(jc.getBackground());
                    g.fillRect(0, 0, jc.getWidth(), jc.getHeight());
                } else {
                    int count = this.hideChildren(jc);
                    boolean db = jc.isDoubleBuffered();
                    if (db) {
                        jc.setDoubleBuffered(false);
                    }
                    jc.paint(g);
                    if (db) {
                        jc.setDoubleBuffered(true);
                    }
                    this.restoreChildren(jc, count);
                }
            }
            Component[] kids = jc.getComponents();
            for (int i = 0; i < kids.length; ++i) {
                if (!(kids[i] instanceof JComponent)) continue;
                this.paintBackground(g, jc, (JComponent)kids[i]);
            }
        }

        private List findOpaque(Component root) {
            ArrayList<Component> list = new ArrayList<Component>();
            if (root.isOpaque() && root instanceof JComponent) {
                list.add(root);
                ((JComponent)root).setOpaque(false);
            }
            if (root instanceof Container) {
                Component[] kids = ((Container)root).getComponents();
                for (int i = 0; i < kids.length; ++i) {
                    list.addAll(this.findOpaque(kids[i]));
                }
            }
            return list;
        }

        private List findDoubleBuffered(Component root) {
            ArrayList<Component> list = new ArrayList<Component>();
            if (root.isDoubleBuffered() && root instanceof JComponent) {
                list.add(root);
                ((JComponent)root).setDoubleBuffered(false);
            }
            if (root instanceof Container) {
                Component[] kids = ((Container)root).getComponents();
                for (int i = 0; i < kids.length; ++i) {
                    list.addAll(this.findDoubleBuffered(kids[i]));
                }
            }
            return list;
        }

        private void paintForeground(Graphics g, JComponent jc) {
            List opaque = this.findOpaque(jc);
            List db = this.findDoubleBuffered(jc);
            jc.paint(g);
            Iterator i = opaque.iterator();
            while (i.hasNext()) {
                ((JComponent)i.next()).setOpaque(true);
            }
            i = db.iterator();
            while (i.hasNext()) {
                ((JComponent)i.next()).setDoubleBuffered(true);
            }
        }

        public void paint(Graphics g) {
            JLayeredPane lp = (JLayeredPane)this.getComponent();
            Component[] kids = lp.getComponents();
            Area area = new Area();
            ArrayList<Painter> painters = new ArrayList<Painter>();
            ArrayList<Component> components = new ArrayList<Component>();
            for (int i = kids.length - 1; i >= 0; --i) {
                if (kids[i] instanceof Painter) {
                    Painter painter = (Painter)kids[i];
                    if (!painter.isBackgroundDecoration() || painter.getDecoratedLayer() != this.layer || !painter.isShowing()) continue;
                    painters.add(painter);
                    area.add(new Area(painter.getBounds()));
                    continue;
                }
                if (lp.getLayer(kids[i]) != this.layer || !(kids[i] instanceof JComponent)) continue;
                components.add(kids[i]);
            }
            if (painters.size() == 0) {
                this.dispose();
                return;
            }
            g.setClip(area);
            for (JComponent jComponent : components) {
                this.paintBackground(g, lp, jComponent);
            }
            for (Painter painter : painters) {
                painter.paint(g.create(painter.getX(), painter.getY(), painter.getWidth(), painter.getHeight()));
            }
            for (JComponent jComponent : components) {
                this.paintForeground(g.create(jComponent.getX(), jComponent.getY(), jComponent.getWidth(), jComponent.getHeight()), jComponent);
            }
        }

        public void dispose() {
            this.getComponent().putClientProperty(this.key, null);
            super.dispose();
        }

        public String toString() {
            return this.key + " on " + this.getComponent();
        }
    }

    private class Painter
    extends JComponent {
        private int base;

        private Painter() {
        }

        public JComponent getComponent() {
            return AbstractComponentDecorator.this.getComponent();
        }

        public void setDecoratedLayer(int base) {
            this.base = base;
        }

        public int getDecoratedLayer() {
            return this.base;
        }

        public boolean isBackgroundDecoration() {
            return AbstractComponentDecorator.this.layerOffset < 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g) {
            if (!AbstractComponentDecorator.this.component.isShowing()) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform xform = g2d.getTransform();
            try {
                g2d.translate(-((AbstractComponentDecorator)AbstractComponentDecorator.this).originOffset.x, -((AbstractComponentDecorator)AbstractComponentDecorator.this).originOffset.y);
                AbstractComponentDecorator.this.paint(g);
            }
            finally {
                g2d.setTransform(xform);
            }
        }

        public String getToolTipText(MouseEvent e) {
            return AbstractComponentDecorator.this.getToolTipText(e);
        }

        public String toString() {
            return "Painter for " + AbstractComponentDecorator.this;
        }
    }
}

