/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.ruby;

import org.graalvm.visualvm.heapviewer.truffle.TruffleLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyNodes;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyType;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.openide.util.Lookup;

public class RubyLanguage
extends TruffleLanguage<RubyObject, RubyType, RubyHeapFragment> {
    private static final String ID = "ruby";
    private static final String RUBY_LANGINFO_ID = "Ruby";
    private static RubyLanguage INSTANCE;

    static synchronized RubyLanguage instance() {
        if (INSTANCE == null) {
            Lookup.getDefault().lookup(RubyLanguage.class);
        }
        return INSTANCE;
    }

    public RubyLanguage() {
        INSTANCE = this;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    protected RubyHeapFragment createFragment(Heap heap) {
        Instance langID = RubyLanguage.getLanguageInfo(heap, RUBY_LANGINFO_ID);
        if (langID == null) {
            return null;
        }
        JavaClass rubyMainClass = heap.getJavaClassByName("org.truffleruby.language.objects.RubyObjectType");
        if (rubyMainClass == null && (rubyMainClass = heap.getJavaClassByName("org.truffleruby.interop.RubyObjectType")) == null && (rubyMainClass = heap.getJavaClassByName("org.truffleruby.language.RubyObjectType")) == null) {
            return null;
        }
        return new RubyHeapFragment(this, rubyMainClass, langID, heap);
    }

    @Override
    public Class<RubyObject> getLanguageObjectClass() {
        return RubyObject.class;
    }

    @Override
    public boolean isLanguageObject(Instance instance) {
        return RubyObject.isRubyObject(instance);
    }

    @Override
    public RubyObject createObject(Instance instance) {
        return new RubyObject(instance);
    }

    @Override
    public RubyType createType(String name) {
        return new RubyType(name);
    }

    public RubyNodes.RubyObjectNode createObjectNode(RubyObject object, String type) {
        return new RubyNodes.RubyObjectNode(object, type);
    }

    public RubyNodes.RubyLocalObjectNode createLocalObjectNode(RubyObject object, String type) {
        return new RubyNodes.RubyLocalObjectNode(object, type);
    }

    public RubyNodes.RubyTypeNode createTypeNode(RubyType type, Heap heap) {
        return new RubyNodes.RubyTypeNode(type);
    }
}

