/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java;

import java.awt.Color;
import java.util.Objects;
import javax.swing.Icon;
import org.graalvm.visualvm.heapviewer.java.ThreadNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;

public class ThreadNodeRenderer
extends LabelRenderer
implements HeapViewerRenderer {
    private static final Icon ICON = Icons.getIcon((String)"ProfilerIcons.Thread");
    protected final Heap heap;
    private Color customForeground;

    public ThreadNodeRenderer(Heap heap) {
        this.heap = heap;
        this.setIcon(ICON);
        this.setFont(this.getFont().deriveFont(1));
    }

    public void setValue(Object value, int row) {
        ThreadNode node = (ThreadNode)((Object)value);
        this.setText(node.getName());
        this.setCustomForeground(node.isOOMEThread() ? Color.RED : null);
    }

    @Override
    public String getShortName() {
        String name = this.getText();
        int nameIdx = name.indexOf(34) + 1;
        if (nameIdx > 0) {
            name = name.substring(nameIdx, name.indexOf(34, nameIdx));
        }
        return name;
    }

    public void setForeground(Color foreground) {
        if (this.customForeground != null && Objects.equals(foreground, UIUtils.getDefaultTableForeground())) {
            super.setForeground(this.customForeground);
        } else {
            super.setForeground(foreground);
        }
    }

    private void setCustomForeground(Color foreground) {
        this.customForeground = foreground;
    }
}

