/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.monitor.profile;

import java.util.Objects;
import java.util.function.Supplier;
import org.opensearch.sql.monitor.profile.DefaultProfileContext;
import org.opensearch.sql.monitor.profile.NoopProfileContext;
import org.opensearch.sql.monitor.profile.ProfileContext;

public final class QueryProfiling {
    private static final ThreadLocal<ProfileContext> CURRENT = new ThreadLocal();

    private QueryProfiling() {
    }

    public static ProfileContext current() {
        ProfileContext ctx = CURRENT.get();
        return ctx == null ? NoopProfileContext.INSTANCE : ctx;
    }

    public static ProfileContext noop() {
        return QueryProfiling.activate(false);
    }

    public static ProfileContext activate(boolean profilingEnabled) {
        if (profilingEnabled) {
            CURRENT.set(new DefaultProfileContext());
        } else {
            CURRENT.set(NoopProfileContext.INSTANCE);
        }
        return CURRENT.get();
    }

    public static void clear() {
        CURRENT.remove();
    }

    public static <T> T withCurrentContext(ProfileContext ctx, Supplier<T> action) {
        CURRENT.set(Objects.requireNonNull(ctx, "ctx"));
        try {
            T t = action.get();
            return t;
        }
        finally {
            QueryProfiling.clear();
        }
    }
}

