import { type StyledChar } from '@alcalzone/ansi-tokenize';
import { type OutputTransformer } from './render-node-to-output.js';
/**
"Virtual" output class

Handles the positioning and saving of the output of each node in the tree. Also responsible for applying transformations to each character of the output.

Used to generate the final output of all nodes before writing it to actual output stream (e.g. stdout)
*/
type Options = {
    width: number;
    height: number;
};
type Clip = {
    x1: number | undefined;
    x2: number | undefined;
    y1: number | undefined;
    y2: number | undefined;
};
export default class Output {
    width: number;
    height: number;
    private readonly operations;
    private cursorFocusInfo;
    private readonly clips;
    constructor(options: Options);
    getCurrentClip(): Clip | undefined;
    write(x: number, y: number, items: string | StyledChar[], options: {
        transformers: OutputTransformer[];
        lineIndex?: number;
        preserveBackgroundColor?: boolean;
        isTerminalCursorFocused?: boolean;
        terminalCursorPosition?: number;
    }): void;
    clip(clip: Clip): void;
    unclip(): void;
    get(): {
        output: string;
        height: number;
        styledOutput: StyledChar[][];
        cursorPosition?: {
            row: number;
            col: number;
        };
    };
    private clearRange;
    private applyWriteOperation;
    private clipChars;
}
export {};
