/**
 * https://github.com/SiliconLabs/gecko_sdk/blob/gsdk_4.4/app/zcl/manufacturers.xml
 */
export enum ManufacturerCode {
    MATTER_STANDARD = 0x0000,
    PANASONIC = 0x0001,
    SONY = 0x0002,
    SAMSUNG = 0x0003,
    PHILIPS_RF4CE = 0x0004,
    FREESCALE_RF4CE = 0x0005,
    OKI_SEMICONDUCTORS_RF4CE = 0x0006,
    TEXAS_INSTRUMENTS = 0x0007,
    CIRRONET = 0x1000,
    CHIPCON = 0x1001,
    EMBER = 0x1002,
    NTS = 0x1003,
    FREESCALE = 0x1004,
    IP_COM = 0x1005,
    SAN_JUAN_SOFTWARE = 0x1006,
    TUV = 0x1007,
    INTEGRATION = 0x1008,
    BM_SPA = 0x1009,
    AWAREPOINT = 0x100a,
    SIGNIFY_NETHERLANDS_B_V = 0x100b,
    LUXOFT = 0x100c,
    KORWIN = 0x100d,
    ONE_RF_TECHNOLOGY = 0x100e,
    SOFTWARE_TECHNOLOGIES_GROUP = 0x100f,
    TELEGESIS = 0x1010,
    VISONIC = 0x1011,
    INSTA = 0x1012,
    ATALUM = 0x1013,
    ATMEL = 0x1014,
    DEVELCO = 0x1015,
    HONEYWELL = 0x1016,
    RADIOPULSE = 0x1017,
    RENESAS = 0x1018,
    XANADU_WIRELESS = 0x1019,
    NEC_ENGINEERING = 0x101a,
    YAMATAKE_CORPORATION = 0x101b,
    TENDRIL_NETWORKS = 0x101c,
    ASSA_ABLOY = 0x101d,
    MAXSTREAM = 0x101e,
    NEUROCOM = 0x101f,
    INSTITUTE_FOR_INFORMATION_INDUSTRY = 0x1020,
    LEGRAND_GROUP = 0x1021,
    ICONTROL = 0x1022,
    RAYMARINE = 0x1023,
    LS_RESEARCH = 0x1024,
    ONITY_INC = 0x1025,
    MONO_PRODUCTS = 0x1026,
    RF_TECHNOLOGIES = 0x1027,
    ITRON = 0x1028,
    TRITECH = 0x1029,
    EMBEDIT_A_S = 0x102a,
    S3C = 0x102b,
    SIEMENS = 0x102c,
    MINDTECH = 0x102d,
    LG_ELECTRONICS = 0x102e,
    MITSUBISHI_ELECTRIC_CORP = 0x102f,
    JOHNSON_CONTROLS = 0x1030,
    SECURE_METERS_UK_LTD = 0x1031,
    KNICK = 0x1032,
    VICONICS = 0x1033,
    FLEXIPANEL = 0x1034,
    PIASIM_CORPORATION_PTE_LTD = 0x1035,
    TRANE = 0x1036,
    NXP_SEMICONDUCTORS = 0x1037,
    LIVING_INDEPENDENTLY_GROUP = 0x1038,
    ALERTME_COM = 0x1039,
    DAINTREE = 0x103a,
    AIJI_SYSTEM = 0x103b,
    TELECOM_ITALIA = 0x103c,
    MIKROKRETS_AS = 0x103d,
    OKI_SEMICONDUCTOR = 0x103e,
    NEWPORT_ELECTONICS = 0x103f,
    CONTROL_4 = 0x1040,
    STMICROELECTRONICS = 0x1041,
    AD_SOL_NISSIN_CORP = 0x1042,
    DCSI = 0x1043,
    FRANCE_TELECOM = 0x1044,
    MUNET = 0x1045,
    AUTANI_CORPORATION = 0x1046,
    COLORADO_VNET = 0x1047,
    AEROCOMM_INC = 0x1048,
    SILICON_LABORATORIES = 0x1049,
    INNCOM_INTERNATIONAL_INC = 0x104a,
    COOPER_POWER_SYSTEMS = 0x104b,
    SYNAPSE = 0x104c,
    FISHER_PIERCE_SUNRISE = 0x104d,
    CENTRALITE_SYSTEMS_INC = 0x104e,
    CRANE_WIRELESS_MONITORING_SOLUTIONS = 0x104f,
    MOBILARM_LIMITED = 0x1050,
    IMONITOR_RESEARCH_LTD = 0x1051,
    BARTECH = 0x1052,
    MESHNETICS = 0x1053,
    LS_INDUSTRIAL_SYSTEMS_CO_LTD = 0x1054,
    CASON_ENGINEERING_PLC = 0x1055,
    WIRELESS_GLUE_NETWORKS_INC = 0x1056,
    ELSTER = 0x1057,
    SMS_TECNOLOGIA_ELETRONICA = 0x1058,
    ONSET_COMPUTER_CORPORATION = 0x1059,
    RIGA_DEVELOPMENT = 0x105a,
    ENERGATE = 0x105b,
    CONMED_LINVATEC = 0x105c,
    POWERMAND = 0x105d,
    SCHNEIDER_ELECTRIC = 0x105e,
    EATON_CORPORATION = 0x105f,
    TELULAR_CORPORATION = 0x1060,
    DELPHI_MEDICAL_SYSTEMS = 0x1061,
    EPISENSOR_LIMITED = 0x1062,
    LANDIS_GYR = 0x1063,
    KABA_GROUP = 0x1064,
    SHURE_INCORPORATED = 0x1065,
    COMVERGE_INC = 0x1066,
    DBS_LODGING_TECHNOLOGIES_LLC = 0x1067,
    ENERGY_AWARE_TECHNOLOGY_INC = 0x1068,
    HIDALGO_LIMITED = 0x1069,
    AIR2APP = 0x106a,
    AMX = 0x106b,
    EDMI_PTY_LTD = 0x106c,
    CYAN_LTD = 0x106d,
    SYSTEM_SPA = 0x106e,
    TELIT = 0x106f,
    KAGA_ELECTRONICS = 0x1070,
    ASTREL_GROUP_SRL = 0x1071,
    CERTICOM = 0x1072,
    GRIDPOINT = 0x1073,
    PROFILE_SYSTEMS_LLC = 0x1074,
    COMPACTA_INTERNATIONAL_LTD = 0x1075,
    FREESTYLE_TECHNOLOGY_PTY_LTD = 0x1076,
    ALEKTRONA = 0x1077,
    COMPUTIME = 0x1078,
    REMOTE_TECHNOLOGIES_INC = 0x1079,
    WAVECOM_S_A = 0x107a,
    ENERGY_OPTIMIZERS_LTD = 0x107b,
    GE = 0x107c,
    JETLUN = 0x107d,
    CIPHER_SYSTEMS = 0x107e,
    CORPORATE_SYSTEMS_ENGINEERING = 0x107f,
    ECOBEE = 0x1080,
    SMK = 0x1081,
    MESHWORKS_WIRELESS_OY = 0x1082,
    ELLIPS_B_V = 0x1083,
    SECURE_ELECTRANS = 0x1084,
    CEDO = 0x1085,
    TOSHIBA = 0x1086,
    DIGI_INTERNATIONAL = 0x1087,
    UBILOGIX = 0x1088,
    ECHELON = 0x1089,
    GREEN_ENERGY_OPTIONS = 0x1090,
    SILVER_SPRING_NETWORKS = 0x1091,
    BLACK_AND_DECKER = 0x1092,
    AZTECH_ASSOCIATES_INC = 0x1093,
    AANDD_CO_LTD = 0x1094,
    RAINFOREST_AUTOMATION = 0x1095,
    CARRIER_ELECTRONICS = 0x1096,
    SYCHIP_MURATA = 0x1097,
    OPENPEAK = 0x1098,
    PASSIVESYSTEMS = 0x1099,
    MMB_RESEARCH = 0x109a,
    LEVITON_MANUFACTURING_COMPANY = 0x109b,
    KOREA_ELECTRIC_POWER_DATA_NETWORK_CO_LTD = 0x109c,
    COMCAST = 0x109d,
    NEC_ELECTRONICS = 0x109e,
    NETVOX = 0x109f,
    U_CONTROL = 0x10a0,
    EMBEDIA_TECHNOLOGIES_CORP = 0x10a1,
    SENSUS = 0x10a2,
    SUNRISE_TECHNOLOGIES = 0x10a3,
    MEMTECH_CORP = 0x10a4,
    FREEBOX = 0x10a5,
    M2_LABS_LTD = 0x10a6,
    BRITISH_GAS = 0x10a7,
    SENTEC_LTD = 0x10a8,
    NAVETAS = 0x10a9,
    LIGHTSPEED_TECHNOLOGIES = 0x10aa,
    OKI_ELECTRIC_INDUSTRY_CO_LTD = 0x10ab,
    S_I_SISTEMAS_INTELIGENTES_ELETRONICOS_LTDA = 0x10ac,
    DOMETIC = 0x10ad,
    ALPS = 0x10ae,
    ENERGYHUB = 0x10af,
    KAMSTRUP = 0x10b0,
    ECHOSTAR = 0x10b1,
    ENERNOC = 0x10b2,
    ELTAV = 0x10b3,
    BELKIN = 0x10b4,
    XSTREAMHD_WIRELESS_VENTURES = 0x10b5,
    SATURN_SOUTH_PTY_LTD = 0x10b6,
    GREENTRAPONLINE_A_S = 0x10b7,
    SMARTSYNCH_INC = 0x10b8,
    NYCE_CONTROL_INC = 0x10b9,
    ICM_CONTROLS_CORP = 0x10ba,
    MILLENNIUM_ELECTRONICS_PTY_LTD = 0x10bb,
    MOTOROLA_INC = 0x10bc,
    EMERSON_WHITE_RODGERS = 0x10bd,
    RADIO_THERMOSTAT_COMPANY_OF_AMERICA = 0x10be,
    OMRON_CORPORATION = 0x10bf,
    GIINII_GLOBAL_LIMITED = 0x10c0,
    FUJITSU_GENERAL_LIMITED = 0x10c1,
    PEEL_TECHNOLOGIES_INC = 0x10c2,
    ACCENT_S_P_A = 0x10c3,
    BYTESNAP_DESIGN_LTD = 0x10c4,
    NEC_TOKIN_CORPORATION = 0x10c5,
    G4S_JUSTICE_SERVICES = 0x10c6,
    TRILLIANT_NETWORKS_INC = 0x10c7,
    ELECTROLUX_ITALIA_S_P_A = 0x10c8,
    ONZO_LTD = 0x10c9,
    ENTEK_SYSTEMS = 0x10ca,
    PHILIPS = 0x10cb,
    MAINSTREAM_ENGINEERING = 0x10cc,
    INDESIT_COMPANY = 0x10cd,
    THINKECO_INC = 0x10ce,
    TWODTWOC_INC = 0x10cf,
    QORVO = 0x10d0,
    INTERCEL = 0x10d1,
    LG_ELECTRONICS_2 = 0x10d2,
    MITSUMI_ELECTRIC_CO_LTD = 0x10d3,
    MITSUMI_ELECTRIC_CO_LTD_2 = 0x10d4,
    ZENTRUM_MIKROELEKTRONIK_DRESDEN_AG_ZMDI = 0x10d5,
    NEST_LABS_INC = 0x10d6,
    EXEGIN_TECHNOLOGIES_LTD = 0x10d7,
    HONEYWELL_2 = 0x10d8,
    TAKAHATA_PRECISION_CO_LTD = 0x10d9,
    SUMITOMO_ELECTRIC_NETWORKS_INC = 0x10da,
    GE_ENERGY = 0x10db,
    GE_APPLIANCES = 0x10dc,
    RADIOCRAFTS_AS = 0x10dd,
    CEIVA = 0x10de,
    TECANDCO_CO_LTD = 0x10df,
    CHAMELEON_TECHNOLOGY_UK_LTD = 0x10e0,
    SAMSUNG_2 = 0x10e1,
    RUWIDO_AUSTRIA_GMBH = 0x10e2,
    HUAWEI_TECHNOLOGIES_CO_LTD = 0x10e3,
    HUAWEI_TECHNOLOGIES_CO_LTD_2 = 0x10e4,
    GREENWAVE_REALITY = 0x10e5,
    BGLOBAL_METERING_LTD = 0x10e6,
    MINDTECK = 0x10e7,
    INGERSOLL_RAND = 0x10e8,
    DIUS_COMPUTING_PTY_LTD = 0x10e9,
    EMBEDDED_AUTOMATION_INC = 0x10ea,
    ABB = 0x10eb,
    SONY_2 = 0x10ec,
    GENUS_POWER_INFRASTRUCTURES_LIMITED = 0x10ed,
    UNIVERSAL_ELECTRONICS_INC = 0x10ee,
    UNIVERSAL_ELECTRONICS_INC_2 = 0x10ef,
    METRUM_TECHNOLOGIES_LLC = 0x10f0,
    CISCO = 0x10f1,
    UBISYS_TECHNOLOGIES_GMBH = 0x10f2,
    CONSERT = 0x10f3,
    CRESTRON_ELECTRONICS = 0x10f4,
    ENPHASE_ENERGY = 0x10f5,
    INVENSYS_CONTROLS = 0x10f6,
    MUELLER_SYSTEMS_LLC = 0x10f7,
    AAC_TECHNOLOGIES_HOLDING = 0x10f8,
    U_NEXT_CO_LTD = 0x10f9,
    STEELCASE_INC = 0x10fa,
    TELEMATICS_WIRELESS = 0x10fb,
    SAMIL_POWER_CO_LTD = 0x10fc,
    PACE_PLC = 0x10fd,
    OSBORNE_COINAGE_CO = 0x10fe,
    POWERWATCH = 0x10ff,
    CANDELED_GMBH = 0x1100,
    FLEXGRID_S_R_L = 0x1101,
    HUMAX = 0x1102,
    UNIVERSAL_DEVICES = 0x1103,
    ADVANCED_ENERGY = 0x1104,
    BEGA_GANTENBRINK_LEUCHTEN = 0x1105,
    BRUNEL_UNIVERSITY = 0x1106,
    PANASONIC_RANDD_CENTER_SINGAPORE = 0x1107,
    ESYSTEMS_RESEARCH = 0x1108,
    PANAMAX = 0x1109,
    SMARTTHINGS_INC = 0x110a,
    EM_LITE_LTD = 0x110b,
    OSRAM_SYLVANIA = 0x110c,
    TWO_SAVE_ENERGY_LTD = 0x110d,
    PLANET_INNOVATION_PRODUCTS_PTY_LTD = 0x110e,
    AMBIENT_DEVICES_INC = 0x110f,
    PROFALUX = 0x1110,
    BILLION_ELECTRIC_COMPANY_BEC = 0x1111,
    EMBERTEC_PTY_LTD = 0x1112,
    IT_WATCHDOGS = 0x1113,
    RELOC = 0x1114,
    INTEL_CORPORATION = 0x1115,
    TREND_ELECTRONICS_LIMITED = 0x1116,
    MOXA = 0x1117,
    QEES = 0x1118,
    SAYME_WIRELESS_SENSOR_NETWORKS = 0x1119,
    PENTAIR_AQUATIC_SYSTEMS = 0x111a,
    ORBIT_IRRIGATION = 0x111b,
    CALIFORNIA_EASTERN_LABORATORIES = 0x111c,
    COMCAST_2 = 0x111d,
    IDT_TECHNOLOGY_LIMITED = 0x111e,
    PIXELA_CORPORATION = 0x111f,
    TIVO_INC = 0x1120,
    FIDURE_CORP = 0x1121,
    MARVELL_SEMICONDUCTOR_INC = 0x1122,
    WASION_GROUP_LIMITED = 0x1123,
    JASCO_PRODUCTS_COMPANY = 0x1124,
    SHENZHEN_KAIFA_TECHNOLOGY_CHENGDU_CO_LTD = 0x1125,
    NETCOMM_WIRELESS_LIMITED = 0x1126,
    DEFINE_INSTRUMENTS_LIMITED = 0x1127,
    IN_HOME_DISPLAYS_LTD = 0x1128,
    MIELE_AND_CIE_KG = 0x1129,
    TELEVES_S_A = 0x112a,
    LABELEC = 0x112b,
    CHINA_ELECTRONICS_STANDARDIZATION_INSTITUTE = 0x112c,
    VECTORFORM_LLC = 0x112d,
    BUSCH_JAEGER_ELEKTRO = 0x112e,
    REDPINE_SIGNALS_INC = 0x112f,
    BRIDGES_ELECTRONIC_TECHNOLOGY_PTY_LTD = 0x1130,
    SERCOMM = 0x1131,
    WSH_GMBH_WIRSINDHELLER = 0x1132,
    BOSCH_SECURITY_SYSTEMS_INC = 0x1133,
    EZEX_CORPORATION = 0x1134,
    DRESDEN_ELEKTRONIK_INGENIEURTECHNIK_GMBH = 0x1135,
    MEAZON_S_A = 0x1136,
    CROW_ELECTRONIC_ENGINEERING_LTD = 0x1137,
    HARVARD_ENGINEERING_PLC = 0x1138,
    ANDSON_BEIJING_TECHNOLOGY_CO_LTD = 0x1139,
    ADHOCO_AG = 0x113a,
    WAXMAN_CONSUMER_PRODUCTS_GROUP_INC = 0x113b,
    OWON_TECHNOLOGY_INC = 0x113c,
    HITRON_TECHNOLOGIES_INC = 0x113d,
    SCEMTEC_HARD_UND_SOFTWARE_FUR_MESS_UND_STEUERUNGSTECHNIK_GMBH = 0x113e,
    WEBEE_LLC = 0x113f,
    GRID2HOME_INC = 0x1140,
    TELINK_MICRO = 0x1141,
    JASMINE_SYSTEMS_INC = 0x1142,
    BIDGELY = 0x1143,
    LUTRON = 0x1144,
    IJENKO = 0x1145,
    STARFIELD_ELECTRONIC_LTD = 0x1146,
    TCP_INC = 0x1147,
    ROGERS_COMMUNICATIONS_PARTNERSHIP = 0x1148,
    CREE_INC = 0x1149,
    ROBERT_BOSCH_LLC = 0x114a,
    IBIS_NETWORKS_INC = 0x114b,
    QUIRKY_INC = 0x114c,
    EFERGY_TECHNOLOGIES_LIMITED = 0x114d,
    SMARTLABS_INC = 0x114e,
    EVERSPRING_INDUSTRY_CO_LTD = 0x114f,
    SWANN_COMMUNICATIONS_PTL_LTD = 0x1150,
    SONETER = 0x1151,
    SAMSUNG_SDS = 0x1152,
    UNIBAND_ELECTRONIC_CORPORATION = 0x1153,
    ACCTON_TECHNOLOGY_CORPORATION = 0x1154,
    BOSCH_THERMOTECHNIK_GMBH = 0x1155,
    WINCOR_NIXDORF_INC = 0x1156,
    OHSUNG_ELECTRONICS = 0x1157,
    ZEN_WITHIN_INC = 0x1158,
    TECH4HOME_LDA = 0x1159,
    NANOLEAF = 0x115a,
    KEEN_HOME_INC = 0x115b,
    POLY_CONTROL_APS = 0x115c,
    EASTFIELD_LIGHTING_CO_LTD_SHENZHEN = 0x115d,
    IP_DATATEL_INC = 0x115e,
    LUMI_UNITED_TECHOLOGY_LTD_SHENZHEN = 0x115f,
    SENGLED_CO_LTD = 0x1160,
    REMOTE_SOLUTION_CO_LTD = 0x1161,
    ABB_GENWAY_XIAMEN_ELECTRICAL_EQUIPMENT_CO_LTD = 0x1162,
    ZHEJIANG_REXENSE_TECH = 0x1163,
    FOREE_TECHNOLOGY = 0x1164,
    OPEN_ACCESS_TECHNOLOGY_INTL = 0x1165,
    INNR_LIGHTING_BV = 0x1166,
    TECHWORLD_INDUSTRIES = 0x1167,
    LEEDARSON_LIGHTING_CO_LTD = 0x1168,
    ARZEL_ZONING = 0x1169,
    HOLLEY_TECHNOLOGY = 0x116a,
    BELDON_TECHNOLOGIES = 0x116b,
    FLEXTRONICS = 0x116c,
    SHENZHEN_MEIAN = 0x116d,
    LOWES = 0x116e,
    SIGMA_CONNECTIVITY = 0x116f,
    WULIAN = 0x1171,
    PLUGWISE_B_V = 0x1172,
    TITAN_PRODUCTS = 0x1173,
    ECOSPECTRAL = 0x1174,
    D_LINK = 0x1175,
    TECHNICOLOR_HOME_USA = 0x1176,
    OPPLE_LIGHTING = 0x1177,
    WISTRON_NEWEB_CORP = 0x1178,
    QMOTION_SHADES = 0x1179,
    INSTA_GMBH = 0x117a,
    SHANGHAI_VANCOUNT = 0x117b,
    IKEA_OF_SWEDEN = 0x117c,
    RT_RK = 0x117d,
    SHENZHEN_FEIBIT = 0x117e,
    EUCONTROLS = 0x117f,
    TELKONET = 0x1180,
    THERMAL_SOLUTION_RESOURCES = 0x1181,
    POMCUBE = 0x1182,
    EI_ELECTRONICS = 0x1183,
    OPTOGA = 0x1184,
    STELPRO = 0x1185,
    LYNXUS_TECHNOLOGIES_CORP = 0x1186,
    SEMICONDUCTOR_COMPONENTS = 0x1187,
    TP_LINK = 0x1188,
    LEDVANCE_GMBH = 0x1189,
    NORTEK = 0x118a,
    IREVO_ASSA_ABBLOY_KOREA = 0x118b,
    MIDEA = 0x118c,
    ZF_FRIEDRICHSHAFEN = 0x118d,
    CHECKIT = 0x118e,
    ACLARA = 0x118f,
    NOKIA = 0x1190,
    GOLDCARD_HIGH_TECH_CO_LTD = 0x1191,
    GEORGE_WILSON_INDUSTRIES_LTD = 0x1192,
    EASY_SAVER_CO_INC = 0x1193,
    ZTE_CORPORATION = 0x1194,
    ARRIS = 0x1195,
    RELIANCE_BIG_TV = 0x1196,
    INSIGHT_ENERGY_VENTURES_POWERLEY = 0x1197,
    THOMAS_RESEARCH_PRODUCTS_HUBBELL_LIGHTING_INC = 0x1198,
    LI_SENG_TECHNOLOGY = 0x1199,
    SYSTEM_LEVEL_SOLUTIONS_INC = 0x119a,
    MATRIX_LABS = 0x119b,
    SINOPE_TECHNOLOGIES = 0x119c,
    JIUZHOU_GREEBLE = 0x119d,
    GUANGZHOU_LANVEE_TECH_CO_LTD = 0x119e,
    VENSTAR = 0x119f,
    SLV = 0x1200,
    HALO_SMART_LABS = 0x1201,
    SCOUT_SECURITY_INC = 0x1202,
    ALIBABA_CHINA_INC = 0x1203,
    RESOLUTION_PRODUCTS_INC = 0x1204,
    SMARTLOK_INC = 0x1205,
    LUX_PRODUCTS_CORP = 0x1206,
    VIMAR_SPA = 0x1207,
    UNIVERSAL_LIGHTING_TECHNOLOGIES = 0x1208,
    ROBERT_BOSCH_GMBH = 0x1209,
    ACCENTURE = 0x120a,
    HEIMAN_TECHNOLOGY_CO_LTD = 0x120b,
    SHENZHEN_HOMA_TECHNOLOGY_CO_LTD = 0x120c,
    VISION_ELECTRONICS_TECHNOLOGY = 0x120d,
    LENOVO = 0x120e,
    PRESCIENSE_RANDD = 0x120f,
    SHENZHEN_SEASTAR_INTELLIGENCE_CO_LTD = 0x1210,
    SENSATIVE_AB = 0x1211,
    SOLAREDGE = 0x1212,
    ZIPATO = 0x1213,
    CHINA_FIRE_AND_SECURITY_SENSING_MANUFACTURING_IHORN = 0x1214,
    QUBY_BV = 0x1215,
    HANGZHOU_ROOMBANKER_TECHNOLOGY_CO_LTD = 0x1216,
    AMAZON_LAB126 = 0x1217,
    PAULMANN_LICHT_GMBH = 0x1218,
    SHENZHEN_ORVIBO_ELECTRONICS_CO_LTD = 0x1219,
    TCI_TELECOMMUNICATIONS = 0x121a,
    MUELLER_LICHT_INTERNATIONAL_INC = 0x121b,
    AURORA_LIMITED = 0x121c,
    SMARTDCC = 0x121d,
    SHANGHAI_UMEINFO_CO_LTD = 0x121e,
    CARBONTRACK = 0x121f,
    SOMFY = 0x1220,
    VIESSMANN_ELEKTRONIK_GMBH = 0x1221,
    HILDEBRAND_TECHNOLOGY_LTD = 0x1222,
    ONKYO_TECHNOLOGY_CORPORATION = 0x1223,
    SHENZHEN_SUNRICHER_TECHNOLOGY_LTD = 0x1224,
    XIU_XIU_TECHNOLOGY_CO_LTD = 0x1225,
    ZUMTOBEL_GROUP = 0x1226,
    SHENZHEN_KAADAS_INTELLIGENT_TECHNOLOGY_CO_LTD = 0x1227,
    SHANGHAI_XIAOYAN_TECHNOLOGY_CO_LTD = 0x1228,
    CYPRESS_SEMICONDUCTOR = 0x1229,
    XAL_GMBH = 0x122a,
    INERGY_SYSTEMS_LLC = 0x122b,
    ALFRED_KARCHER_GMBH_AND_CO_KG = 0x122c,
    ADUROLIGHT_MANUFACTURING = 0x122d,
    GROUPE_MULLER = 0x122e,
    V_MARK_ENTERPRISES_INC = 0x122f,
    LEAD_ENERGY_AG = 0x1230,
    ULTIMATE_IOT_HENAN_TECHNOLOGY_LTD = 0x1231,
    AXXESS_INDUSTRIES_INC = 0x1232,
    THIRD_REALITY_INC = 0x1233,
    DSR_CORPORATION = 0x1234,
    GUANGZHOU_VENSI_INTELLIGENT_TECHNOLOGY_CO_LTD = 0x1235,
    SCHLAGE_LOCK_ALLEGION = 0x1236,
    NET2GRID = 0x1237,
    AIRAM_ELECTRIC_OY_AB = 0x1238,
    IMMAX_WPB_CZ = 0x1239,
    ZIV_AUTOMATION = 0x123a,
    HANGZHOU_IMAGICTECHNOLOGY_CO_LTD = 0x123b,
    XIAMEN_LEELEN_TECHNOLOGY_CO_LTD = 0x123c,
    OVERKIZ_SAS = 0x123d,
    FLONIDAN_A_S = 0x123e,
    HDL_AUTOMATION_CO_LTD = 0x123f,
    ARDOMUS_NETWORKS_CORPORATION = 0x1240,
    SAMJIN_CO_LTD = 0x1241,
    FIREANGEL_SAFETY_TECHNOLOGY_PLC = 0x1242,
    INDRA_SISTEMAS_S_A = 0x1243,
    SHENZHEN_JBT_SMART_LIGHTING_CO_LTD = 0x1244,
    GE_LIGHTING_AND_CURRENT = 0x1245,
    DANFOSS_A_S = 0x1246,
    NIVISS_PHP_SP_Z_O_O_SP_K = 0x1247,
    SHENZHEN_FENGLIYUAN_ENERGY_CONSERVATING_TECHNOLOGY_CO_LTD = 0x1248,
    NEXELEC = 0x1249,
    SICHUAN_BEHOME_PROMINENT_TECHNOLOGY_CO_LTD = 0x124a,
    FUJIAN_STAR_NET_COMMUNICATION_CO_LTD = 0x124b,
    TOSHIBA_VISUAL_SOLUTIONS_CORPORATION = 0x124c,
    LATCHABLE_INC = 0x124d,
    LANDS_DEUTSCHLAND_GMBH = 0x124e,
    GLEDOPTO_CO_LTD = 0x124f,
    THE_HOME_DEPOT = 0x1250,
    NEONLITE_DISTRIBUTION_LIMITED = 0x1251,
    ARLO_TECHNOLOGIES_INC = 0x1252,
    XINGLUO_TECHNOLOGY_CO_LTD = 0x1253,
    SIMON_ELECTRIC_CHINA_CO_LTD = 0x1254,
    HANGZHOU_GREATSTAR_INDUSTRIAL_CO_LTD = 0x1255,
    SEQUENTRIC_ENERGY_SYSTEMS_LLC = 0x1256,
    SOLUM_CO_LTD = 0x1257,
    EAGLERISE_ELECTRIC_AND_ELECTRONIC_CHINA_CO_LTD = 0x1258,
    FANTEM_TECHNOLOGIES_SHENZHEN_CO_LTD = 0x1259,
    YUNDING_NETWORK_TECHNOLOGY_BEIJING_CO_LTD = 0x125a,
    ATLANTIC_GROUP = 0x125b,
    XIAMEN_INTRETECH_INC = 0x125c,
    TUYA_GLOBAL_INC = 0x125d,
    DNAKE_XIAMEN_INTELLIGENT_TECHNOLOGY_CO_LTD = 0x125e,
    NIKO_NV = 0x125f,
    EMPORIA_ENERGY = 0x1260,
    SIKOM_AS = 0x1261,
    AXIS_LABS_INC = 0x1262,
    CURRENT_PRODUCTS_CORPORATION = 0x1263,
    METERSIT_SRL = 0x1264,
    HORNBACH_BAUMARKT_AG = 0x1265,
    DICEWORLD_S_R_L_A_SOCIO_UNICO = 0x1266,
    ARC_TECHNOLOGY_CO_LTD = 0x1267,
    HANGZHOU_KONKE_INFORMATION_TECHNOLOGY_CO_LTD = 0x1268,
    SALTO_SYSTEMS_S_L = 0x1269,
    SHENZHEN_SHYUGJ_TECHNOLOGY_CO_LTD = 0x126a,
    BRAYDEN_AUTOMATION_CORPORATION = 0x126b,
    ENVIRONEXUS_PTY_LTD = 0x126c,
    ELTRA_NV_SA = 0x126d,
    XIAOMI_COMMUNICATIONS_CO_LTD = 0x126e,
    SHANGHAI_SHUNCOM_ELECTRONIC_TECHNOLOGY_CO_LTD = 0x126f,
    VOLTALIS_S_A = 0x1270,
    FEELUX_CO_LTD = 0x1271,
    SMARTPLUS_INC = 0x1272,
    HALEMEIER_GMBH = 0x1273,
    TRUST_INTERNATIONAL_BV = 0x1274,
    DUKE_ENERGY_BUSINESS_SERVICES_LLC = 0x1275,
    CALIX_INC = 0x1276,
    ADEO = 0x1277,
    CONNECTED_RESPONSE_LIMITED = 0x1278,
    STROYENERGOKOM_LTD = 0x1279,
    LUMITECH_LIGHTING_SOLUTION_GMBH = 0x127a,
    VERDANT_ENVIRONMENTAL_TECHNOLOGIES = 0x127b,
    ALFRED_INTERNATIONAL_INC = 0x127c,
    SANSI_LED_LIGHTING_CO_LTD = 0x127d,
    MINDTREE_LIMITED = 0x127e,
    NORDIC_SEMICONDUCTOR_ASA = 0x127f,
    SITERWELL_ELECTRONICS_CO_LIMITED = 0x1280,
    BRILONER_LEUCHTEN_GMBH_AND_CO_KG = 0x1281,
    SHENZHEN_SEI_TECHNOLOGY_CO_LTD = 0x1282,
    COPPER_LABS_INC = 0x1283,
    DELTA_DORE = 0x1284,
    HAGER_GROUP = 0x1285,
    SHENZHEN_COOLKIT_TECHNOLOGY_CO_LTD = 0x1286,
    HANGZHOU_SKY_LIGHTING_CO_LTD = 0x1287,
    E_ON_SE = 0x1288,
    LIDL_STIFTUNG_AND_CO_KG = 0x1289,
    SICHUAN_CHANGHONG_NETWORK_TECHNOLOGIES_CO_LTD = 0x128a,
    NODON = 0x128b,
    JIANGXI_INNOTECH_TECHNOLOGY_CO_LTD = 0x128c,
    MERCATOR_PTY_LTD = 0x128d,
    BEIJING_RUYING_TECH_LIMITED = 0x128e,
    EGLO_LEUCHTEN_GMBH = 0x128f,
    PIETRO_FIORENTINI_S_P_A = 0x1290,
    ZEHNDER_GROUP_VAUX_ANDIGNY = 0x1291,
    BRK_BRANDS_INC = 0x1292,
    ASKEY_COMPUTER_CORP = 0x1293,
    PASSIVEBOLT_INC = 0x1294,
    AVM_AUDIOVISUELLES_MARKETING_UND_COMPUTERSYSTEME_BERLIN = 0x1295,
    NINGBO_SUNTECH_LIGHTING_TECHNOLOGY_CO_LTD = 0x1296,
    SOCIETE_EN_COMMANDITE_STELLO = 0x1297,
    VIVINT_SMART_HOME = 0x1298,
    NAMRON_AS = 0x1299,
    RADEMACHER_GERAETE_ELEKTRONIK_GMBH = 0x129a,
    OMO_SYSTEMS_LTD = 0x129b,
    SIGLIS_AG = 0x129c,
    IMHOTEP_CREATION = 0x129d,
    ICASA = 0x129e,
    LEVEL_HOME_INC = 0x129f,
    TIS_CONTROL_LIMITED = 0x1300,
    RADISYS_INDIA_PVT_LTD = 0x1301,
    VEEA_INC = 0x1302,
    FELL_TECHNOLOGY_AS = 0x1303,
    SOWILO_DESIGN_SERVICES_LTD = 0x1304,
    LEXI_DEVICES_INC = 0x1305,
    LIFI_LABS_INC_DBA_LIFX = 0x1306,
    GRUNDFOS_HOLDING_A_S = 0x1307,
    SOURCING_AND_CREATION = 0x1308,
    KRAKEN_TECHNOLOGIES_LTD = 0x1309,
    EVE_SYSTEMS = 0x130a,
    LITE_ON_TECHNOLOGY_CORPORATION = 0x130b,
    FOCALCREST_LIMITED = 0x130c,
    BOUFFALO_LAB_NANJING_CO_LTD = 0x130d,
    WYZE_LABS_INC = 0x130e,
    Z_WAVE_EUROPE_GMBH = 0x130f,
    AEOTEC_LIMITED = 0x1310,
    NGSTB_COMPANY_LIMITED = 0x1311,
    QINGDAO_YEELINK_INFORMATION_TECHNOLOGY_CO_LTD = 0x1312,
    E_SMART_HOME_AUTOMATION_SYSTEMS_LIMITED = 0x1313,
    FIBAR_GROUP_S_A = 0x1314,
    PROLITECH_GMBH = 0x1315,
    PANKORE_INTEGRATED_CIRCUIT_TECHNOLOGY_CO_LTD = 0x1316,
    LOGITECH = 0x1317,
    PIARO_INC = 0x1318,
    MITSUBISHI_ELECTRIC_US_INC = 0x1319,
    RESIDEO_TECHNOLOGIES_INC = 0x131a,
    ESPRESSIF_SYSTEMS_SHANGHAI_CO_LTD = 0x131b,
    HELLA_SONNEN_UND_WETTERSCHUTZTECHNIK_GMBH = 0x131c,
    GEBERIT_INTERNATIONAL_AG = 0x131d,
    CAME_S_P_A = 0x131e,
    GUANGZHOU_ELITE_EDUCATION_AND_TECHNOLOGY_CO_LTD = 0x131f,
    PHYPLUS_MICROELECTRONICS_LIMITED = 0x1320,
    SHENZHEN_SONOFF_TECHNOLOGIES_CO_LTD = 0x1321,
    SAFE4_SECURITY_GROUP = 0x1322,
    SHANGHAI_MXCHIP_INFORMATION_TECHNOLOGY_CO_LTD = 0x1323,
    HDC_I_CONTROLS = 0x1324,
    ZUMA_ARRAY_LIMITED = 0x1325,
    DECELECT = 0x1326,
    MILL_INTERNATIONAL_AS = 0x1327,
    HOMEWIZARD_BV = 0x1328,
    SHENZHEN_TOPBAND_CO_LTD = 0x1329,
    PRESSAC_COMMUNICATIONS_LTD = 0x132a,
    ORIGIN_WIRELESS_INC = 0x132b,
    CONNECTE_AS = 0x132c,
    YOKIS = 0x132d,
    XIAMEN_YANKON_ENERGETIC_LIGHTING_CO_LTD = 0x132e,
    YANDEX_LLC = 0x132f,
    CRITICAL_SOFTWARE_S_A = 0x1330,
    NORTEK_CONTROL = 0x1331,
    BRIGHTAI = 0x1332,
    BECKER_ANTRIEBE_GMBH = 0x1333,
    SHENZHEN_TCL_NEW_TECHNOLOGY_COMPANY_LIMITED = 0x1334,
    DEXATEK_TECHNOLOGY_LTD = 0x1335,
    ELELABS_INTERNATIONAL_LIMITED = 0x1336,
    DATEK_WIRELESS_AS = 0x1337,
    ALDES = 0x1338,
    SAVANT_COMPANY = 0x1339,
    ARISTON_THERMO_GROUP = 0x133a,
    WAREMA_RENKHOFF_SE = 0x133b,
    VTECH_HOLDINGS_LIMITED = 0x133c,
    FUTUREHOME_AS = 0x133d,
    COGNITIVE_SYSTEMS_CORP = 0x133e,
    ASR_MICROELECTRONICS_SHENZHEN_CO_LTD = 0x133f,
    AIRIOS = 0x1340,
    GUANGDONG_OPPO_MOBILE_TELECOMMUNICATIONS_CORP_LTD = 0x1341,
    BEKEN_CORPORATION = 0x1342,
    CORSAIR = 0x1343,
    ELTAKO_GMBH = 0x1344,
    CHENGDU_MEROSS_TECHNOLOGY_CO_LTD = 0x1345,
    RAFAEL_MICROELECTRONICS_INC = 0x1346,
    AUG_WINKHUAS_GMBH_AND_CO_KG = 0x1347,
    QINGDAO_HAIER_TECHNOLOGY_CO_LTD = 0x1348,
    APPLE_INC = 0x1349,
    ROLLEASE_ACMEDA = 0x134a,
    NABU_CASA_INC = 0x134b,
    SIMON_HOLDING = 0x134c,
    KD_NAVIEN = 0x134d,
    TADO_GMBH = 0x134e,
    MEDIOLA_CONNECTED_LIVING_AG = 0x134f,
    POLYNHOME = 0x1350,
    HOORII_TECHNOLOGY_CO_LTD = 0x1351,
    KIMIN_ELECTRONICS_CO_LTD = 0x1353,
    ZYAX_AB = 0x1354,
    BARACODA_SA = 0x1355,
    LENNOX_INTERNATIONAL_INC = 0x1356,
    TELEDATICS_INCORPORATED = 0x1357,
    TOP_VICTORY_INVESTMENTS_LIMITED = 0x1358,
    GOQUAL_INC = 0x1359,
    SIEGENIA_AUBI_KG = 0x135a,
    VIRTUAL_CONNECTED_CONTROLLING_SYSTEM_SINGAPORE_PTE_LTD = 0x135b,
    GIGASET_COMMUNICATIONS_GMBH = 0x135c,
    NUKI_HOME_SOLUTIONS_GMBH = 0x135d,
    DEVICEBOOK_INC = 0x135e,
    CONSUMER_2_0_INC_RENTLY = 0x135f,
    EDISON_LABS_INC_DBA_ORRO = 0x1360,
    INOVELLI = 0x1361,
    DEVERITEC_GMBH = 0x1362,
    CHARTER_COMMUNICATIONS = 0x1363,
    MONOLITHIC_POWER_SYSTEMS_INC = 0x1364,
    NINGBO_DOOYA_MECHANIC_AND_ELECTRONIC_TECHNOLOGY_CO_LTD = 0x1365,
    SHENZHEN_SDMC_TECHNOLOGY_CO_LTD = 0x1366,
    HP_INC = 0x1367,
    MUI_LAB_INC = 0x1368,
    BHTRONICS_S_R_L = 0x1369,
    AKUVOX_XIAMEN_NETWORKS_CO_LTD = 0x136a,
    SBERDEVICES_LTD = 0x152f,
    GEWISS_S_P_A = 0x1994,
    CLIMAX_TECHNOLOGY_CO_LTD = 0x2794,
    GOOGLE_LLC = 0x6006,
    CONNECTIVITY_STANDARDS_ALLIANCE = 0xc5a0,
    CONNECTIVITY_STANDARDS_ALLIANCE_2 = 0xc5a1,
    CONNECTIVITY_STANDARDS_ALLIANCE_3 = 0xc5a2,
    CONNECTIVITY_STANDARDS_ALLIANCE_4 = 0xc5a3,
    CONNECTIVITY_STANDARDS_ALLIANCE_5 = 0xc5a4,
    CONNECTIVITY_STANDARDS_ALLIANCE_6 = 0xc5a5,
    CONNECTIVITY_STANDARDS_ALLIANCE_7 = 0xc5a6,
    CONNECTIVITY_STANDARDS_ALLIANCE_8 = 0xc5a7,
    CONNECTIVITY_STANDARDS_ALLIANCE_9 = 0xc5a8,
    CONNECTIVITY_STANDARDS_ALLIANCE_10 = 0xc5a9,
    CONNECTIVITY_STANDARDS_ALLIANCE_11 = 0xc5aa,
    CONNECTIVITY_STANDARDS_ALLIANCE_12 = 0xc5ab,
    CONNECTIVITY_STANDARDS_ALLIANCE_13 = 0xc5ac,
    CONNECTIVITY_STANDARDS_ALLIANCE_14 = 0xc5ad,
    CONNECTIVITY_STANDARDS_ALLIANCE_15 = 0xc5ae,
    CONNECTIVITY_STANDARDS_ALLIANCE_16 = 0xc5af,
    TEST_VENDOR_1 = 0xfff1,
    TEST_VENDOR_2 = 0xfff2,
    TEST_VENDOR_3 = 0xfff3,
    TEST_VENDOR_4 = 0xfff4,
    RESERVED = 0xfff5,
    RESERVED_1 = 0xfff6,
    RESERVED_2 = 0xfff7,
    RESERVED_3 = 0xfff8,
    RESERVED_4 = 0xfff9,
    RESERVED_5 = 0xfffa,
    RESERVED_6 = 0xfffb,
    RESERVED_7 = 0xfffc,
    RESERVED_8 = 0xfffd,
    RESERVED_9 = 0xfffe,
    RESERVED_10 = 0xffff,

    // Non-CSA-assigned codes
    CUSTOM_PERENIO = 0x007b,
    CUSTOM_LIVOLO = 0x1ad2,
    CUSTOM_SPRUT_DEVICE = 0x6666,
    CUSTOM_LYTKO = 0x7777,
}
