/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrefixListAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrefixListAssociation> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(PrefixListAssociation.getter(PrefixListAssociation::resourceId)).setter(PrefixListAssociation.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOwner").getter(PrefixListAssociation.getter(PrefixListAssociation::resourceOwner)).setter(PrefixListAssociation.setter(Builder::resourceOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwner").unmarshallLocationName("resourceOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, RESOURCE_OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PrefixListAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceId;
    private final String resourceOwner;

    private PrefixListAssociation(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.resourceOwner = builder.resourceOwner;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceOwner() {
        return this.resourceOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrefixListAssociation)) {
            return false;
        }
        PrefixListAssociation other = (PrefixListAssociation)obj;
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceOwner(), other.resourceOwner());
    }

    public final String toString() {
        return ToString.builder((String)"PrefixListAssociation").add("ResourceId", (Object)this.resourceId()).add("ResourceOwner", (Object)this.resourceOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceOwner": {
                return Optional.ofNullable(clazz.cast(this.resourceOwner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceOwner", RESOURCE_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrefixListAssociation, T> g) {
        return obj -> g.apply((PrefixListAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String resourceOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(PrefixListAssociation model) {
            this.resourceId(model.resourceId);
            this.resourceOwner(model.resourceOwner);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceOwner() {
            return this.resourceOwner;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        public PrefixListAssociation build() {
            return new PrefixListAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrefixListAssociation> {
        public Builder resourceId(String var1);

        public Builder resourceOwner(String var1);
    }
}

