/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Byoasn;
import software.amazon.awssdk.services.ec2.model.ByoasnSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIpamByoasnResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeIpamByoasnResponse> {
    private static final SdkField<List<Byoasn>> BYOASNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Byoasns").getter(DescribeIpamByoasnResponse.getter(DescribeIpamByoasnResponse::byoasns)).setter(DescribeIpamByoasnResponse.setter(Builder::byoasns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByoasnSet").unmarshallLocationName("byoasnSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Byoasn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeIpamByoasnResponse.getter(DescribeIpamByoasnResponse::nextToken)).setter(DescribeIpamByoasnResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYOASNS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeIpamByoasnResponse.memberNameToFieldInitializer();
    private final List<Byoasn> byoasns;
    private final String nextToken;

    private DescribeIpamByoasnResponse(BuilderImpl builder) {
        super(builder);
        this.byoasns = builder.byoasns;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasByoasns() {
        return this.byoasns != null && !(this.byoasns instanceof SdkAutoConstructList);
    }

    public final List<Byoasn> byoasns() {
        return this.byoasns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasByoasns() ? this.byoasns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpamByoasnResponse)) {
            return false;
        }
        DescribeIpamByoasnResponse other = (DescribeIpamByoasnResponse)((Object)obj);
        return this.hasByoasns() == other.hasByoasns() && Objects.equals(this.byoasns(), other.byoasns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIpamByoasnResponse").add("Byoasns", this.hasByoasns() ? this.byoasns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Byoasns": {
                return Optional.ofNullable(clazz.cast(this.byoasns()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ByoasnSet", BYOASNS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpamByoasnResponse, T> g) {
        return obj -> g.apply((DescribeIpamByoasnResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<Byoasn> byoasns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpamByoasnResponse model) {
            super(model);
            this.byoasns(model.byoasns);
            this.nextToken(model.nextToken);
        }

        public final List<Byoasn.Builder> getByoasns() {
            List<Byoasn.Builder> result = ByoasnSetCopier.copyToBuilder(this.byoasns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setByoasns(Collection<Byoasn.BuilderImpl> byoasns) {
            this.byoasns = ByoasnSetCopier.copyFromBuilder(byoasns);
        }

        @Override
        public final Builder byoasns(Collection<Byoasn> byoasns) {
            this.byoasns = ByoasnSetCopier.copy(byoasns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byoasns(Byoasn ... byoasns) {
            this.byoasns(Arrays.asList(byoasns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byoasns(Consumer<Byoasn.Builder> ... byoasns) {
            this.byoasns(Stream.of(byoasns).map(c -> (Byoasn)((Byoasn.Builder)Byoasn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeIpamByoasnResponse build() {
            return new DescribeIpamByoasnResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIpamByoasnResponse> {
        public Builder byoasns(Collection<Byoasn> var1);

        public Builder byoasns(Byoasn ... var1);

        public Builder byoasns(Consumer<Byoasn.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

