/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.state;

import com.amazon.randomcutforest.PredictiveRandomCutForest;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.preprocessor.Preprocessor;
import com.amazon.randomcutforest.state.IStateMapper;
import com.amazon.randomcutforest.state.PredictiveRandomCutForestState;
import com.amazon.randomcutforest.state.RandomCutForestMapper;
import com.amazon.randomcutforest.state.preprocessor.PreprocessorMapper;
import com.amazon.randomcutforest.state.preprocessor.PreprocessorState;

public class PredictiveRandomCutForestMapper
implements IStateMapper<PredictiveRandomCutForest, PredictiveRandomCutForestState> {
    @Override
    public PredictiveRandomCutForest toModel(PredictiveRandomCutForestState state, long seed) {
        RandomCutForestMapper randomCutForestMapper = new RandomCutForestMapper();
        PreprocessorMapper preprocessorMapper = new PreprocessorMapper();
        RandomCutForest forest = randomCutForestMapper.toModel(state.getForestState());
        Preprocessor preprocessor = (Preprocessor)preprocessorMapper.toModel(state.getPreprocessorStates()[0]);
        ForestMode forestMode = ForestMode.valueOf(state.getForestMode());
        TransformMethod transformMethod = TransformMethod.valueOf(state.getTransformMethod());
        return new PredictiveRandomCutForest(forestMode, transformMethod, preprocessor, forest);
    }

    @Override
    public PredictiveRandomCutForestState toState(PredictiveRandomCutForest model) {
        PredictiveRandomCutForestState state = new PredictiveRandomCutForestState();
        RandomCutForestMapper randomCutForestMapper = new RandomCutForestMapper();
        randomCutForestMapper.setPartialTreeStateEnabled(true);
        randomCutForestMapper.setSaveTreeStateEnabled(true);
        randomCutForestMapper.setCompressionEnabled(true);
        randomCutForestMapper.setSaveCoordinatorStateEnabled(true);
        randomCutForestMapper.setSaveExecutorContextEnabled(true);
        state.setForestState(randomCutForestMapper.toState(model.getForest()));
        PreprocessorMapper preprocessorMapper = new PreprocessorMapper();
        state.setPreprocessorStates(new PreprocessorState[]{preprocessorMapper.toState((Preprocessor)model.getPreprocessor())});
        state.setForestMode(model.getForestMode().name());
        state.setTransformMethod(model.getTransformMethod().name());
        return state;
    }
}

