/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.datasource;

import java.sql.Connection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import us.fatehi.utility.PropertiesUtility;
import us.fatehi.utility.datasource.DataSourceConnectionSource;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.SimpleDatabaseConnectionSource;
import us.fatehi.utility.datasource.SingleDatabaseConnectionSource;
import us.fatehi.utility.datasource.UserCredentials;

public class DatabaseConnectionSources {
    private static final Logger LOGGER = Logger.getLogger(DatabaseConnectionSources.class.getName());

    public static DatabaseConnectionSource fromDataSource(DataSource dataSource) {
        return new DataSourceConnectionSource(dataSource);
    }

    public static DatabaseConnectionSource newDatabaseConnectionSource(String connectionUrl, Map<String, String> connectionProperties, UserCredentials userCredentials, Consumer<Connection> connectionInitializer) {
        boolean isSingleThreaded = Boolean.valueOf(PropertiesUtility.getSystemConfigurationProperty("SC_SINGLE_THREADED", Boolean.FALSE.toString()));
        if (isSingleThreaded) {
            LOGGER.log(Level.CONFIG, "Loading database schema in the main thread");
            return new SingleDatabaseConnectionSource(connectionUrl, connectionProperties, userCredentials, connectionInitializer);
        }
        LOGGER.log(Level.CONFIG, "Loading database schema using multiple threads");
        return new SimpleDatabaseConnectionSource(connectionUrl, connectionProperties, userCredentials, connectionInitializer);
    }

    public static DatabaseConnectionSource newDatabaseConnectionSource(String connectionUrl, UserCredentials userCredentials) {
        return DatabaseConnectionSources.newDatabaseConnectionSource(connectionUrl, null, userCredentials, connection -> {});
    }

    private DatabaseConnectionSources() {
    }
}

