/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.hsqldb.util.CommonSwing;
import org.hsqldb.util.ConnectionDialogCommon;
import org.hsqldb.util.ConnectionSetting;

class ConnectionDialogSwing
extends JDialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private Connection mConnection;
    private JTextField mName;
    private JTextField mDriver;
    private JTextField mURL;
    private JTextField mUser;
    private JPasswordField mPassword;
    private String[][] connTypes;
    private Hashtable settings;
    private JComboBox mSettingName = new JComboBox(this.loadRecentConnectionSettings());
    private static ConnectionSetting currentConnectionSetting = null;

    public static void setConnectionSetting(ConnectionSetting connectionSetting) {
        currentConnectionSetting = connectionSetting;
    }

    public static Connection createConnection(String string, String string2, String string3, String string4) throws Exception {
        Class.forName(string);
        return DriverManager.getConnection(string2, string3, string4);
    }

    ConnectionDialogSwing(JFrame jFrame, String string) {
        super(jFrame, string, true);
    }

    private void create() {
        Box box = Box.createHorizontalBox();
        Box box2 = Box.createVerticalBox();
        Box box3 = Box.createVerticalBox();
        Box box4 = Box.createHorizontalBox();
        Box box5 = Box.createVerticalBox();
        Box box6 = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(10));
        box.add(Box.createHorizontalGlue());
        box.add(box2);
        box.add(Box.createHorizontalStrut(10));
        box.add(Box.createHorizontalGlue());
        box.add(box3);
        box.add(Box.createHorizontalStrut(10));
        box.add(Box.createVerticalGlue());
        box.add(box6);
        box.add(Box.createVerticalGlue());
        box5.add(Box.createVerticalGlue());
        box5.add(Box.createVerticalStrut(10));
        box5.add(box);
        box5.add(Box.createVerticalGlue());
        box5.add(Box.createVerticalStrut(10));
        box5.add(box4);
        box5.add(Box.createVerticalGlue());
        box5.add(Box.createVerticalStrut(10));
        box5.add(Box.createVerticalGlue());
        box2.add(ConnectionDialogSwing.createLabel("Recent Setting:"));
        box2.add(Box.createVerticalGlue());
        box2.add(ConnectionDialogSwing.createLabel("Setting Name:"));
        box2.add(Box.createVerticalGlue());
        box2.add(ConnectionDialogSwing.createLabel("Type:"));
        box2.add(Box.createVerticalGlue());
        box2.add(ConnectionDialogSwing.createLabel("Driver:"));
        box2.add(Box.createVerticalGlue());
        box2.add(ConnectionDialogSwing.createLabel("URL:"));
        box2.add(Box.createVerticalGlue());
        box2.add(ConnectionDialogSwing.createLabel("User:"));
        box2.add(Box.createVerticalGlue());
        box2.add(ConnectionDialogSwing.createLabel("Password:"));
        box2.add(Box.createVerticalGlue());
        box2.add(Box.createVerticalStrut(10));
        box3.add(Box.createVerticalGlue());
        this.mSettingName.setActionCommand("Select Setting");
        this.mSettingName.addActionListener(this);
        box3.add(this.mSettingName);
        box3.add(Box.createHorizontalGlue());
        this.mName = new JTextField();
        this.mName.addActionListener(this);
        box3.add(this.mName);
        JButton jButton = new JButton("Clear Names");
        jButton.setActionCommand("Clear");
        jButton.addActionListener(this);
        box4.add(jButton);
        box4.add(Box.createHorizontalGlue());
        box4.add(Box.createHorizontalStrut(10));
        JComboBox<String> jComboBox = new JComboBox<String>();
        this.connTypes = ConnectionDialogCommon.getTypes();
        for (int i = 0; i < this.connTypes.length; ++i) {
            jComboBox.addItem(this.connTypes[i][0]);
        }
        jComboBox.addItemListener(this);
        box3.add(jComboBox);
        box3.add(Box.createVerticalGlue());
        this.mDriver = new JTextField(this.connTypes[0][1]);
        this.mDriver.addActionListener(this);
        box3.add(this.mDriver);
        this.mURL = new JTextField(this.connTypes[0][2]);
        this.mURL.addActionListener(this);
        box3.add(this.mURL);
        box3.add(Box.createVerticalGlue());
        this.mUser = new JTextField("SA");
        this.mUser.addActionListener(this);
        box3.add(this.mUser);
        box3.add(Box.createVerticalGlue());
        this.mPassword = new JPasswordField("");
        this.mPassword.addActionListener(this);
        box3.add(this.mPassword);
        box3.add(Box.createVerticalGlue());
        box3.add(Box.createVerticalStrut(10));
        box4.add(Box.createHorizontalGlue());
        box4.add(Box.createHorizontalStrut(10));
        JButton jButton2 = new JButton("     Ok      ");
        jButton2.setActionCommand("ConnectOk");
        jButton2.addActionListener(this);
        box4.add(jButton2);
        this.getRootPane().setDefaultButton(jButton2);
        box4.add(Box.createHorizontalGlue());
        box4.add(Box.createHorizontalStrut(20));
        jButton2 = new JButton("  Cancel   ");
        jButton2.setActionCommand("ConnectCancel");
        jButton2.addActionListener(this);
        box4.add(jButton2);
        box4.add(Box.createHorizontalGlue());
        box4.add(Box.createHorizontalStrut(10));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add("Center", box5);
        this.getContentPane().add("Center", jPanel);
        this.doLayout();
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (currentConnectionSetting != null) {
            this.mName.setText(currentConnectionSetting.getName());
            this.mDriver.setText(currentConnectionSetting.getDriver());
            this.mURL.setText(currentConnectionSetting.getUrl());
            this.mUser.setText(currentConnectionSetting.getUser());
            this.mPassword.setText(currentConnectionSetting.getPassword());
        }
        if (dimension.width >= 640) {
            this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        } else {
            this.setLocation(0, 0);
            this.setSize(dimension);
        }
        this.setVisible(true);
    }

    public static Connection createConnection(JFrame jFrame, String string) {
        ConnectionDialogSwing connectionDialogSwing = new ConnectionDialogSwing(jFrame, string);
        try {
            SwingUtilities.updateComponentTreeUI(connectionDialogSwing);
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
        connectionDialogSwing.create();
        return connectionDialogSwing.mConnection;
    }

    private static JLabel createLabel(String string) {
        return new JLabel(string);
    }

    public Vector loadRecentConnectionSettings() {
        Vector<String> vector = new Vector<String>();
        this.settings = new Hashtable();
        try {
            this.settings = ConnectionDialogCommon.loadRecentConnectionSettings();
            Iterator iterator = this.settings.values().iterator();
            vector.add(ConnectionDialogCommon.emptySettingName);
            while (iterator.hasNext()) {
                vector.add(((ConnectionSetting)iterator.next()).getName());
            }
        }
        catch (IOException iOException) {
            CommonSwing.errorMessage(iOException);
        }
        return vector;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ConnectOk") || actionEvent.getSource() instanceof JTextField) {
            try {
                if (this.mURL.getText().indexOf(171) >= 0) {
                    throw new Exception("please specify db path");
                }
                this.mConnection = ConnectionDialogSwing.createConnection(this.mDriver.getText(), this.mURL.getText(), this.mUser.getText(), new String(this.mPassword.getPassword()));
                if (this.mName.getText() != null && this.mName.getText().trim().length() > 0) {
                    ConnectionSetting connectionSetting = new ConnectionSetting(this.mName.getText(), this.mDriver.getText(), this.mURL.getText(), this.mUser.getText(), new String(this.mPassword.getPassword()));
                    ConnectionDialogCommon.addToRecentConnectionSettings(this.settings, connectionSetting);
                }
                this.dispose();
            }
            catch (SQLException sQLException) {
                this.mConnection = null;
                CommonSwing.errorMessage(sQLException, true);
            }
            catch (Exception exception) {
                CommonSwing.errorMessage(exception);
            }
        } else if (string.equals("Select Setting")) {
            ConnectionSetting connectionSetting;
            String string2 = (String)this.mSettingName.getSelectedItem();
            if (string2 != null && (connectionSetting = (ConnectionSetting)this.settings.get(string2)) != null) {
                this.mName.setText(connectionSetting.getName());
                this.mDriver.setText(connectionSetting.getDriver());
                this.mURL.setText(connectionSetting.getUrl());
                this.mUser.setText(connectionSetting.getUser());
                this.mPassword.setText(connectionSetting.getPassword());
            }
        } else if (string.equals("ConnectCancel")) {
            this.dispose();
        } else if (string.equals("Clear")) {
            ConnectionDialogCommon.deleteRecentConnectionSettings();
            this.settings = new Hashtable();
            this.mSettingName.removeAllItems();
            this.mSettingName.addItem(ConnectionDialogCommon.emptySettingName);
            this.mName.setText(null);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        for (int i = 0; i < this.connTypes.length; ++i) {
            if (!string.equals(this.connTypes[i][0])) continue;
            this.mDriver.setText(this.connTypes[i][1]);
            this.mURL.setText(this.connTypes[i][2]);
        }
    }
}

