/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tasks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import mediathek.config.Daten;
import mediathek.config.StandardLocations;
import mediathek.filmlisten.writer.FilmListWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00012\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lmediathek/gui/tasks/FilmlistWriterWorker;", "Ljavax/swing/SwingWorker;", "Ljava/lang/Void;", "", "Ljava/beans/PropertyChangeListener;", "progLabel", "Ljavax/swing/JLabel;", "progressBar", "Ljavax/swing/JProgressBar;", "(Ljavax/swing/JLabel;Ljavax/swing/JProgressBar;)V", "doInBackground", "propertyChange", "", "evt", "Ljava/beans/PropertyChangeEvent;", "MediathekView"})
public final class FilmlistWriterWorker
extends SwingWorker<Void, Integer>
implements PropertyChangeListener {
    @NotNull
    private final JProgressBar progressBar;

    public FilmlistWriterWorker(@NotNull JLabel progLabel, @NotNull JProgressBar progressBar) {
        Intrinsics.checkNotNullParameter(progLabel, "progLabel");
        Intrinsics.checkNotNullParameter(progressBar, "progressBar");
        this.progressBar = progressBar;
        this.addPropertyChangeListener(this);
        SwingUtilities.invokeLater(() -> FilmlistWriterWorker._init_$lambda$0(progLabel, this));
    }

    @Override
    @Nullable
    protected Void doInBackground() {
        FilmListWriter writer = new FilmListWriter(false);
        writer.writeFilmList(StandardLocations.getFilmlistFilePathString(), Daten.getInstance().getListeFilme(), arg_0 -> FilmlistWriterWorker.doInBackground$lambda$1(this, arg_0));
        return null;
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent evt) {
        Intrinsics.checkNotNullParameter(evt, "evt");
        if (StringsKt.equals(evt.getPropertyName(), "progress", true)) {
            SwingUtilities.invokeLater(() -> FilmlistWriterWorker.propertyChange$lambda$2(this, evt));
        }
    }

    private static final void _init_$lambda$0(JLabel $progLabel, FilmlistWriterWorker this$0) {
        Intrinsics.checkNotNullParameter($progLabel, "$progLabel");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        $progLabel.setText("Schreibe Filmliste");
        this$0.progressBar.setIndeterminate(false);
        this$0.progressBar.setMinimum(0);
        this$0.progressBar.setMaximum(100);
        this$0.progressBar.setValue(0);
    }

    private static final void doInBackground$lambda$1(FilmlistWriterWorker this$0, double prog) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.setProgress(MathKt.roundToInt(100.0 * prog));
    }

    private static final void propertyChange$lambda$2(FilmlistWriterWorker this$0, PropertyChangeEvent $evt) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($evt, "$evt");
        JProgressBar jProgressBar = this$0.progressBar;
        Object object = $evt.getNewValue();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Int");
        jProgressBar.setValue((Integer)object);
    }
}

