/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.comparator;

import java.io.Serializable;
import java.util.Comparator;

public class ComparableComparator
implements Comparator<Object>,
Serializable {
    private static final long serialVersionUID = -291439688585137865L;
    private static final ComparableComparator instance = new ComparableComparator();

    public static ComparableComparator getInstance() {
        return instance;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Comparable) {
            if (o2 instanceof Comparable) {
                int result2;
                int result1;
                try {
                    result1 = ((Comparable)o1).compareTo(o2);
                    result2 = ((Comparable)o2).compareTo(o1);
                }
                catch (ClassCastException e) {
                    return o1.getClass().getName().compareTo(o2.getClass().getName());
                }
                if (result1 == 0 && result2 == 0) {
                    return 0;
                }
                if (result1 < 0 && result2 > 0) {
                    return result1;
                }
                if (result1 > 0 && result2 < 0) {
                    return result1;
                }
                throw new ClassCastException("The two compareTo methods of o1 and o2 returned two inconsistent results. Please make sure sgn(x.compareTo(y)) == -sgn(y.compareTo(x)) for all x and y.");
            }
            throw new ClassCastException("The second argument of this method was not a Comparable: " + o2.getClass().getName());
        }
        if (o2 instanceof Comparable) {
            throw new ClassCastException("The first argument of this method was not a Comparable: " + o1.getClass().getName());
        }
        throw new ClassCastException("Both arguments of this method were not Comparables: " + o1.getClass().getName() + " and " + o2.getClass().getName());
    }
}

